# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[str]] = None,
                 assume_role: Optional[pulumi.Input['ProviderAssumeRoleArgs']] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[str]] = None,
                 skip_credentials_validation: Optional[pulumi.Input[bool]] = None,
                 skip_metadata_api_check: Optional[pulumi.Input[bool]] = None,
                 skip_requesting_account_id: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] region: This is the AWS region. It must be provided, but it can also be sourced from the `AWS_DEFAULT_REGION` environment
               variables, or via a shared credentials file if `profile` is specified.
        :param pulumi.Input[str] access_key: This is the AWS access key. It must be provided, but it can also be sourced from the `AWS_ACCESS_KEY_ID` environment
               variable, or via a shared credentials file if `profile` is specified.
        :param pulumi.Input['ProviderAssumeRoleArgs'] assume_role: Settings for making use of the AWS Assume Role functionality.
        :param pulumi.Input[int] max_retries: This is the maximum number of times an API call is retried, in the case where requests are being throttled or
               experiencing transient failures. The delay between the subsequent API calls increases exponentially. If omitted, the
               default value is `25`.
        :param pulumi.Input[str] profile: This is the AWS profile name as set in the shared credentials file.
        :param pulumi.Input[str] secret_key: This is the AWS secret key. It must be provided, but it can also be sourced from the `AWS_SECRET_ACCESS_KEY` environment
               variable, or via a shared credentials file if `profile` is specified.
        :param pulumi.Input[str] shared_credentials_file: This is the path to the shared credentials file. If this is not set and a profile is specified, `~/.aws/credentials`
               will be used.
        :param pulumi.Input[bool] skip_credentials_validation: Skip the credentials validation via the STS API. Useful for AWS API implementations that do not have STS available or
               implemented.
        :param pulumi.Input[bool] skip_metadata_api_check: Skip the AWS Metadata API check. Useful for AWS API implementations that do not have a metadata API endpoint. Setting to
               `true` prevents Terraform from authenticating via the Metadata API. You may need to use other authentication methods
               like static credentials, configuration variables, or environment variables.
        :param pulumi.Input[bool] skip_requesting_account_id: Skip requesting the account ID. Useful for AWS API implementations that do not have the IAM, STS API, or metadata API.
        :param pulumi.Input[str] token: Session token for validating temporary credentials. Typically provided after successful identity federation or
               Multi-Factor Authentication (MFA) login. With MFA login, this is the session token provided afterward, not the 6 digit
               MFA code used to get temporary credentials. It can also be sourced from the `AWS_SESSION_TOKEN` environment variable.
        """
        pulumi.set(__self__, "region", region)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if shared_credentials_file is not None:
            pulumi.set(__self__, "shared_credentials_file", shared_credentials_file)
        if skip_credentials_validation is not None:
            pulumi.set(__self__, "skip_credentials_validation", skip_credentials_validation)
        if skip_metadata_api_check is not None:
            pulumi.set(__self__, "skip_metadata_api_check", skip_metadata_api_check)
        if skip_requesting_account_id is not None:
            pulumi.set(__self__, "skip_requesting_account_id", skip_requesting_account_id)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        This is the AWS region. It must be provided, but it can also be sourced from the `AWS_DEFAULT_REGION` environment
        variables, or via a shared credentials file if `profile` is specified.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        This is the AWS access key. It must be provided, but it can also be sourced from the `AWS_ACCESS_KEY_ID` environment
        variable, or via a shared credentials file if `profile` is specified.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[pulumi.Input['ProviderAssumeRoleArgs']]:
        """
        Settings for making use of the AWS Assume Role functionality.
        """
        return pulumi.get(self, "assume_role")

    @assume_role.setter
    def assume_role(self, value: Optional[pulumi.Input['ProviderAssumeRoleArgs']]):
        pulumi.set(self, "assume_role", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        This is the maximum number of times an API call is retried, in the case where requests are being throttled or
        experiencing transient failures. The delay between the subsequent API calls increases exponentially. If omitted, the
        default value is `25`.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        This is the AWS profile name as set in the shared credentials file.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        This is the AWS secret key. It must be provided, but it can also be sourced from the `AWS_SECRET_ACCESS_KEY` environment
        variable, or via a shared credentials file if `profile` is specified.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="sharedCredentialsFile")
    def shared_credentials_file(self) -> Optional[pulumi.Input[str]]:
        """
        This is the path to the shared credentials file. If this is not set and a profile is specified, `~/.aws/credentials`
        will be used.
        """
        return pulumi.get(self, "shared_credentials_file")

    @shared_credentials_file.setter
    def shared_credentials_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_credentials_file", value)

    @property
    @pulumi.getter(name="skipCredentialsValidation")
    def skip_credentials_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip the credentials validation via the STS API. Useful for AWS API implementations that do not have STS available or
        implemented.
        """
        return pulumi.get(self, "skip_credentials_validation")

    @skip_credentials_validation.setter
    def skip_credentials_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_credentials_validation", value)

    @property
    @pulumi.getter(name="skipMetadataApiCheck")
    def skip_metadata_api_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip the AWS Metadata API check. Useful for AWS API implementations that do not have a metadata API endpoint. Setting to
        `true` prevents Terraform from authenticating via the Metadata API. You may need to use other authentication methods
        like static credentials, configuration variables, or environment variables.
        """
        return pulumi.get(self, "skip_metadata_api_check")

    @skip_metadata_api_check.setter
    def skip_metadata_api_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_metadata_api_check", value)

    @property
    @pulumi.getter(name="skipRequestingAccountId")
    def skip_requesting_account_id(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip requesting the account ID. Useful for AWS API implementations that do not have the IAM, STS API, or metadata API.
        """
        return pulumi.get(self, "skip_requesting_account_id")

    @skip_requesting_account_id.setter
    def skip_requesting_account_id(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_requesting_account_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Session token for validating temporary credentials. Typically provided after successful identity federation or
        Multi-Factor Authentication (MFA) login. With MFA login, this is the session token provided afterward, not the 6 digit
        MFA code used to get temporary credentials. It can also be sourced from the `AWS_SESSION_TOKEN` environment variable.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 assume_role: Optional[pulumi.Input[pulumi.InputType['ProviderAssumeRoleArgs']]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[str]] = None,
                 skip_credentials_validation: Optional[pulumi.Input[bool]] = None,
                 skip_metadata_api_check: Optional[pulumi.Input[bool]] = None,
                 skip_requesting_account_id: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the awscontroltower package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: This is the AWS access key. It must be provided, but it can also be sourced from the `AWS_ACCESS_KEY_ID` environment
               variable, or via a shared credentials file if `profile` is specified.
        :param pulumi.Input[pulumi.InputType['ProviderAssumeRoleArgs']] assume_role: Settings for making use of the AWS Assume Role functionality.
        :param pulumi.Input[int] max_retries: This is the maximum number of times an API call is retried, in the case where requests are being throttled or
               experiencing transient failures. The delay between the subsequent API calls increases exponentially. If omitted, the
               default value is `25`.
        :param pulumi.Input[str] profile: This is the AWS profile name as set in the shared credentials file.
        :param pulumi.Input[str] region: This is the AWS region. It must be provided, but it can also be sourced from the `AWS_DEFAULT_REGION` environment
               variables, or via a shared credentials file if `profile` is specified.
        :param pulumi.Input[str] secret_key: This is the AWS secret key. It must be provided, but it can also be sourced from the `AWS_SECRET_ACCESS_KEY` environment
               variable, or via a shared credentials file if `profile` is specified.
        :param pulumi.Input[str] shared_credentials_file: This is the path to the shared credentials file. If this is not set and a profile is specified, `~/.aws/credentials`
               will be used.
        :param pulumi.Input[bool] skip_credentials_validation: Skip the credentials validation via the STS API. Useful for AWS API implementations that do not have STS available or
               implemented.
        :param pulumi.Input[bool] skip_metadata_api_check: Skip the AWS Metadata API check. Useful for AWS API implementations that do not have a metadata API endpoint. Setting to
               `true` prevents Terraform from authenticating via the Metadata API. You may need to use other authentication methods
               like static credentials, configuration variables, or environment variables.
        :param pulumi.Input[bool] skip_requesting_account_id: Skip requesting the account ID. Useful for AWS API implementations that do not have the IAM, STS API, or metadata API.
        :param pulumi.Input[str] token: Session token for validating temporary credentials. Typically provided after successful identity federation or
               Multi-Factor Authentication (MFA) login. With MFA login, this is the session token provided afterward, not the 6 digit
               MFA code used to get temporary credentials. It can also be sourced from the `AWS_SESSION_TOKEN` environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the awscontroltower package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 assume_role: Optional[pulumi.Input[pulumi.InputType['ProviderAssumeRoleArgs']]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[str]] = None,
                 skip_credentials_validation: Optional[pulumi.Input[bool]] = None,
                 skip_metadata_api_check: Optional[pulumi.Input[bool]] = None,
                 skip_requesting_account_id: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["assume_role"] = pulumi.Output.from_input(assume_role).apply(pulumi.runtime.to_json) if assume_role is not None else None
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["profile"] = profile
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_key"] = secret_key
            __props__.__dict__["shared_credentials_file"] = shared_credentials_file
            __props__.__dict__["skip_credentials_validation"] = pulumi.Output.from_input(skip_credentials_validation).apply(pulumi.runtime.to_json) if skip_credentials_validation is not None else None
            __props__.__dict__["skip_metadata_api_check"] = pulumi.Output.from_input(skip_metadata_api_check).apply(pulumi.runtime.to_json) if skip_metadata_api_check is not None else None
            __props__.__dict__["skip_requesting_account_id"] = pulumi.Output.from_input(skip_requesting_account_id).apply(pulumi.runtime.to_json) if skip_requesting_account_id is not None else None
            __props__.__dict__["token"] = token
        super(Provider, __self__).__init__(
            'awscontroltower',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[str]]:
        """
        This is the AWS access key. It must be provided, but it can also be sourced from the `AWS_ACCESS_KEY_ID` environment
        variable, or via a shared credentials file if `profile` is specified.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[str]]:
        """
        This is the AWS profile name as set in the shared credentials file.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        This is the AWS region. It must be provided, but it can also be sourced from the `AWS_DEFAULT_REGION` environment
        variables, or via a shared credentials file if `profile` is specified.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        This is the AWS secret key. It must be provided, but it can also be sourced from the `AWS_SECRET_ACCESS_KEY` environment
        variable, or via a shared credentials file if `profile` is specified.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="sharedCredentialsFile")
    def shared_credentials_file(self) -> pulumi.Output[Optional[str]]:
        """
        This is the path to the shared credentials file. If this is not set and a profile is specified, `~/.aws/credentials`
        will be used.
        """
        return pulumi.get(self, "shared_credentials_file")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        Session token for validating temporary credentials. Typically provided after successful identity federation or
        Multi-Factor Authentication (MFA) login. With MFA login, this is the session token provided afterward, not the 6 digit
        MFA code used to get temporary credentials. It can also be sourced from the `AWS_SESSION_TOKEN` environment variable.
        """
        return pulumi.get(self, "token")

