# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ControlTowerAwsAccountArgs', 'ControlTowerAwsAccount']

@pulumi.input_type
class ControlTowerAwsAccountArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 organizational_unit: pulumi.Input[str],
                 sso: pulumi.Input['ControlTowerAwsAccountSsoArgs'],
                 close_account_on_delete: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizational_unit_id_on_delete: Optional[pulumi.Input[str]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ControlTowerAwsAccount resource.
        :param pulumi.Input[str] email: Root email of the account.
        :param pulumi.Input[str] organizational_unit: Name of the Organizational Unit under which the account resides.
        :param pulumi.Input['ControlTowerAwsAccountSsoArgs'] sso: Assigned SSO user settings.
        :param pulumi.Input[bool] close_account_on_delete: If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
               account will just be unenrolled from Control Tower.
        :param pulumi.Input[str] name: Name of the account.
        :param pulumi.Input[str] organizational_unit_id_on_delete: ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
               provided, the account will not be moved.
        :param pulumi.Input[str] path_id: Name of the path identifier of the product. This value is optional if the product has a default path, and required if
               the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        :param pulumi.Input[str] provisioned_product_name: Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags for the account.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "organizational_unit", organizational_unit)
        pulumi.set(__self__, "sso", sso)
        if close_account_on_delete is not None:
            pulumi.set(__self__, "close_account_on_delete", close_account_on_delete)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organizational_unit_id_on_delete is not None:
            pulumi.set(__self__, "organizational_unit_id_on_delete", organizational_unit_id_on_delete)
        if path_id is not None:
            pulumi.set(__self__, "path_id", path_id)
        if provisioned_product_name is not None:
            pulumi.set(__self__, "provisioned_product_name", provisioned_product_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        Root email of the account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> pulumi.Input[str]:
        """
        Name of the Organizational Unit under which the account resides.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Input['ControlTowerAwsAccountSsoArgs']:
        """
        Assigned SSO user settings.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: pulumi.Input['ControlTowerAwsAccountSsoArgs']):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter(name="closeAccountOnDelete")
    def close_account_on_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
        account will just be unenrolled from Control Tower.
        """
        return pulumi.get(self, "close_account_on_delete")

    @close_account_on_delete.setter
    def close_account_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_account_on_delete", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationalUnitIdOnDelete")
    def organizational_unit_id_on_delete(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
        provided, the account will not be moved.
        """
        return pulumi.get(self, "organizational_unit_id_on_delete")

    @organizational_unit_id_on_delete.setter
    def organizational_unit_id_on_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_id_on_delete", value)

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the path identifier of the product. This value is optional if the product has a default path, and required if
        the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        """
        return pulumi.get(self, "path_id")

    @path_id.setter
    def path_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_id", value)

    @property
    @pulumi.getter(name="provisionedProductName")
    def provisioned_product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        """
        return pulumi.get(self, "provisioned_product_name")

    @provisioned_product_name.setter
    def provisioned_product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_product_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags for the account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ControlTowerAwsAccountState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 close_account_on_delete: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 organizational_unit_id_on_delete: Optional[pulumi.Input[str]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[str]] = None,
                 sso: Optional[pulumi.Input['ControlTowerAwsAccountSsoArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ControlTowerAwsAccount resources.
        :param pulumi.Input[str] account_id: ID of the AWS account.
        :param pulumi.Input[bool] close_account_on_delete: If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
               account will just be unenrolled from Control Tower.
        :param pulumi.Input[str] email: Root email of the account.
        :param pulumi.Input[str] name: Name of the account.
        :param pulumi.Input[str] organizational_unit: Name of the Organizational Unit under which the account resides.
        :param pulumi.Input[str] organizational_unit_id_on_delete: ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
               provided, the account will not be moved.
        :param pulumi.Input[str] path_id: Name of the path identifier of the product. This value is optional if the product has a default path, and required if
               the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        :param pulumi.Input[str] provisioned_product_name: Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        :param pulumi.Input['ControlTowerAwsAccountSsoArgs'] sso: Assigned SSO user settings.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags for the account.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if close_account_on_delete is not None:
            pulumi.set(__self__, "close_account_on_delete", close_account_on_delete)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if organizational_unit_id_on_delete is not None:
            pulumi.set(__self__, "organizational_unit_id_on_delete", organizational_unit_id_on_delete)
        if path_id is not None:
            pulumi.set(__self__, "path_id", path_id)
        if provisioned_product_name is not None:
            pulumi.set(__self__, "provisioned_product_name", provisioned_product_name)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the AWS account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="closeAccountOnDelete")
    def close_account_on_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
        account will just be unenrolled from Control Tower.
        """
        return pulumi.get(self, "close_account_on_delete")

    @close_account_on_delete.setter
    def close_account_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_account_on_delete", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Root email of the account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Organizational Unit under which the account resides.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter(name="organizationalUnitIdOnDelete")
    def organizational_unit_id_on_delete(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
        provided, the account will not be moved.
        """
        return pulumi.get(self, "organizational_unit_id_on_delete")

    @organizational_unit_id_on_delete.setter
    def organizational_unit_id_on_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_id_on_delete", value)

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the path identifier of the product. This value is optional if the product has a default path, and required if
        the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        """
        return pulumi.get(self, "path_id")

    @path_id.setter
    def path_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_id", value)

    @property
    @pulumi.getter(name="provisionedProductName")
    def provisioned_product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        """
        return pulumi.get(self, "provisioned_product_name")

    @provisioned_product_name.setter
    def provisioned_product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_product_name", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['ControlTowerAwsAccountSsoArgs']]:
        """
        Assigned SSO user settings.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['ControlTowerAwsAccountSsoArgs']]):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags for the account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class ControlTowerAwsAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_account_on_delete: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 organizational_unit_id_on_delete: Optional[pulumi.Input[str]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[str]] = None,
                 sso: Optional[pulumi.Input[pulumi.InputType['ControlTowerAwsAccountSsoArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a ControlTowerAwsAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] close_account_on_delete: If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
               account will just be unenrolled from Control Tower.
        :param pulumi.Input[str] email: Root email of the account.
        :param pulumi.Input[str] name: Name of the account.
        :param pulumi.Input[str] organizational_unit: Name of the Organizational Unit under which the account resides.
        :param pulumi.Input[str] organizational_unit_id_on_delete: ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
               provided, the account will not be moved.
        :param pulumi.Input[str] path_id: Name of the path identifier of the product. This value is optional if the product has a default path, and required if
               the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        :param pulumi.Input[str] provisioned_product_name: Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        :param pulumi.Input[pulumi.InputType['ControlTowerAwsAccountSsoArgs']] sso: Assigned SSO user settings.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags for the account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ControlTowerAwsAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ControlTowerAwsAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ControlTowerAwsAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlTowerAwsAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_account_on_delete: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 organizational_unit_id_on_delete: Optional[pulumi.Input[str]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[str]] = None,
                 sso: Optional[pulumi.Input[pulumi.InputType['ControlTowerAwsAccountSsoArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlTowerAwsAccountArgs.__new__(ControlTowerAwsAccountArgs)

            __props__.__dict__["close_account_on_delete"] = close_account_on_delete
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["name"] = name
            if organizational_unit is None and not opts.urn:
                raise TypeError("Missing required property 'organizational_unit'")
            __props__.__dict__["organizational_unit"] = organizational_unit
            __props__.__dict__["organizational_unit_id_on_delete"] = organizational_unit_id_on_delete
            __props__.__dict__["path_id"] = path_id
            __props__.__dict__["provisioned_product_name"] = provisioned_product_name
            if sso is None and not opts.urn:
                raise TypeError("Missing required property 'sso'")
            __props__.__dict__["sso"] = sso
            __props__.__dict__["tags"] = tags
            __props__.__dict__["account_id"] = None
        super(ControlTowerAwsAccount, __self__).__init__(
            'awscontroltower:index/controlTowerAwsAccount:controlTowerAwsAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            close_account_on_delete: Optional[pulumi.Input[bool]] = None,
            email: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organizational_unit: Optional[pulumi.Input[str]] = None,
            organizational_unit_id_on_delete: Optional[pulumi.Input[str]] = None,
            path_id: Optional[pulumi.Input[str]] = None,
            provisioned_product_name: Optional[pulumi.Input[str]] = None,
            sso: Optional[pulumi.Input[pulumi.InputType['ControlTowerAwsAccountSsoArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'ControlTowerAwsAccount':
        """
        Get an existing ControlTowerAwsAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: ID of the AWS account.
        :param pulumi.Input[bool] close_account_on_delete: If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
               account will just be unenrolled from Control Tower.
        :param pulumi.Input[str] email: Root email of the account.
        :param pulumi.Input[str] name: Name of the account.
        :param pulumi.Input[str] organizational_unit: Name of the Organizational Unit under which the account resides.
        :param pulumi.Input[str] organizational_unit_id_on_delete: ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
               provided, the account will not be moved.
        :param pulumi.Input[str] path_id: Name of the path identifier of the product. This value is optional if the product has a default path, and required if
               the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        :param pulumi.Input[str] provisioned_product_name: Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        :param pulumi.Input[pulumi.InputType['ControlTowerAwsAccountSsoArgs']] sso: Assigned SSO user settings.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags for the account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlTowerAwsAccountState.__new__(_ControlTowerAwsAccountState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["close_account_on_delete"] = close_account_on_delete
        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["organizational_unit"] = organizational_unit
        __props__.__dict__["organizational_unit_id_on_delete"] = organizational_unit_id_on_delete
        __props__.__dict__["path_id"] = path_id
        __props__.__dict__["provisioned_product_name"] = provisioned_product_name
        __props__.__dict__["sso"] = sso
        __props__.__dict__["tags"] = tags
        return ControlTowerAwsAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        ID of the AWS account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="closeAccountOnDelete")
    def close_account_on_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        If enabled, this will close the AWS account on resource deletion, beginning the 90-day suspension period. Otherwise, the
        account will just be unenrolled from Control Tower.
        """
        return pulumi.get(self, "close_account_on_delete")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Root email of the account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> pulumi.Output[str]:
        """
        Name of the Organizational Unit under which the account resides.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="organizationalUnitIdOnDelete")
    def organizational_unit_id_on_delete(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the Organizational Unit to which the account should be moved when the resource is deleted. If no value is
        provided, the account will not be moved.
        """
        return pulumi.get(self, "organizational_unit_id_on_delete")

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> pulumi.Output[str]:
        """
        Name of the path identifier of the product. This value is optional if the product has a default path, and required if
        the product has more than one path. To list the paths for a product, use ListLaunchPaths.
        """
        return pulumi.get(self, "path_id")

    @property
    @pulumi.getter(name="provisionedProductName")
    def provisioned_product_name(self) -> pulumi.Output[str]:
        """
        Name of the service catalog product that is provisioned. Defaults to a slugified version of the account name.
        """
        return pulumi.get(self, "provisioned_product_name")

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Output['outputs.ControlTowerAwsAccountSso']:
        """
        Assigned SSO user settings.
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags for the account.
        """
        return pulumi.get(self, "tags")

