# AWS Control Tower Resource Provider

The AWS Control Tower resource provider for Pulumi let's you create [AWS Control Tower](https://aws.amazon.com/controltower) managed accounts.

It is bridged from the Terraform provider [built by Idealo](https://github.com/idealo/terraform-provider-controltower)

To use this package, please [install the Pulumi CLI first](https://pulumi.com/).

## Installing

This package is available in many languages in the standard packaging formats.

### Node.js (Java/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```
$ npm install @jaxxstorm/pulumi-awscontroltower
```

or `yarn`:

```
$ yarn add @jaxxstorm/pulumi-awscontroltower
```

### Python

To use from Python, install using `pip`:

```
$ pip install pulumi-awscontroltower
```

### Go

To use from Go, use `go get` to grab the latest version of the library

```
$ go get github.com/jaxxstorm/pulumi-awscontroltower/sdk/go/...
```

### .NET

To use from Dotnet, use `dotnet add package` to install into your project. You must specify the version if it is a pre-release version.


```
$ dotnet add package Pulumi.AwsControlTower
```

## Reference

See the Pulumi registry for API docs:

https://www.pulumi.com/registry/packages/awscontroltowe/api-docs/
