"use strict";
// Integration test to deploy some resources, create an alarm on it and create a dashboard.
//
// Because literally every other library is going to depend on @aws-cdk/aws-cloudwatch, we drop down
// to the very lowest level to create CloudFormation resources by hand, without even generated
// library support.
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cloudwatch = require("../lib");
const lib_1 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, `aws-cdk-cloudwatch`);
const queue = new cdk.CfnResource(stack, 'queue', { type: 'AWS::SQS::Queue' });
const metric = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') }
});
const alarm = metric.createAlarm(stack, 'Alarm', {
    threshold: 100,
    evaluationPeriods: 3,
    datapointsToAlarm: 2,
});
const dashboard = new cloudwatch.Dashboard(stack, 'Dash', {
    dashboardName: 'MyCustomDashboardName',
    start: '-9H',
    end: '2018-12-17T06:00:00.000Z',
    periodOverride: lib_1.PeriodOverride.Inherit
});
dashboard.addWidgets(new cloudwatch.TextWidget({ markdown: '# This is my dashboard' }), new cloudwatch.TextWidget({ markdown: 'you like?' }));
dashboard.addWidgets(new cloudwatch.AlarmWidget({
    title: 'Messages in queue',
    alarm,
}));
dashboard.addWidgets(new cloudwatch.GraphWidget({
    title: 'More messages in queue with alarm annotation',
    left: [metric],
    leftAnnotations: [alarm.toAnnotation()]
}));
dashboard.addWidgets(new cloudwatch.SingleValueWidget({
    title: 'Current messages in queue',
    metrics: [metric]
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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