/**
 * Interface for metrics
 */
export interface IMetric {
    /**
     * Turn this metric object into an alarm configuration
     */
    toAlarmConfig(): MetricAlarmConfig;
    /**
     * Turn this metric object into a graph configuration
     */
    toGraphConfig(): MetricGraphConfig;
}
/**
 * Metric dimension
 */
export interface Dimension {
    /**
     * Name of the dimension
     */
    readonly name: string;
    /**
     * Value of the dimension
     */
    readonly value: any;
}
/**
 * Statistic to use over the aggregation period
 */
export declare enum Statistic {
    SampleCount = "SampleCount",
    Average = "Average",
    Sum = "Sum",
    Minimum = "Minimum",
    Maximum = "Maximum"
}
/**
 * Unit for metric
 */
export declare enum Unit {
    Seconds = "Seconds",
    Microseconds = "Microseconds",
    Milliseconds = "Milliseconds",
    Bytes_ = "Bytes",
    Kilobytes = "Kilobytes",
    Megabytes = "Megabytes",
    Gigabytes = "Gigabytes",
    Terabytes = "Terabytes",
    Bits = "Bits",
    Kilobits = "Kilobits",
    Megabits = "Megabits",
    Gigabits = "Gigabits",
    Terabits = "Terabits",
    Percent = "Percent",
    Count = "Count",
    BytesPerSecond = "Bytes/Second",
    KilobytesPerSecond = "Kilobytes/Second",
    MegabytesPerSecond = "Megabytes/Second",
    GigabytesPerSecond = "Gigabytes/Second",
    TerabytesPerSecond = "Terabytes/Second",
    BitsPerSecond = "Bits/Second",
    KilobitsPerSecond = "Kilobits/Second",
    MegabitsPerSecond = "Megabits/Second",
    GigabitsPerSecond = "Gigabits/Second",
    TerabitsPerSecond = "Terabits/Second",
    CountPerSecond = "Count/Second",
    None = "None"
}
/**
 * Properties used to construct the Metric identifying part of an Alarm
 */
export interface MetricAlarmConfig {
    /**
     * The dimensions to apply to the alarm
     */
    readonly dimensions?: Dimension[];
    /**
     * Namespace of the metric
     */
    readonly namespace: string;
    /**
     * Name of the metric
     */
    readonly metricName: string;
    /**
     * How many seconds to aggregate over
     */
    readonly period: number;
    /**
     * Simple aggregation function to use
     */
    readonly statistic?: Statistic;
    /**
     * Percentile aggregation function to use
     */
    readonly extendedStatistic?: string;
    /**
     * The unit of the alarm
     */
    readonly unit?: Unit;
}
/**
 * Properties used to construct the Metric identifying part of a Graph
 */
export interface MetricGraphConfig {
    /**
     * The dimensions to apply to the alarm
     */
    readonly dimensions?: Dimension[];
    /**
     * Namespace of the metric
     */
    readonly namespace: string;
    /**
     * Name of the metric
     */
    readonly metricName: string;
    /**
     * How many seconds to aggregate over
     */
    readonly period: number;
    /**
     * Label for the metric
     */
    readonly label?: string;
    /**
     * Color for the graph line
     */
    readonly color?: string;
    /**
     * Aggregation function to use (can be either simple or a percentile)
     */
    readonly statistic?: string;
    /**
     * The unit of the alarm
     */
    readonly unit?: Unit;
}
