"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const widget_1 = require("./widget");
/**
 * Display the metric associated with an alarm, including the alarm line
 */
class AlarmWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
    }
    toJson() {
        return [{
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'timeSeries',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.region,
                    annotations: {
                        alarms: [this.props.alarm.alarmArn]
                    },
                    yAxis: {
                        left: this.props.leftYAxis !== undefined ? this.props.leftYAxis : undefined
                    }
                }
            }];
    }
}
exports.AlarmWidget = AlarmWidget;
/**
 * A dashboard widget that displays metrics
 */
class GraphWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
    }
    toJson() {
        return [{
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'timeSeries',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.region,
                    metrics: (this.props.left || []).map(m => metricJson(m, 'left')).concat((this.props.right || []).map(m => metricJson(m, 'right'))),
                    annotations: {
                        horizontal: (this.props.leftAnnotations || []).map(mapAnnotation('left')).concat((this.props.rightAnnotations || []).map(mapAnnotation('right')))
                    },
                    yAxis: {
                        left: this.props.leftYAxis !== undefined ? this.props.leftYAxis : undefined,
                        right: this.props.rightYAxis !== undefined ? this.props.rightYAxis : undefined,
                    }
                }
            }];
    }
}
exports.GraphWidget = GraphWidget;
/**
 * A dashboard widget that displays the most recent value for every metric
 */
class SingleValueWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 3);
        this.props = props;
    }
    toJson() {
        return [{
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'singleValue',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.region,
                    metrics: this.props.metrics.map(m => metricJson(m, 'left'))
                }
            }];
    }
}
exports.SingleValueWidget = SingleValueWidget;
var Shading;
(function (Shading) {
    /**
     * Don't add shading
     */
    Shading["None"] = "none";
    /**
     * Add shading above the annotation
     */
    Shading["Above"] = "above";
    /**
     * Add shading below the annotation
     */
    Shading["Below"] = "below";
})(Shading = exports.Shading || (exports.Shading = {}));
function mapAnnotation(yAxis) {
    return (a) => {
        return { ...a, yAxis };
    };
}
/**
 * Return the JSON structure which represents this metric in a graph
 *
 * This will be called by GraphWidget, no need for clients to call this.
 */
function metricJson(metric, yAxis) {
    const config = metric.toGraphConfig();
    // Namespace and metric Name
    const ret = [
        config.namespace,
        config.metricName,
    ];
    // Dimensions
    for (const dim of (config.dimensions || [])) {
        ret.push(dim.name, dim.value);
    }
    // Options
    ret.push({
        yAxis,
        label: config.label,
        color: config.color,
        period: config.period,
        stat: config.statistic,
    });
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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