"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
var PeriodOverride;
(function (PeriodOverride) {
    PeriodOverride["Auto"] = "auto";
    PeriodOverride["Inherit"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends cdk_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.rows = [];
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: props.dashboardName,
            dashboardBody: cdk_1.Lazy.stringValue({ produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return cdk_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                } })
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
//# sourceMappingURL=data:application/json;base64,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