/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPreferenceManager
extends PreferenceManager {
    protected String xmlParserClassName;
    public static final String PREFERENCE_ENCODING = "8859_1";

    public XMLPreferenceManager(String prefFileName) {
        this(prefFileName, null, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String prefFileName, Map defaults) {
        this(prefFileName, defaults, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String prefFileName, String parser) {
        this(prefFileName, null, parser);
    }

    public XMLPreferenceManager(String prefFileName, Map defaults, String parser) {
        super(prefFileName, defaults);
        this.internal = new XMLProperties();
        this.xmlParserClassName = parser;
    }

    protected class XMLProperties
    extends Properties {
        protected XMLProperties() {
        }

        @Override
        public synchronized void load(InputStream is) throws IOException {
            BufferedReader r = new BufferedReader(new InputStreamReader(is, XMLPreferenceManager.PREFERENCE_ENCODING));
            SAXDocumentFactory df = new SAXDocumentFactory(GenericDOMImplementation.getDOMImplementation(), XMLPreferenceManager.this.xmlParserClassName);
            Document doc = df.createDocument("http://xml.apache.org/batik/preferences", "preferences", null, r);
            Element elt = doc.getDocumentElement();
            for (Node n = elt.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals("property")) continue;
                String name = ((Element)n).getAttributeNS(null, "name");
                StringBuffer cont = new StringBuffer();
                for (Node c = n.getFirstChild(); c != null && c.getNodeType() == 3; c = c.getNextSibling()) {
                    cont.append(c.getNodeValue());
                }
                String val = cont.toString();
                this.put(name, val);
            }
        }

        @Override
        public synchronized void store(OutputStream os, String header) throws IOException {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, XMLPreferenceManager.PREFERENCE_ENCODING));
            HashMap m = new HashMap();
            this.enumerate(m);
            w.write("<preferences xmlns=\"http://xml.apache.org/batik/preferences\">\n");
            for (Object o : m.keySet()) {
                String n = (String)o;
                String v = (String)m.get(n);
                w.write("<property name=\"" + n + "\">");
                try {
                    w.write(DOMUtilities.contentToString(v, false));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                w.write("</property>\n");
            }
            w.write("</preferences>\n");
            w.flush();
        }

        private synchronized void enumerate(Map m) {
            if (this.defaults != null) {
                for (Object k : m.keySet()) {
                    m.put(k, this.defaults.get(k));
                }
            }
            for (Object k : this.keySet()) {
                m.put(k, this.get(k));
            }
        }
    }
}

