# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1alpha1OrthologSet(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'genes': 'V1alpha1GeneMetadata',
        'method': 'str',
        'ortholog_set_id': 'int'
    }

    attribute_map = {
        'genes': 'genes',
        'method': 'method',
        'ortholog_set_id': 'ortholog_set_id'
    }

    def __init__(self, genes=None, method=None, ortholog_set_id=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1OrthologSet - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._genes = None
        self._method = None
        self._ortholog_set_id = None
        self.discriminator = None

        if genes is not None:
            self.genes = genes
        if method is not None:
            self.method = method
        if ortholog_set_id is not None:
            self.ortholog_set_id = ortholog_set_id

    @property
    def genes(self):
        """Gets the genes of this V1alpha1OrthologSet.  # noqa: E501


        :return: The genes of this V1alpha1OrthologSet.  # noqa: E501
        :rtype: V1alpha1GeneMetadata
        """
        return self._genes

    @genes.setter
    def genes(self, genes):
        """Sets the genes of this V1alpha1OrthologSet.


        :param genes: The genes of this V1alpha1OrthologSet.  # noqa: E501
        :type: V1alpha1GeneMetadata
        """

        self._genes = genes

    @property
    def method(self):
        """Gets the method of this V1alpha1OrthologSet.  # noqa: E501


        :return: The method of this V1alpha1OrthologSet.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this V1alpha1OrthologSet.


        :param method: The method of this V1alpha1OrthologSet.  # noqa: E501
        :type: str
        """

        self._method = method

    @property
    def ortholog_set_id(self):
        """Gets the ortholog_set_id of this V1alpha1OrthologSet.  # noqa: E501


        :return: The ortholog_set_id of this V1alpha1OrthologSet.  # noqa: E501
        :rtype: int
        """
        return self._ortholog_set_id

    @ortholog_set_id.setter
    def ortholog_set_id(self, ortholog_set_id):
        """Sets the ortholog_set_id of this V1alpha1OrthologSet.


        :param ortholog_set_id: The ortholog_set_id of this V1alpha1OrthologSet.  # noqa: E501
        :type: int
        """

        self._ortholog_set_id = ortholog_set_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1OrthologSet):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1OrthologSet):
            return True

        return self.to_dict() != other.to_dict()
