# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 7
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_0.api_client import ApiClient


class JobApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_job_job(self, job_job, **kwargs):  # noqa: E501
        """create_job_job  # noqa: E501

        Queue a new instance of a job type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_job_job(job_job, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobJobCreateParams job_job: (required)
        :return: CreateJobJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_job_job_with_http_info(job_job, **kwargs)  # noqa: E501
        else:
            (data) = self.create_job_job_with_http_info(job_job, **kwargs)  # noqa: E501
            return data

    def create_job_job_with_http_info(self, job_job, **kwargs):  # noqa: E501
        """create_job_job  # noqa: E501

        Queue a new instance of a job type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_job_job_with_http_info(job_job, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobJobCreateParams job_job: (required)
        :return: CreateJobJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_job']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_job_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_job' is set
        if ('job_job' not in params or
                params['job_job'] is None):
            raise ValueError("Missing the required parameter `job_job` when calling `create_job_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_job' in params:
            body_params = params['job_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/job/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateJobJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_job_policy(self, job_policy, **kwargs):  # noqa: E501
        """create_job_policy  # noqa: E501

        Create a new job impact policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_job_policy(job_policy, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobPolicyCreateParams job_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_job_policy_with_http_info(job_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_job_policy_with_http_info(job_policy, **kwargs)  # noqa: E501
            return data

    def create_job_policy_with_http_info(self, job_policy, **kwargs):  # noqa: E501
        """create_job_policy  # noqa: E501

        Create a new job impact policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_job_policy_with_http_info(job_policy, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobPolicyCreateParams job_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_policy']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_job_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_policy' is set
        if ('job_policy' not in params or
                params['job_policy'] is None):
            raise ValueError("Missing the required parameter `job_policy` when calling `create_job_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_policy' in params:
            body_params = params['job_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job_policy(self, job_policy_id, **kwargs):  # noqa: E501
        """delete_job_policy  # noqa: E501

        Delete a job impact policy.  System policies may not be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_job_policy(job_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_policy_id: Delete a job impact policy.  System policies may not be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_job_policy_with_http_info(job_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_job_policy_with_http_info(job_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_job_policy_with_http_info(self, job_policy_id, **kwargs):  # noqa: E501
        """delete_job_policy  # noqa: E501

        Delete a job impact policy.  System policies may not be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_job_policy_with_http_info(job_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_policy_id: Delete a job impact policy.  System policies may not be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_policy_id' is set
        if ('job_policy_id' not in params or
                params['job_policy_id'] is None):
            raise ValueError("Missing the required parameter `job_policy_id` when calling `delete_job_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_policy_id' in params:
            path_params['JobPolicyId'] = params['job_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/policies/{JobPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_events(self, **kwargs):  # noqa: E501
        """get_job_events  # noqa: E501

        List job events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_events(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Restrict the query to events at or after the given time, in seconds since the Epoch.
        :param int end: Restrict the query to events before the given time, in seconds since the Epoch.
        :param int job_id: Restrict the query to the given job ID.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str job_type: Restrict the query to the given job type.
        :param int timeout_ms: Query timeout in milliseconds. The default is 10000 ms.
        :param str state: Restrict the query to events containing the given state. This parameter cannot be used with ended_jobs_only
        :param bool ended_jobs_only: Request all jobs that ended. This parameter cannot be used with the 'state' parameter. Ended states are 'cancelled_user', 'cancelled_system', 'failed' or 'succeeded'
        :param int limit: Return no more than this many results at once (see resume).
        :param str key: Restrict the query to the given key name.
        :return: JobEvents
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_job_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_job_events_with_http_info(self, **kwargs):  # noqa: E501
        """get_job_events  # noqa: E501

        List job events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_events_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Restrict the query to events at or after the given time, in seconds since the Epoch.
        :param int end: Restrict the query to events before the given time, in seconds since the Epoch.
        :param int job_id: Restrict the query to the given job ID.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str job_type: Restrict the query to the given job type.
        :param int timeout_ms: Query timeout in milliseconds. The default is 10000 ms.
        :param str state: Restrict the query to events containing the given state. This parameter cannot be used with ended_jobs_only
        :param bool ended_jobs_only: Request all jobs that ended. This parameter cannot be used with the 'state' parameter. Ended states are 'cancelled_user', 'cancelled_system', 'failed' or 'succeeded'
        :param int limit: Return no more than this many results at once (see resume).
        :param str key: Restrict the query to the given key name.
        :return: JobEvents
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end', 'job_id', 'resume', 'job_type', 'timeout_ms', 'state', 'ended_jobs_only', 'limit', 'key']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_events" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_job_events`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_job_events`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_job_events`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_job_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'job_id' in params:
            query_params.append(('job_id', params['job_id']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'job_type' in params:
            query_params.append(('job_type', params['job_type']))  # noqa: E501
        if 'timeout_ms' in params:
            query_params.append(('timeout_ms', params['timeout_ms']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'ended_jobs_only' in params:
            query_params.append(('ended_jobs_only', params['ended_jobs_only']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/job/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobEvents',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_job(self, job_job_id, **kwargs):  # noqa: E501
        """get_job_job  # noqa: E501

        View a single job instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_job(job_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_job_id: View a single job instance. (required)
        :return: JobJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_job_with_http_info(job_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_job_with_http_info(job_job_id, **kwargs)  # noqa: E501
            return data

    def get_job_job_with_http_info(self, job_job_id, **kwargs):  # noqa: E501
        """get_job_job  # noqa: E501

        View a single job instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_job_with_http_info(job_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_job_id: View a single job instance. (required)
        :return: JobJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_job_id' is set
        if ('job_job_id' not in params or
                params['job_job_id'] is None):
            raise ValueError("Missing the required parameter `job_job_id` when calling `get_job_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_job_id' in params:
            path_params['JobJobId'] = params['job_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/job/jobs/{JobJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobJobs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_job_summary(self, **kwargs):  # noqa: E501
        """get_job_job_summary  # noqa: E501

        View job engine status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_job_summary(async=True)
        >>> result = thread.get()

        :param async bool
        :return: JobJobSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_job_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_job_job_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_job_job_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_job_job_summary  # noqa: E501

        View job engine status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_job_summary_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: JobJobSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_job_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/job/job-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobJobSummary',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_policy(self, job_policy_id, **kwargs):  # noqa: E501
        """get_job_policy  # noqa: E501

        View a single job impact policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_policy(job_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_policy_id: View a single job impact policy. (required)
        :return: JobPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_policy_with_http_info(job_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_policy_with_http_info(job_policy_id, **kwargs)  # noqa: E501
            return data

    def get_job_policy_with_http_info(self, job_policy_id, **kwargs):  # noqa: E501
        """get_job_policy  # noqa: E501

        View a single job impact policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_policy_with_http_info(job_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_policy_id: View a single job impact policy. (required)
        :return: JobPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_policy_id' is set
        if ('job_policy_id' not in params or
                params['job_policy_id'] is None):
            raise ValueError("Missing the required parameter `job_policy_id` when calling `get_job_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_policy_id' in params:
            path_params['JobPolicyId'] = params['job_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/policies/{JobPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_recent(self, **kwargs):  # noqa: E501
        """get_job_recent  # noqa: E501

        List recently completed jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_recent(async=True)
        >>> result = thread.get()

        :param async bool
        :param int timeout_ms: Query timeout in milliseconds. The default is 10000 ms.
        :param int limit: Max number of recent jobs to return. The default is 8, the max is 100.
        :return: JobRecent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_recent_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_job_recent_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_job_recent_with_http_info(self, **kwargs):  # noqa: E501
        """get_job_recent  # noqa: E501

        List recently completed jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_recent_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int timeout_ms: Query timeout in milliseconds. The default is 10000 ms.
        :param int limit: Max number of recent jobs to return. The default is 8, the max is 100.
        :return: JobRecent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timeout_ms', 'limit']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_recent" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout_ms' in params:
            query_params.append(('timeout_ms', params['timeout_ms']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/job/recent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobRecent',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_reports(self, **kwargs):  # noqa: E501
        """get_job_reports  # noqa: E501

        List job reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_reports(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Restrict the query to reports at or after the given time, in seconds since the Epoch.
        :param int end: Restrict the query to reports before the given time, in seconds since the Epoch.
        :param int job_id: Restrict the query to the given job ID.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str job_type: Restrict the query to the given job type.
        :param int timeout_ms: Query timeout in milliseconds. The default is 10000 ms.
        :param int limit: Return no more than this many results at once (see resume).
        :param str key: Restrict the query to the given report key.
        :param bool last_phase_only: if set, the query will return the last reported phase only.
        :param bool verbose: Display more detailed information, including job engine framework statistics.
        :return: JobReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_job_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_job_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_job_reports  # noqa: E501

        List job reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_reports_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Restrict the query to reports at or after the given time, in seconds since the Epoch.
        :param int end: Restrict the query to reports before the given time, in seconds since the Epoch.
        :param int job_id: Restrict the query to the given job ID.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str job_type: Restrict the query to the given job type.
        :param int timeout_ms: Query timeout in milliseconds. The default is 10000 ms.
        :param int limit: Return no more than this many results at once (see resume).
        :param str key: Restrict the query to the given report key.
        :param bool last_phase_only: if set, the query will return the last reported phase only.
        :param bool verbose: Display more detailed information, including job engine framework statistics.
        :return: JobReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end', 'job_id', 'resume', 'job_type', 'timeout_ms', 'limit', 'key', 'last_phase_only', 'verbose']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_job_reports`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_job_reports`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_job_reports`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_job_reports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'job_id' in params:
            query_params.append(('job_id', params['job_id']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'job_type' in params:
            query_params.append(('job_type', params['job_type']))  # noqa: E501
        if 'timeout_ms' in params:
            query_params.append(('timeout_ms', params['timeout_ms']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'last_phase_only' in params:
            query_params.append(('last_phase_only', params['last_phase_only']))  # noqa: E501
        if 'verbose' in params:
            query_params.append(('verbose', params['verbose']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/job/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobReports',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_statistics(self, **kwargs):  # noqa: E501
        """get_job_statistics  # noqa: E501

        View job engine statistics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_statistics(async=True)
        >>> result = thread.get()

        :param async bool
        :param int devid: Restrict the query to the given node.
        :param int job_id: Restrict the query to the given job ID.
        :return: JobStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_statistics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_job_statistics_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_job_statistics_with_http_info(self, **kwargs):  # noqa: E501
        """get_job_statistics  # noqa: E501

        View job engine statistics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_statistics_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int devid: Restrict the query to the given node.
        :param int job_id: Restrict the query to the given job ID.
        :return: JobStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['devid', 'job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_statistics" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
        if 'job_id' in params:
            query_params.append(('job_id', params['job_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobStatistics',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_type(self, job_type_id, **kwargs):  # noqa: E501
        """get_job_type  # noqa: E501

        Retrieve job type information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_type(job_type_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_type_id: Retrieve job type information. (required)
        :return: JobTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_type_with_http_info(job_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_type_with_http_info(job_type_id, **kwargs)  # noqa: E501
            return data

    def get_job_type_with_http_info(self, job_type_id, **kwargs):  # noqa: E501
        """get_job_type  # noqa: E501

        Retrieve job type information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_type_with_http_info(job_type_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str job_type_id: Retrieve job type information. (required)
        :return: JobTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_type_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_type_id' is set
        if ('job_type_id' not in params or
                params['job_type_id'] is None):
            raise ValueError("Missing the required parameter `job_type_id` when calling `get_job_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_type_id' in params:
            path_params['JobTypeId'] = params['job_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/types/{JobTypeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobTypes',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_types(self, **kwargs):  # noqa: E501
        """get_job_types  # noqa: E501

        List job types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_types(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param bool show_all: Whether to show all job types, including hidden ones.  Defaults to false.
        :param str dir: The direction of the sort.
        :return: JobTypesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_job_types_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_job_types_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_job_types_with_http_info(self, **kwargs):  # noqa: E501
        """get_job_types  # noqa: E501

        List job types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_job_types_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param bool show_all: Whether to show all job types, including hidden ones.  Defaults to false.
        :param str dir: The direction of the sort.
        :return: JobTypesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'show_all', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_types" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_job_types`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_job_types`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_job_types`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'show_all' in params:
            query_params.append(('show_all', params['show_all']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobTypesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_job_jobs(self, **kwargs):  # noqa: E501
        """list_job_jobs  # noqa: E501

        List running and paused jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_job_jobs(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool batch: If true, other arguments are ignored, and the query will return all results, unsorted, as quickly as possible.
        :param str state: Limit the results to jobs in the specified state.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: JobJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_job_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_job_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_job_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_job_jobs  # noqa: E501

        List running and paused jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_job_jobs_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool batch: If true, other arguments are ignored, and the query will return all results, unsorted, as quickly as possible.
        :param str state: Limit the results to jobs in the specified state.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: JobJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'batch', 'state', 'limit', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_job_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_job_jobs`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_job_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_job_jobs`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_job_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_job_jobs`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_job_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_job_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'batch' in params:
            query_params.append(('batch', params['batch']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/job/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobJobsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_job_policies(self, **kwargs):  # noqa: E501
        """list_job_policies  # noqa: E501

        List job impact policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_job_policies(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: JobPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_job_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_job_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_job_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_job_policies  # noqa: E501

        List job impact policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_job_policies_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: JobPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_job_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_job_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_job_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_job_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_job_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_job_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_job_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_job_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_job(self, job_job, job_job_id, **kwargs):  # noqa: E501
        """update_job_job  # noqa: E501

        Modify a running or paused job instance.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_job_job(job_job, job_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobJob job_job: (required)
        :param str job_job_id: Modify a running or paused job instance.  All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_job_job_with_http_info(job_job, job_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_job_job_with_http_info(job_job, job_job_id, **kwargs)  # noqa: E501
            return data

    def update_job_job_with_http_info(self, job_job, job_job_id, **kwargs):  # noqa: E501
        """update_job_job  # noqa: E501

        Modify a running or paused job instance.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_job_job_with_http_info(job_job, job_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobJob job_job: (required)
        :param str job_job_id: Modify a running or paused job instance.  All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_job', 'job_job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_job' is set
        if ('job_job' not in params or
                params['job_job'] is None):
            raise ValueError("Missing the required parameter `job_job` when calling `update_job_job`")  # noqa: E501
        # verify the required parameter 'job_job_id' is set
        if ('job_job_id' not in params or
                params['job_job_id'] is None):
            raise ValueError("Missing the required parameter `job_job_id` when calling `update_job_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_job_id' in params:
            path_params['JobJobId'] = params['job_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_job' in params:
            body_params = params['job_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/job/jobs/{JobJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_policy(self, job_policy, job_policy_id, **kwargs):  # noqa: E501
        """update_job_policy  # noqa: E501

        Modify a job impact policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_job_policy(job_policy, job_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobPolicy job_policy: (required)
        :param str job_policy_id: Modify a job impact policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_job_policy_with_http_info(job_policy, job_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_job_policy_with_http_info(job_policy, job_policy_id, **kwargs)  # noqa: E501
            return data

    def update_job_policy_with_http_info(self, job_policy, job_policy_id, **kwargs):  # noqa: E501
        """update_job_policy  # noqa: E501

        Modify a job impact policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_job_policy_with_http_info(job_policy, job_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobPolicy job_policy: (required)
        :param str job_policy_id: Modify a job impact policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_policy', 'job_policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_policy' is set
        if ('job_policy' not in params or
                params['job_policy'] is None):
            raise ValueError("Missing the required parameter `job_policy` when calling `update_job_policy`")  # noqa: E501
        # verify the required parameter 'job_policy_id' is set
        if ('job_policy_id' not in params or
                params['job_policy_id'] is None):
            raise ValueError("Missing the required parameter `job_policy_id` when calling `update_job_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_policy_id' in params:
            path_params['JobPolicyId'] = params['job_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_policy' in params:
            body_params = params['job_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/policies/{JobPolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_type(self, job_type, job_type_id, **kwargs):  # noqa: E501
        """update_job_type  # noqa: E501

        Modify the job type.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_job_type(job_type, job_type_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobType job_type: (required)
        :param str job_type_id: Modify the job type.  All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_job_type_with_http_info(job_type, job_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_job_type_with_http_info(job_type, job_type_id, **kwargs)  # noqa: E501
            return data

    def update_job_type_with_http_info(self, job_type, job_type_id, **kwargs):  # noqa: E501
        """update_job_type  # noqa: E501

        Modify the job type.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_job_type_with_http_info(job_type, job_type_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param JobType job_type: (required)
        :param str job_type_id: Modify the job type.  All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_type', 'job_type_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_type' is set
        if ('job_type' not in params or
                params['job_type'] is None):
            raise ValueError("Missing the required parameter `job_type` when calling `update_job_type`")  # noqa: E501
        # verify the required parameter 'job_type_id' is set
        if ('job_type_id' not in params or
                params['job_type_id'] is None):
            raise ValueError("Missing the required parameter `job_type_id` when calling `update_job_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_type_id' in params:
            path_params['JobTypeId'] = params['job_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_type' in params:
            body_params = params['job_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/job/types/{JobTypeId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
