# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 7
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_0.api_client import ApiClient


class ClusterApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_cluster_add_node_item(self, cluster_add_node_item, **kwargs):  # noqa: E501
        """create_cluster_add_node_item  # noqa: E501

        Serial number and arguments of node to add.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cluster_add_node_item(cluster_add_node_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterAddNodeItem cluster_add_node_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_cluster_add_node_item_with_http_info(cluster_add_node_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cluster_add_node_item_with_http_info(cluster_add_node_item, **kwargs)  # noqa: E501
            return data

    def create_cluster_add_node_item_with_http_info(self, cluster_add_node_item, **kwargs):  # noqa: E501
        """create_cluster_add_node_item  # noqa: E501

        Serial number and arguments of node to add.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cluster_add_node_item_with_http_info(cluster_add_node_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterAddNodeItem cluster_add_node_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_add_node_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cluster_add_node_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_add_node_item' is set
        if ('cluster_add_node_item' not in params or
                params['cluster_add_node_item'] is None):
            raise ValueError("Missing the required parameter `cluster_add_node_item` when calling `create_cluster_add_node_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_add_node_item' in params:
            body_params = params['cluster_add_node_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/add-node', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_diagnostics_gather_start_item(self, diagnostics_gather_start_item, **kwargs):  # noqa: E501
        """create_diagnostics_gather_start_item  # noqa: E501

        Start a new gather  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_gather_start_item(diagnostics_gather_start_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsGatherSettingsExtended diagnostics_gather_start_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_diagnostics_gather_start_item_with_http_info(diagnostics_gather_start_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_diagnostics_gather_start_item_with_http_info(diagnostics_gather_start_item, **kwargs)  # noqa: E501
            return data

    def create_diagnostics_gather_start_item_with_http_info(self, diagnostics_gather_start_item, **kwargs):  # noqa: E501
        """create_diagnostics_gather_start_item  # noqa: E501

        Start a new gather  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_gather_start_item_with_http_info(diagnostics_gather_start_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsGatherSettingsExtended diagnostics_gather_start_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['diagnostics_gather_start_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_diagnostics_gather_start_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'diagnostics_gather_start_item' is set
        if ('diagnostics_gather_start_item' not in params or
                params['diagnostics_gather_start_item'] is None):
            raise ValueError("Missing the required parameter `diagnostics_gather_start_item` when calling `create_diagnostics_gather_start_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'diagnostics_gather_start_item' in params:
            body_params = params['diagnostics_gather_start_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/gather/start', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_diagnostics_gather_stop_item(self, diagnostics_gather_stop_item, **kwargs):  # noqa: E501
        """create_diagnostics_gather_stop_item  # noqa: E501

        Stop a running gather  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_gather_stop_item(diagnostics_gather_stop_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty diagnostics_gather_stop_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_diagnostics_gather_stop_item_with_http_info(diagnostics_gather_stop_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_diagnostics_gather_stop_item_with_http_info(diagnostics_gather_stop_item, **kwargs)  # noqa: E501
            return data

    def create_diagnostics_gather_stop_item_with_http_info(self, diagnostics_gather_stop_item, **kwargs):  # noqa: E501
        """create_diagnostics_gather_stop_item  # noqa: E501

        Stop a running gather  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_gather_stop_item_with_http_info(diagnostics_gather_stop_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty diagnostics_gather_stop_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['diagnostics_gather_stop_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_diagnostics_gather_stop_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'diagnostics_gather_stop_item' is set
        if ('diagnostics_gather_stop_item' not in params or
                params['diagnostics_gather_stop_item'] is None):
            raise ValueError("Missing the required parameter `diagnostics_gather_stop_item` when calling `create_diagnostics_gather_stop_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'diagnostics_gather_stop_item' in params:
            body_params = params['diagnostics_gather_stop_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/gather/stop', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_diagnostics_netlogger_start_item(self, diagnostics_netlogger_start_item, **kwargs):  # noqa: E501
        """create_diagnostics_netlogger_start_item  # noqa: E501

        Start a new packet capture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_netlogger_start_item(diagnostics_netlogger_start_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsNetloggerSettingsSettings diagnostics_netlogger_start_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_diagnostics_netlogger_start_item_with_http_info(diagnostics_netlogger_start_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_diagnostics_netlogger_start_item_with_http_info(diagnostics_netlogger_start_item, **kwargs)  # noqa: E501
            return data

    def create_diagnostics_netlogger_start_item_with_http_info(self, diagnostics_netlogger_start_item, **kwargs):  # noqa: E501
        """create_diagnostics_netlogger_start_item  # noqa: E501

        Start a new packet capture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_netlogger_start_item_with_http_info(diagnostics_netlogger_start_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsNetloggerSettingsSettings diagnostics_netlogger_start_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['diagnostics_netlogger_start_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_diagnostics_netlogger_start_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'diagnostics_netlogger_start_item' is set
        if ('diagnostics_netlogger_start_item' not in params or
                params['diagnostics_netlogger_start_item'] is None):
            raise ValueError("Missing the required parameter `diagnostics_netlogger_start_item` when calling `create_diagnostics_netlogger_start_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'diagnostics_netlogger_start_item' in params:
            body_params = params['diagnostics_netlogger_start_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/netlogger/start', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_diagnostics_netlogger_stop_item(self, diagnostics_netlogger_stop_item, **kwargs):  # noqa: E501
        """create_diagnostics_netlogger_stop_item  # noqa: E501

        Stop a running packet capture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_netlogger_stop_item(diagnostics_netlogger_stop_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty diagnostics_netlogger_stop_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_diagnostics_netlogger_stop_item_with_http_info(diagnostics_netlogger_stop_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_diagnostics_netlogger_stop_item_with_http_info(diagnostics_netlogger_stop_item, **kwargs)  # noqa: E501
            return data

    def create_diagnostics_netlogger_stop_item_with_http_info(self, diagnostics_netlogger_stop_item, **kwargs):  # noqa: E501
        """create_diagnostics_netlogger_stop_item  # noqa: E501

        Stop a running packet capture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_diagnostics_netlogger_stop_item_with_http_info(diagnostics_netlogger_stop_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty diagnostics_netlogger_stop_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['diagnostics_netlogger_stop_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_diagnostics_netlogger_stop_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'diagnostics_netlogger_stop_item' is set
        if ('diagnostics_netlogger_stop_item' not in params or
                params['diagnostics_netlogger_stop_item'] is None):
            raise ValueError("Missing the required parameter `diagnostics_netlogger_stop_item` when calling `create_diagnostics_netlogger_stop_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'diagnostics_netlogger_stop_item' in params:
            body_params = params['diagnostics_netlogger_stop_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/netlogger/stop', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_config(self, **kwargs):  # noqa: E501
        """get_cluster_config  # noqa: E501

        Retrieve the cluster information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_config(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_config_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_config  # noqa: E501

        Retrieve the cluster information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_config_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterConfig',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_email(self, **kwargs):  # noqa: E501
        """get_cluster_email  # noqa: E501

        Get the cluster email notification settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_email(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterEmail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_email_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_email_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_email_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_email  # noqa: E501

        Get the cluster email notification settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_email_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterEmail
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_email" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/cluster/email', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterEmail',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_external_ips(self, **kwargs):  # noqa: E501
        """get_cluster_external_ips  # noqa: E501

        Retrieve the cluster IP addresses including IPV4 and IPV6.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_external_ips(async=True)
        >>> result = thread.get()

        :param async bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_external_ips_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_external_ips_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_external_ips_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_external_ips  # noqa: E501

        Retrieve the cluster IP addresses including IPV4 and IPV6.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_external_ips_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_external_ips" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/cluster/external-ips', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_identity(self, **kwargs):  # noqa: E501
        """get_cluster_identity  # noqa: E501

        Retrieve the login information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_identity(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterIdentity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_identity_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_identity_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_identity_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_identity  # noqa: E501

        Retrieve the login information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_identity_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterIdentity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_identity" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/cluster/identity', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterIdentity',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_internal_networks(self, **kwargs):  # noqa: E501
        """get_cluster_internal_networks  # noqa: E501

        View internal networks settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_internal_networks(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterInternalNetworks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_internal_networks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_internal_networks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_internal_networks_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_internal_networks  # noqa: E501

        View internal networks settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_internal_networks_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterInternalNetworks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_internal_networks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/internal-networks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterInternalNetworks',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_node(self, cluster_node_id, **kwargs):  # noqa: E501
        """get_cluster_node  # noqa: E501

        Retrieve node information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_node(cluster_node_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int cluster_node_id: Retrieve node information. (required)
        :param float timeout: Request timeout
        :return: ClusterNodesExtendedExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_node_with_http_info(cluster_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_node_with_http_info(cluster_node_id, **kwargs)  # noqa: E501
            return data

    def get_cluster_node_with_http_info(self, cluster_node_id, **kwargs):  # noqa: E501
        """get_cluster_node  # noqa: E501

        Retrieve node information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_node_with_http_info(cluster_node_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int cluster_node_id: Retrieve node information. (required)
        :param float timeout: Request timeout
        :return: ClusterNodesExtendedExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_node_id', 'timeout']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_node_id' is set
        if ('cluster_node_id' not in params or
                params['cluster_node_id'] is None):
            raise ValueError("Missing the required parameter `cluster_node_id` when calling `get_cluster_node`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_cluster_node`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_cluster_node`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cluster_node_id' in params:
            path_params['ClusterNodeId'] = params['cluster_node_id']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{ClusterNodeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterNodesExtendedExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_nodes(self, **kwargs):  # noqa: E501
        """get_cluster_nodes  # noqa: E501

        List the nodes on this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_nodes(async=True)
        >>> result = thread.get()

        :param async bool
        :param float timeout: Request timeout
        :return: ClusterNodesExtendedExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_nodes  # noqa: E501

        List the nodes on this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_nodes_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param float timeout: Request timeout
        :return: ClusterNodesExtendedExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timeout']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_cluster_nodes`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_cluster_nodes`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterNodesExtendedExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_nodes_available(self, **kwargs):  # noqa: E501
        """get_cluster_nodes_available  # noqa: E501

        List all nodes that are available to add to this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_nodes_available(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterNodesAvailable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_nodes_available_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_nodes_available_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_nodes_available_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_nodes_available  # noqa: E501

        List all nodes that are available to add to this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_nodes_available_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterNodesAvailable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_nodes_available" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes-available', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterNodesAvailable',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_owner(self, **kwargs):  # noqa: E501
        """get_cluster_owner  # noqa: E501

        Get the cluster contact info settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_owner(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_owner_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_owner_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_owner_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_owner  # noqa: E501

        Get the cluster contact info settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_owner_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_owner" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/cluster/owner', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterOwner',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_statfs(self, **kwargs):  # noqa: E501
        """get_cluster_statfs  # noqa: E501

        Retrieve the filesystem statistics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_statfs(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterStatfs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_statfs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_statfs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_statfs_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_statfs  # noqa: E501

        Retrieve the filesystem statistics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_statfs_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterStatfs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_statfs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/cluster/statfs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterStatfs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_time(self, **kwargs):  # noqa: E501
        """get_cluster_time  # noqa: E501

        Retrieve the current time as reported by each node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_time(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterTime
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_time_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_time  # noqa: E501

        Retrieve the current time as reported by each node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_time_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterTime
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterTime',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_timezone(self, **kwargs):  # noqa: E501
        """get_cluster_timezone  # noqa: E501

        Get the cluster timezone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_timezone(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterTimezone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_timezone_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_timezone_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_timezone_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_timezone  # noqa: E501

        Get the cluster timezone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_timezone_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterTimezone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_timezone" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/timezone', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterTimezone',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_version(self, **kwargs):  # noqa: E501
        """get_cluster_version  # noqa: E501

        Retrieve the OneFS version as reported by each node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_version(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_version_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_version_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_version_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_version  # noqa: E501

        Retrieve the OneFS version as reported by each node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_version_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ClusterVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_version" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/version', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterVersion',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_diagnostics_gather(self, **kwargs):  # noqa: E501
        """get_diagnostics_gather  # noqa: E501

        Get the status of isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_gather(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsGatherStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_diagnostics_gather_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_diagnostics_gather_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_diagnostics_gather_with_http_info(self, **kwargs):  # noqa: E501
        """get_diagnostics_gather  # noqa: E501

        Get the status of isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_gather_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsGatherStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diagnostics_gather" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/gather', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiagnosticsGatherStatus',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_diagnostics_gather_settings(self, **kwargs):  # noqa: E501
        """get_diagnostics_gather_settings  # noqa: E501

        Get the default options for isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_gather_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsGatherSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_diagnostics_gather_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_diagnostics_gather_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_diagnostics_gather_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_diagnostics_gather_settings  # noqa: E501

        Get the default options for isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_gather_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsGatherSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diagnostics_gather_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/gather/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiagnosticsGatherSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_diagnostics_gather_status(self, **kwargs):  # noqa: E501
        """get_diagnostics_gather_status  # noqa: E501

        Get the status of isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_gather_status(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsGatherStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_diagnostics_gather_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_diagnostics_gather_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_diagnostics_gather_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_diagnostics_gather_status  # noqa: E501

        Get the status of isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_gather_status_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsGatherStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diagnostics_gather_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/gather/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiagnosticsGatherStatus',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_diagnostics_netlogger(self, **kwargs):  # noqa: E501
        """get_diagnostics_netlogger  # noqa: E501

        Get the status of isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_netlogger(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsNetloggerStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_diagnostics_netlogger_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_diagnostics_netlogger_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_diagnostics_netlogger_with_http_info(self, **kwargs):  # noqa: E501
        """get_diagnostics_netlogger  # noqa: E501

        Get the status of isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_netlogger_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsNetloggerStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diagnostics_netlogger" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/netlogger', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiagnosticsNetloggerStatus',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_diagnostics_netlogger_settings(self, **kwargs):  # noqa: E501
        """get_diagnostics_netlogger_settings  # noqa: E501

        Get the default options for isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_netlogger_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsNetloggerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_diagnostics_netlogger_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_diagnostics_netlogger_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_diagnostics_netlogger_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_diagnostics_netlogger_settings  # noqa: E501

        Get the default options for isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_netlogger_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsNetloggerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diagnostics_netlogger_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/netlogger/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiagnosticsNetloggerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_diagnostics_netlogger_status(self, **kwargs):  # noqa: E501
        """get_diagnostics_netlogger_status  # noqa: E501

        Get the status of isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_netlogger_status(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsNetloggerStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_diagnostics_netlogger_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_diagnostics_netlogger_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_diagnostics_netlogger_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_diagnostics_netlogger_status  # noqa: E501

        Get the status of isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_diagnostics_netlogger_status_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: DiagnosticsNetloggerStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diagnostics_netlogger_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/netlogger/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiagnosticsNetloggerStatus',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_timezone_region(self, timezone_region_id, **kwargs):  # noqa: E501
        """get_timezone_region  # noqa: E501

        List timezone regions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_timezone_region(timezone_region_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str timezone_region_id: List timezone regions. (required)
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool show_all: Show all timezones within the region specified in the URI.
        :param bool dst_reset: This query arg is not needed in normal use cases.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: TimezoneRegions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_timezone_region_with_http_info(timezone_region_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_timezone_region_with_http_info(timezone_region_id, **kwargs)  # noqa: E501
            return data

    def get_timezone_region_with_http_info(self, timezone_region_id, **kwargs):  # noqa: E501
        """get_timezone_region  # noqa: E501

        List timezone regions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_timezone_region_with_http_info(timezone_region_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str timezone_region_id: List timezone regions. (required)
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool show_all: Show all timezones within the region specified in the URI.
        :param bool dst_reset: This query arg is not needed in normal use cases.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: TimezoneRegions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timezone_region_id', 'sort', 'resume', 'show_all', 'dst_reset', 'limit', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_timezone_region" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'timezone_region_id' is set
        if ('timezone_region_id' not in params or
                params['timezone_region_id'] is None):
            raise ValueError("Missing the required parameter `timezone_region_id` when calling `get_timezone_region`")  # noqa: E501

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_timezone_region`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_timezone_region`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_timezone_region`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_timezone_region`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_timezone_region`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_timezone_region`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_timezone_region`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'timezone_region_id' in params:
            path_params['TimezoneRegionId'] = params['timezone_region_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'show_all' in params:
            query_params.append(('show_all', params['show_all']))  # noqa: E501
        if 'dst_reset' in params:
            query_params.append(('dst_reset', params['dst_reset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/timezone/regions/{TimezoneRegionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimezoneRegions',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_timezone_settings(self, **kwargs):  # noqa: E501
        """get_timezone_settings  # noqa: E501

        Retrieve the cluster timezone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_timezone_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: TimezoneSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_timezone_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_timezone_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_timezone_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_timezone_settings  # noqa: E501

        Retrieve the cluster timezone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_timezone_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: TimezoneSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_timezone_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/timezone/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimezoneSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_email(self, cluster_email, **kwargs):  # noqa: E501
        """update_cluster_email  # noqa: E501

        Modify the cluster email notification settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_email(cluster_email, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterEmailExtended cluster_email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_email_with_http_info(cluster_email, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_email_with_http_info(cluster_email, **kwargs)  # noqa: E501
            return data

    def update_cluster_email_with_http_info(self, cluster_email, **kwargs):  # noqa: E501
        """update_cluster_email  # noqa: E501

        Modify the cluster email notification settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_email_with_http_info(cluster_email, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterEmailExtended cluster_email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_email']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_email' is set
        if ('cluster_email' not in params or
                params['cluster_email'] is None):
            raise ValueError("Missing the required parameter `cluster_email` when calling `update_cluster_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_email' in params:
            body_params = params['cluster_email']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/cluster/email', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_identity(self, cluster_identity, **kwargs):  # noqa: E501
        """update_cluster_identity  # noqa: E501

        Modify the login information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_identity(cluster_identity, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterIdentityExtended cluster_identity: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_identity_with_http_info(cluster_identity, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_identity_with_http_info(cluster_identity, **kwargs)  # noqa: E501
            return data

    def update_cluster_identity_with_http_info(self, cluster_identity, **kwargs):  # noqa: E501
        """update_cluster_identity  # noqa: E501

        Modify the login information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_identity_with_http_info(cluster_identity, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterIdentityExtended cluster_identity: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_identity']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_identity' is set
        if ('cluster_identity' not in params or
                params['cluster_identity'] is None):
            raise ValueError("Missing the required parameter `cluster_identity` when calling `update_cluster_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_identity' in params:
            body_params = params['cluster_identity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/cluster/identity', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_internal_networks(self, cluster_internal_networks, **kwargs):  # noqa: E501
        """update_cluster_internal_networks  # noqa: E501

        Modify IP address ranges to be used for internal network configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_internal_networks(cluster_internal_networks, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterInternalNetworksExtended cluster_internal_networks: (required)
        :param str reboot_confirmation_token: Token returned by earlier PUT call with the same configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_internal_networks_with_http_info(cluster_internal_networks, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_internal_networks_with_http_info(cluster_internal_networks, **kwargs)  # noqa: E501
            return data

    def update_cluster_internal_networks_with_http_info(self, cluster_internal_networks, **kwargs):  # noqa: E501
        """update_cluster_internal_networks  # noqa: E501

        Modify IP address ranges to be used for internal network configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_internal_networks_with_http_info(cluster_internal_networks, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterInternalNetworksExtended cluster_internal_networks: (required)
        :param str reboot_confirmation_token: Token returned by earlier PUT call with the same configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_internal_networks', 'reboot_confirmation_token']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_internal_networks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_internal_networks' is set
        if ('cluster_internal_networks' not in params or
                params['cluster_internal_networks'] is None):
            raise ValueError("Missing the required parameter `cluster_internal_networks` when calling `update_cluster_internal_networks`")  # noqa: E501

        if ('reboot_confirmation_token' in params and
                len(params['reboot_confirmation_token']) > -1):
            raise ValueError("Invalid value for parameter `reboot_confirmation_token` when calling `update_cluster_internal_networks`, length must be less than or equal to `-1`")  # noqa: E501
        if ('reboot_confirmation_token' in params and
                len(params['reboot_confirmation_token']) < 0):
            raise ValueError("Invalid value for parameter `reboot_confirmation_token` when calling `update_cluster_internal_networks`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'reboot_confirmation_token' in params:
            query_params.append(('reboot_confirmation_token', params['reboot_confirmation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_internal_networks' in params:
            body_params = params['cluster_internal_networks']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/internal-networks', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_node(self, cluster_node, cluster_node_id, **kwargs):  # noqa: E501
        """update_cluster_node  # noqa: E501

        Modify one or more node settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_node(cluster_node, cluster_node_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterNode cluster_node: (required)
        :param int cluster_node_id: Modify one or more node settings. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_node_with_http_info(cluster_node, cluster_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_node_with_http_info(cluster_node, cluster_node_id, **kwargs)  # noqa: E501
            return data

    def update_cluster_node_with_http_info(self, cluster_node, cluster_node_id, **kwargs):  # noqa: E501
        """update_cluster_node  # noqa: E501

        Modify one or more node settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_node_with_http_info(cluster_node, cluster_node_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterNode cluster_node: (required)
        :param int cluster_node_id: Modify one or more node settings. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_node', 'cluster_node_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_node' is set
        if ('cluster_node' not in params or
                params['cluster_node'] is None):
            raise ValueError("Missing the required parameter `cluster_node` when calling `update_cluster_node`")  # noqa: E501
        # verify the required parameter 'cluster_node_id' is set
        if ('cluster_node_id' not in params or
                params['cluster_node_id'] is None):
            raise ValueError("Missing the required parameter `cluster_node_id` when calling `update_cluster_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_node_id' in params:
            path_params['ClusterNodeId'] = params['cluster_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_node' in params:
            body_params = params['cluster_node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{ClusterNodeId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_owner(self, cluster_owner, **kwargs):  # noqa: E501
        """update_cluster_owner  # noqa: E501

        Modify the cluster contact info settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_owner(cluster_owner, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterOwner cluster_owner: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_owner_with_http_info(cluster_owner, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_owner_with_http_info(cluster_owner, **kwargs)  # noqa: E501
            return data

    def update_cluster_owner_with_http_info(self, cluster_owner, **kwargs):  # noqa: E501
        """update_cluster_owner  # noqa: E501

        Modify the cluster contact info settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_owner_with_http_info(cluster_owner, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterOwner cluster_owner: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_owner']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_owner" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_owner' is set
        if ('cluster_owner' not in params or
                params['cluster_owner'] is None):
            raise ValueError("Missing the required parameter `cluster_owner` when calling `update_cluster_owner`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_owner' in params:
            body_params = params['cluster_owner']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/cluster/owner', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_time(self, cluster_time, **kwargs):  # noqa: E501
        """update_cluster_time  # noqa: E501

        Set cluster time.  Time will mostly be synchronized across nodes, but there may be slight drift.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_time(cluster_time, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterTimeExtended cluster_time: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_time_with_http_info(cluster_time, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_time_with_http_info(cluster_time, **kwargs)  # noqa: E501
            return data

    def update_cluster_time_with_http_info(self, cluster_time, **kwargs):  # noqa: E501
        """update_cluster_time  # noqa: E501

        Set cluster time.  Time will mostly be synchronized across nodes, but there may be slight drift.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_time_with_http_info(cluster_time, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterTimeExtended cluster_time: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_time']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_time" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_time' is set
        if ('cluster_time' not in params or
                params['cluster_time'] is None):
            raise ValueError("Missing the required parameter `cluster_time` when calling `update_cluster_time`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_time' in params:
            body_params = params['cluster_time']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/time', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_timezone(self, cluster_timezone, **kwargs):  # noqa: E501
        """update_cluster_timezone  # noqa: E501

        Set a new timezone for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_timezone(cluster_timezone, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterTimezoneExtended cluster_timezone: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_timezone_with_http_info(cluster_timezone, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_timezone_with_http_info(cluster_timezone, **kwargs)  # noqa: E501
            return data

    def update_cluster_timezone_with_http_info(self, cluster_timezone, **kwargs):  # noqa: E501
        """update_cluster_timezone  # noqa: E501

        Set a new timezone for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_timezone_with_http_info(cluster_timezone, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterTimezoneExtended cluster_timezone: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_timezone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_timezone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_timezone' is set
        if ('cluster_timezone' not in params or
                params['cluster_timezone'] is None):
            raise ValueError("Missing the required parameter `cluster_timezone` when calling `update_cluster_timezone`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_timezone' in params:
            body_params = params['cluster_timezone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/timezone', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_update_lnns(self, cluster_update_lnns, **kwargs):  # noqa: E501
        """update_cluster_update_lnns  # noqa: E501

        Modify the list of current lnn(s) with respective new lnn(s) to be used for configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_update_lnns(cluster_update_lnns, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterUpdateLnns cluster_update_lnns: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cluster_update_lnns_with_http_info(cluster_update_lnns, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_update_lnns_with_http_info(cluster_update_lnns, **kwargs)  # noqa: E501
            return data

    def update_cluster_update_lnns_with_http_info(self, cluster_update_lnns, **kwargs):  # noqa: E501
        """update_cluster_update_lnns  # noqa: E501

        Modify the list of current lnn(s) with respective new lnn(s) to be used for configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cluster_update_lnns_with_http_info(cluster_update_lnns, async=True)
        >>> result = thread.get()

        :param async bool
        :param ClusterUpdateLnns cluster_update_lnns: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_update_lnns']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_update_lnns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_update_lnns' is set
        if ('cluster_update_lnns' not in params or
                params['cluster_update_lnns'] is None):
            raise ValueError("Missing the required parameter `cluster_update_lnns` when calling `update_cluster_update_lnns`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_update_lnns' in params:
            body_params = params['cluster_update_lnns']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/update-lnns', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_diagnostics_gather_settings(self, diagnostics_gather_settings, **kwargs):  # noqa: E501
        """update_diagnostics_gather_settings  # noqa: E501

        Set the default options for isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_diagnostics_gather_settings(diagnostics_gather_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsGatherSettingsExtended diagnostics_gather_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_diagnostics_gather_settings_with_http_info(diagnostics_gather_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_diagnostics_gather_settings_with_http_info(diagnostics_gather_settings, **kwargs)  # noqa: E501
            return data

    def update_diagnostics_gather_settings_with_http_info(self, diagnostics_gather_settings, **kwargs):  # noqa: E501
        """update_diagnostics_gather_settings  # noqa: E501

        Set the default options for isi_gather_info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_diagnostics_gather_settings_with_http_info(diagnostics_gather_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsGatherSettingsExtended diagnostics_gather_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['diagnostics_gather_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_diagnostics_gather_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'diagnostics_gather_settings' is set
        if ('diagnostics_gather_settings' not in params or
                params['diagnostics_gather_settings'] is None):
            raise ValueError("Missing the required parameter `diagnostics_gather_settings` when calling `update_diagnostics_gather_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'diagnostics_gather_settings' in params:
            body_params = params['diagnostics_gather_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/gather/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_diagnostics_netlogger_settings(self, diagnostics_netlogger_settings, **kwargs):  # noqa: E501
        """update_diagnostics_netlogger_settings  # noqa: E501

        Set the default options for isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_diagnostics_netlogger_settings(diagnostics_netlogger_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsNetloggerSettingsSettings diagnostics_netlogger_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_diagnostics_netlogger_settings_with_http_info(diagnostics_netlogger_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_diagnostics_netlogger_settings_with_http_info(diagnostics_netlogger_settings, **kwargs)  # noqa: E501
            return data

    def update_diagnostics_netlogger_settings_with_http_info(self, diagnostics_netlogger_settings, **kwargs):  # noqa: E501
        """update_diagnostics_netlogger_settings  # noqa: E501

        Set the default options for isi_netlogger.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_diagnostics_netlogger_settings_with_http_info(diagnostics_netlogger_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param DiagnosticsNetloggerSettingsSettings diagnostics_netlogger_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['diagnostics_netlogger_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_diagnostics_netlogger_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'diagnostics_netlogger_settings' is set
        if ('diagnostics_netlogger_settings' not in params or
                params['diagnostics_netlogger_settings'] is None):
            raise ValueError("Missing the required parameter `diagnostics_netlogger_settings` when calling `update_diagnostics_netlogger_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'diagnostics_netlogger_settings' in params:
            body_params = params['diagnostics_netlogger_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/diagnostics/netlogger/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_timezone_settings(self, timezone_settings, **kwargs):  # noqa: E501
        """update_timezone_settings  # noqa: E501

        Modify the cluster timezone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_timezone_settings(timezone_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param TimezoneRegionTimezone timezone_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_timezone_settings_with_http_info(timezone_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_timezone_settings_with_http_info(timezone_settings, **kwargs)  # noqa: E501
            return data

    def update_timezone_settings_with_http_info(self, timezone_settings, **kwargs):  # noqa: E501
        """update_timezone_settings  # noqa: E501

        Modify the cluster timezone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_timezone_settings_with_http_info(timezone_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param TimezoneRegionTimezone timezone_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timezone_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_timezone_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'timezone_settings' is set
        if ('timezone_settings' not in params or
                params['timezone_settings'] is None):
            raise ValueError("Missing the required parameter `timezone_settings` when calling `update_timezone_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'timezone_settings' in params:
            body_params = params['timezone_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/timezone/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
