"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnatEntry = exports.SnatEntryProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "SnatEntryProperty", { enumerable: true, get: function () { return vpc_generated_1.RosSnatEntry; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::SnatEntry`
 */
class SnatEntry extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::SnatEntry`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSnatEntry = new vpc_generated_1.RosSnatEntry(this, id, {
            snatEntryName: props.snatEntryName,
            sourceVSwitchIds: props.sourceVSwitchIds,
            sourceCidr: props.sourceCidr,
            snatIp: props.snatIp,
            snatTableId: props.snatTableId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSnatEntry;
        this.attrSnatEntryIds = rosSnatEntry.attrSnatEntryIds;
    }
}
exports.SnatEntry = SnatEntry;
//# sourceMappingURL=data:application/json;base64,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