"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PeeringRouterInterfaceBinding = exports.PeeringRouterInterfaceBindingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "PeeringRouterInterfaceBindingProperty", { enumerable: true, get: function () { return vpc_generated_1.RosPeeringRouterInterfaceBinding; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::PeeringRouterInterfaceBinding`
 */
class PeeringRouterInterfaceBinding extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::PeeringRouterInterfaceBinding`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPeeringRouterInterfaceBinding = new vpc_generated_1.RosPeeringRouterInterfaceBinding(this, id, {
            oppositeInterfaceId: props.oppositeInterfaceId,
            oppositeInterfaceOwnerId: props.oppositeInterfaceOwnerId,
            oppositeRouterId: props.oppositeRouterId,
            routerInterfaceId: props.routerInterfaceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPeeringRouterInterfaceBinding;
        this.attrRouterInterfaceId = rosPeeringRouterInterfaceBinding.attrRouterInterfaceId;
    }
}
exports.PeeringRouterInterfaceBinding = PeeringRouterInterfaceBinding;
//# sourceMappingURL=data:application/json;base64,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