# Generated by Django 3.2.18 on 2023-03-10 10:20

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import nautobot.extras.models.mixins
import nautobot.extras.models.statuses
import nautobot_dns_records.validators
import taggit.managers
import uuid


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0054_scheduledjob_kwargs_request_user_change"),
        ("dcim", "0019_device_redundancy_group_data_migration"),
        ("nautobot_dns_records", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="SrvRecord",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "label",
                    models.CharField(max_length=255, validators=[nautobot_dns_records.validators.validate_dns_name]),
                ),
                (
                    "ttl",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(604800),
                        ]
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(65535),
                        ]
                    ),
                ),
                (
                    "weight",
                    models.IntegerField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(65535),
                        ],
                    ),
                ),
                (
                    "port",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(65535),
                        ]
                    ),
                ),
                (
                    "target",
                    models.CharField(max_length=255, validators=[nautobot_dns_records.validators.validate_dns_name]),
                ),
                (
                    "device",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to="dcim.device"
                    ),
                ),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_dns_records_srvrecord_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
    ]
