# This file was autogenerated. Do not edit.

from typing import Dict, Optional

from pydantic import BaseModel

from robusta.core.model.k8s_operation_type import K8sOperationType
from robusta.integrations.kubernetes.autogenerated.events import *
from robusta.integrations.kubernetes.base_triggers import DEFAULT_CHANGE_FILTERS, K8sBaseTrigger
from robusta.utils.scope import ScopeParams


# Pod Triggers
class PodAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Pod",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PodChangeEvent


class PodCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Pod",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PodChangeEvent


class PodDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Pod",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PodChangeEvent


class PodUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Pod",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PodChangeEvent


# ReplicaSet Triggers
class ReplicaSetAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ReplicaSet",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ReplicaSetChangeEvent


class ReplicaSetCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ReplicaSet",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ReplicaSetChangeEvent


class ReplicaSetDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ReplicaSet",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ReplicaSetChangeEvent


class ReplicaSetUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ReplicaSet",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ReplicaSetChangeEvent


# DaemonSet Triggers
class DaemonSetAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="DaemonSet",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DaemonSetChangeEvent


class DaemonSetCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="DaemonSet",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DaemonSetChangeEvent


class DaemonSetDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="DaemonSet",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DaemonSetChangeEvent


class DaemonSetUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="DaemonSet",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DaemonSetChangeEvent


# Deployment Triggers
class DeploymentAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Deployment",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DeploymentChangeEvent


class DeploymentCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Deployment",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DeploymentChangeEvent


class DeploymentDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Deployment",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DeploymentChangeEvent


class DeploymentUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Deployment",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return DeploymentChangeEvent


# StatefulSet Triggers
class StatefulSetAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="StatefulSet",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return StatefulSetChangeEvent


class StatefulSetCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="StatefulSet",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return StatefulSetChangeEvent


class StatefulSetDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="StatefulSet",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return StatefulSetChangeEvent


class StatefulSetUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="StatefulSet",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return StatefulSetChangeEvent


# Service Triggers
class ServiceAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Service",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceChangeEvent


class ServiceCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Service",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceChangeEvent


class ServiceDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Service",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceChangeEvent


class ServiceUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Service",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceChangeEvent


# Event Triggers
class EventAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Event",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return EventChangeEvent


class EventCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Event",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return EventChangeEvent


class EventDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Event",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return EventChangeEvent


class EventUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Event",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return EventChangeEvent


# HorizontalPodAutoscaler Triggers
class HorizontalPodAutoscalerAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="HorizontalPodAutoscaler",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return HorizontalPodAutoscalerChangeEvent


class HorizontalPodAutoscalerCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="HorizontalPodAutoscaler",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return HorizontalPodAutoscalerChangeEvent


class HorizontalPodAutoscalerDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="HorizontalPodAutoscaler",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return HorizontalPodAutoscalerChangeEvent


class HorizontalPodAutoscalerUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="HorizontalPodAutoscaler",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return HorizontalPodAutoscalerChangeEvent


# Node Triggers
class NodeAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Node",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NodeChangeEvent


class NodeCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Node",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NodeChangeEvent


class NodeDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Node",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NodeChangeEvent


class NodeUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Node",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NodeChangeEvent


# ClusterRole Triggers
class ClusterRoleAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRole",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleChangeEvent


class ClusterRoleCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRole",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleChangeEvent


class ClusterRoleDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRole",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleChangeEvent


class ClusterRoleUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRole",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleChangeEvent


# ClusterRoleBinding Triggers
class ClusterRoleBindingAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRoleBinding",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleBindingChangeEvent


class ClusterRoleBindingCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRoleBinding",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleBindingChangeEvent


class ClusterRoleBindingDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRoleBinding",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleBindingChangeEvent


class ClusterRoleBindingUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ClusterRoleBinding",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ClusterRoleBindingChangeEvent


# Job Triggers
class JobAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Job",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return JobChangeEvent


class JobCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Job",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return JobChangeEvent


class JobDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Job",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return JobChangeEvent


class JobUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Job",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return JobChangeEvent


# Namespace Triggers
class NamespaceAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Namespace",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NamespaceChangeEvent


class NamespaceCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Namespace",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NamespaceChangeEvent


class NamespaceDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Namespace",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NamespaceChangeEvent


class NamespaceUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Namespace",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NamespaceChangeEvent


# ServiceAccount Triggers
class ServiceAccountAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ServiceAccount",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceAccountChangeEvent


class ServiceAccountCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ServiceAccount",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceAccountChangeEvent


class ServiceAccountDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ServiceAccount",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceAccountChangeEvent


class ServiceAccountUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ServiceAccount",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ServiceAccountChangeEvent


# PersistentVolume Triggers
class PersistentVolumeAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolume",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeChangeEvent


class PersistentVolumeCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolume",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeChangeEvent


class PersistentVolumeDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolume",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeChangeEvent


class PersistentVolumeUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolume",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeChangeEvent


# PersistentVolumeClaim Triggers
class PersistentVolumeClaimAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolumeClaim",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeClaimChangeEvent


class PersistentVolumeClaimCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolumeClaim",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeClaimChangeEvent


class PersistentVolumeClaimDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolumeClaim",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeClaimChangeEvent


class PersistentVolumeClaimUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="PersistentVolumeClaim",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return PersistentVolumeClaimChangeEvent


# NetworkPolicy Triggers
class NetworkPolicyAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="NetworkPolicy",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NetworkPolicyChangeEvent


class NetworkPolicyCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="NetworkPolicy",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NetworkPolicyChangeEvent


class NetworkPolicyDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="NetworkPolicy",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NetworkPolicyChangeEvent


class NetworkPolicyUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="NetworkPolicy",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return NetworkPolicyChangeEvent


# ConfigMap Triggers
class ConfigMapAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ConfigMap",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ConfigMapChangeEvent


class ConfigMapCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ConfigMap",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ConfigMapChangeEvent


class ConfigMapDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ConfigMap",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ConfigMapChangeEvent


class ConfigMapUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="ConfigMap",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return ConfigMapChangeEvent


# Ingress Triggers
class IngressAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Ingress",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return IngressChangeEvent


class IngressCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Ingress",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return IngressChangeEvent


class IngressDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Ingress",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return IngressChangeEvent


class IngressUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Ingress",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return IngressChangeEvent


# Secret Triggers
class SecretAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Secret",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return SecretChangeEvent


class SecretCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Secret",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return SecretChangeEvent


class SecretDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Secret",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return SecretChangeEvent


class SecretUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Secret",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return SecretChangeEvent


# Kubernetes Any Triggers
class KubernetesAnyAllChangesTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Any",
            operation=None,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return KubernetesAnyChangeEvent


class KubernetesAnyCreateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Any",
            operation=K8sOperationType.CREATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return KubernetesAnyChangeEvent


class KubernetesAnyDeleteTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Any",
            operation=K8sOperationType.DELETE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return KubernetesAnyChangeEvent


class KubernetesAnyUpdateTrigger(K8sBaseTrigger):
    def __init__(
        self,
        name_prefix: str = None,
        namespace_prefix: str = None,
        labels_selector: str = None,
        change_filters: Dict[str, List[str]] = None,
        scope: ScopeParams = None,
    ):
        super().__init__(
            kind="Any",
            operation=K8sOperationType.UPDATE,
            name_prefix=name_prefix,
            namespace_prefix=namespace_prefix,
            labels_selector=labels_selector,
            change_filters=change_filters,
            scope=scope,
        )

    @staticmethod
    def get_execution_event_type() -> type:
        return KubernetesAnyChangeEvent


# K8s Trigger class
class K8sTriggers(BaseModel):

    on_clusterrole_all_changes: Optional[ClusterRoleAllChangesTrigger]
    on_clusterrole_create: Optional[ClusterRoleCreateTrigger]
    on_clusterrole_delete: Optional[ClusterRoleDeleteTrigger]
    on_clusterrole_update: Optional[ClusterRoleUpdateTrigger]
    on_clusterrolebinding_all_changes: Optional[ClusterRoleBindingAllChangesTrigger]
    on_clusterrolebinding_create: Optional[ClusterRoleBindingCreateTrigger]
    on_clusterrolebinding_delete: Optional[ClusterRoleBindingDeleteTrigger]
    on_clusterrolebinding_update: Optional[ClusterRoleBindingUpdateTrigger]
    on_configmap_all_changes: Optional[ConfigMapAllChangesTrigger]
    on_configmap_create: Optional[ConfigMapCreateTrigger]
    on_configmap_delete: Optional[ConfigMapDeleteTrigger]
    on_configmap_update: Optional[ConfigMapUpdateTrigger]
    on_daemonset_all_changes: Optional[DaemonSetAllChangesTrigger]
    on_daemonset_create: Optional[DaemonSetCreateTrigger]
    on_daemonset_delete: Optional[DaemonSetDeleteTrigger]
    on_daemonset_update: Optional[DaemonSetUpdateTrigger]
    on_deployment_all_changes: Optional[DeploymentAllChangesTrigger]
    on_deployment_create: Optional[DeploymentCreateTrigger]
    on_deployment_delete: Optional[DeploymentDeleteTrigger]
    on_deployment_update: Optional[DeploymentUpdateTrigger]
    on_event_all_changes: Optional[EventAllChangesTrigger]
    on_event_create: Optional[EventCreateTrigger]
    on_event_delete: Optional[EventDeleteTrigger]
    on_event_update: Optional[EventUpdateTrigger]
    on_horizontalpodautoscaler_all_changes: Optional[HorizontalPodAutoscalerAllChangesTrigger]
    on_horizontalpodautoscaler_create: Optional[HorizontalPodAutoscalerCreateTrigger]
    on_horizontalpodautoscaler_delete: Optional[HorizontalPodAutoscalerDeleteTrigger]
    on_horizontalpodautoscaler_update: Optional[HorizontalPodAutoscalerUpdateTrigger]
    on_ingress_all_changes: Optional[IngressAllChangesTrigger]
    on_ingress_create: Optional[IngressCreateTrigger]
    on_ingress_delete: Optional[IngressDeleteTrigger]
    on_ingress_update: Optional[IngressUpdateTrigger]
    on_job_all_changes: Optional[JobAllChangesTrigger]
    on_job_create: Optional[JobCreateTrigger]
    on_job_delete: Optional[JobDeleteTrigger]
    on_job_update: Optional[JobUpdateTrigger]
    on_kubernetes_any_resource_all_changes: Optional[KubernetesAnyAllChangesTrigger]
    on_kubernetes_any_resource_create: Optional[KubernetesAnyCreateTrigger]
    on_kubernetes_any_resource_delete: Optional[KubernetesAnyDeleteTrigger]
    on_kubernetes_any_resource_update: Optional[KubernetesAnyUpdateTrigger]
    on_namespace_all_changes: Optional[NamespaceAllChangesTrigger]
    on_namespace_create: Optional[NamespaceCreateTrigger]
    on_namespace_delete: Optional[NamespaceDeleteTrigger]
    on_namespace_update: Optional[NamespaceUpdateTrigger]
    on_networkpolicy_all_changes: Optional[NetworkPolicyAllChangesTrigger]
    on_networkpolicy_create: Optional[NetworkPolicyCreateTrigger]
    on_networkpolicy_delete: Optional[NetworkPolicyDeleteTrigger]
    on_networkpolicy_update: Optional[NetworkPolicyUpdateTrigger]
    on_node_all_changes: Optional[NodeAllChangesTrigger]
    on_node_create: Optional[NodeCreateTrigger]
    on_node_delete: Optional[NodeDeleteTrigger]
    on_node_update: Optional[NodeUpdateTrigger]
    on_persistentvolume_all_changes: Optional[PersistentVolumeAllChangesTrigger]
    on_persistentvolume_create: Optional[PersistentVolumeCreateTrigger]
    on_persistentvolume_delete: Optional[PersistentVolumeDeleteTrigger]
    on_persistentvolume_update: Optional[PersistentVolumeUpdateTrigger]
    on_persistentvolumeclaim_all_changes: Optional[PersistentVolumeClaimAllChangesTrigger]
    on_persistentvolumeclaim_create: Optional[PersistentVolumeClaimCreateTrigger]
    on_persistentvolumeclaim_delete: Optional[PersistentVolumeClaimDeleteTrigger]
    on_persistentvolumeclaim_update: Optional[PersistentVolumeClaimUpdateTrigger]
    on_pod_all_changes: Optional[PodAllChangesTrigger]
    on_pod_create: Optional[PodCreateTrigger]
    on_pod_delete: Optional[PodDeleteTrigger]
    on_pod_update: Optional[PodUpdateTrigger]
    on_replicaset_all_changes: Optional[ReplicaSetAllChangesTrigger]
    on_replicaset_create: Optional[ReplicaSetCreateTrigger]
    on_replicaset_delete: Optional[ReplicaSetDeleteTrigger]
    on_replicaset_update: Optional[ReplicaSetUpdateTrigger]
    on_secret_all_changes: Optional[SecretAllChangesTrigger]
    on_secret_create: Optional[SecretCreateTrigger]
    on_secret_delete: Optional[SecretDeleteTrigger]
    on_secret_update: Optional[SecretUpdateTrigger]
    on_service_all_changes: Optional[ServiceAllChangesTrigger]
    on_service_create: Optional[ServiceCreateTrigger]
    on_service_delete: Optional[ServiceDeleteTrigger]
    on_service_update: Optional[ServiceUpdateTrigger]
    on_serviceaccount_all_changes: Optional[ServiceAccountAllChangesTrigger]
    on_serviceaccount_create: Optional[ServiceAccountCreateTrigger]
    on_serviceaccount_delete: Optional[ServiceAccountDeleteTrigger]
    on_serviceaccount_update: Optional[ServiceAccountUpdateTrigger]
    on_statefulset_all_changes: Optional[StatefulSetAllChangesTrigger]
    on_statefulset_create: Optional[StatefulSetCreateTrigger]
    on_statefulset_delete: Optional[StatefulSetDeleteTrigger]
    on_statefulset_update: Optional[StatefulSetUpdateTrigger]
