"""

Copyright 2021 Triple Dot Engineering LLC

"""
import yaml
from ..util import jmi

class YamlEgester:
    """
    The YAML Egester outputs model data as a YAML file.
    """

    name = 'yaml'


    def __init__(self, args):
        """Initializes the egester"""
        #self._stdout = args.stdout
        self.model = None
        self._target = args.out_tgt if args.out_tgt is not None else 'output.yaml'


    def run(self, data):
        """Runs the egester"""
        # Convert from JMI 1->3
        self.model = jmi.convert(data, 1, 3)

        # Cleanup the fields we really don't need in the YAML
        self.clean()
        model = {
            "TriviumYamlFormatVersion": "1.0",
            "Description": "Trivium ETL Autogenerated YAML",
            "Model": self.model
        }

        with open(self._target, 'w', encoding='utf-8') as f:
            yaml.dump(model, f, allow_unicode=True, sort_keys=False)


    def clean(self, ptr=None):
        """Cleans up the model data"""
        # Root case
        if ptr is None:
            for root in self.model.keys():
                self.clean(self.model[root])
            return
        if isinstance(ptr, str):
            return

        for c in ptr['contains'].keys():
            self.clean(ptr['contains'][c])

        ptr.pop('parent', None)
        ptr.pop('id', None)
        if len(ptr['contains'].keys()) == 0:
            ptr.pop('contains', None)
