/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import com.google.gson.JsonObject;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.SharedTreeModelAttributes;
import java.io.IOException;

public abstract class SharedTreeMojoReader<M extends SharedTreeMojoModel>
extends ModelMojoReader<M> {
    @Override
    protected void readModelData() throws IOException {
        int i2;
        Integer tpc = (Integer)this.readkv("n_trees_per_class");
        if (tpc == null) {
            Boolean bdt = (Boolean)this.readkv("binomial_double_trees");
            tpc = ((SharedTreeMojoModel)this._model).nclasses() == 2 && (bdt == null || bdt == false) ? 1 : ((SharedTreeMojoModel)this._model).nclasses();
        }
        ((SharedTreeMojoModel)this._model)._ntree_groups = (Integer)this.readkv("n_trees");
        ((SharedTreeMojoModel)this._model)._ntrees_per_group = tpc;
        ((SharedTreeMojoModel)this._model)._compressed_trees = new byte[((SharedTreeMojoModel)this._model)._ntree_groups * tpc][];
        ((SharedTreeMojoModel)this._model)._mojo_version = ((Number)this.readkv("mojo_version")).doubleValue();
        if (((SharedTreeMojoModel)this._model)._mojo_version < 1.4) {
            ((SharedTreeMojoModel)this._model)._genmodel_encoding = "AUTO";
        } else {
            ((SharedTreeMojoModel)this._model)._genmodel_encoding = this.readkv("_genmodel_encoding").toString();
            ((SharedTreeMojoModel)this._model)._orig_projection_array = this.readkv("_orig_projection_array", new double[0]);
            Integer n2 = (Integer)this.readkv("_n_orig_names");
            if (n2 != null) {
                ((SharedTreeMojoModel)this._model)._orig_names = this.readStringArray("_orig_names", n2);
            }
            if ((n2 = (Integer)this.readkv("_n_orig_domain_values")) != null) {
                ((SharedTreeMojoModel)this._model)._orig_domain_values = new String[n2.intValue()][];
                for (i2 = 0; i2 < n2; ++i2) {
                    int m2 = (Integer)this.readkv("_m_orig_domain_values_" + i2);
                    if (m2 <= 0) continue;
                    ((SharedTreeMojoModel)this._model)._orig_domain_values[i2] = this.readStringArray("_orig_domain_values_" + i2, m2);
                }
            }
        }
        if (((SharedTreeMojoModel)this._model)._mojo_version > 1.0) {
            ((SharedTreeMojoModel)this._model)._compressed_trees_aux = new byte[((SharedTreeMojoModel)this._model)._ntree_groups * tpc][];
        }
        for (int j2 = 0; j2 < ((SharedTreeMojoModel)this._model)._ntree_groups; ++j2) {
            for (i2 = 0; i2 < tpc; ++i2) {
                String blobName = String.format("trees/t%02d_%03d.bin", i2, j2);
                if (!this.exists(blobName)) continue;
                ((SharedTreeMojoModel)this._model)._compressed_trees[((SharedTreeMojoModel)this._model).treeIndex((int)j2, (int)i2)] = this.readblob(blobName);
                if (((SharedTreeMojoModel)this._model)._compressed_trees_aux == null) continue;
                ((SharedTreeMojoModel)this._model)._compressed_trees_aux[((SharedTreeMojoModel)this._model).treeIndex((int)j2, (int)i2)] = this.readblob(String.format("trees/t%02d_%03d_aux.bin", i2, j2));
            }
        }
        String calibMethod = (String)this.readkv("calib_method");
        if (calibMethod != null) {
            if (!"platt".equals(calibMethod)) {
                throw new IllegalStateException("Unknown calibration method: " + calibMethod);
            }
            ((SharedTreeMojoModel)this._model)._calib_glm_beta = this.readkv("calib_glm_beta", new double[0]);
        }
        ((SharedTreeMojoModel)this._model).postInit();
    }

    @Override
    protected SharedTreeModelAttributes readModelSpecificAttributes() {
        JsonObject modelJson = ModelJsonReader.parseModelJson(this._reader);
        if (modelJson != null) {
            return new SharedTreeModelAttributes(modelJson, this._model);
        }
        return null;
    }
}

