/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import ai.h2o.sparkling.utils.DataFrameSerializationWrappers$;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting clustering.")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\n\u0015\u0001}A\u0001\u0002\n\u0001\u0003\u0006\u0004%\t%\n\u0005\tg\u0001\u0011\t\u0011)A\u0005M!)A\u0007\u0001C\u0001k!)A\u0007\u0001C\u0001q!9\u0011\b\u0001b\u0001\n#Q\u0004B\u0002%\u0001A\u0003%1\bC\u0004J\u0001\t\u0007I\u0011\u0003\u001e\t\r)\u0003\u0001\u0015!\u0003<\u0011\u001dY\u0005A1A\u0005\u0012iBa\u0001\u0014\u0001!\u0002\u0013Y\u0004bB'\u0001\u0005\u0004%\tB\u0014\u0005\u0007+\u0002\u0001\u000b\u0011B(\t\u000bY\u0003A\u0011A,\t\u000bq\u0003A\u0011A,\t\u000bu\u0003A\u0011A,\t\u000by\u0003A\u0011A0\t\u000bE\u0004A\u0011\t:\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\t!\u0002JM(DYV\u001cH/\u001a:j]\u001elU\r\u001e:jGNT!!\u0006\f\u0002\u000f5,GO]5dg*\u0011q\u0003G\u0001\u0003[2T!!\u0007\u000e\u0002\u0013M\u0004\u0018M]6mS:<'BA\u000e\u001d\u0003\rA'g\u001c\u0006\u0002;\u0005\u0011\u0011-[\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\tA#\u0003\u0002$)\t\u0001\u0002JM(D_6lwN\\'fiJL7m]\u0001\u0004k&$W#\u0001\u0014\u0011\u0005\u001d\u0002dB\u0001\u0015/!\tIC&D\u0001+\u0015\tYc$\u0001\u0004=e>|GO\u0010\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006L\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020Y\u0005!Q/\u001b3!\u0003\u0019a\u0014N\\5u}Q\u0011ag\u000e\t\u0003C\u0001AQ\u0001J\u0002A\u0002\u0019\"\u0012AN\u0001\fi>$x+\u001b;iS:\u001c8/F\u0001<!\tad)D\u0001>\u0015\tqt(A\u0003qCJ\fWN\u0003\u0002\u0018\u0001*\u0011\u0011IQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014x-\u0003\u0002H{\tYAi\\;cY\u0016\u0004\u0016M]1n\u00031!x\u000e^,ji\"Lgn]:!\u0003\u0015!x\u000e^:t\u0003\u0019!x\u000e^:tA\u0005I!-\u001a;xK\u0016t7o]\u0001\u000bE\u0016$x/Z3ogN\u0004\u0013!D2f]R\u0014x.\u001b3Ti\u0006$8/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011f#\u0001\u0004qCJ\fWn]\u0005\u0003)F\u0013aCT;mY\u0006\u0014G.\u001a#bi\u00064%/Y7f!\u0006\u0014\u0018-\\\u0001\u000fG\u0016tGO]8jIN#\u0018\r^:!\u000399W\r\u001e+pi^KG\u000f[5ogN$\u0012\u0001\u0017\t\u00033jk\u0011\u0001L\u0005\u000372\u0012a\u0001R8vE2,\u0017\u0001C4fiR{Go]:\u0002\u0019\u001d,GOQ3uo\u0016,gn]:\u0002!\u001d,GoQ3oiJ|\u0017\u000eZ*uCR\u001cH#\u00011\u0011\u0005\u0005tgB\u00012l\u001d\t\u0019\u0017N\u0004\u0002eQ:\u0011Qm\u001a\b\u0003S\u0019L\u0011!R\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0005)\u0004\u0015aA:rY&\u0011A.\\\u0001\ba\u0006\u001c7.Y4f\u0015\tQ\u0007)\u0003\u0002pa\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003Y6\f!b]3u\u001b\u0016$(/[2t)\u0011\u0019h/!\u0002\u0011\u0005e#\u0018BA;-\u0005\u0011)f.\u001b;\t\u000b]\f\u0002\u0019\u0001=\u0002\t)\u001cxN\u001c\t\u0004s\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018\u0001B4t_:T!! @\u0002\r\u001d|wn\u001a7f\u0015\u0005y\u0018aA2p[&\u0019\u00111\u0001>\u0003\u0015)\u001bxN\\(cU\u0016\u001cG\u000f\u0003\u0004\u0002\bE\u0001\rAJ\u0001\bG>tG/\u001a=u\u0003\u0011\u0019w\u000e]=\u0015\t\u00055\u0011qB\u0007\u0002\u0001!9\u0011\u0011\u0003\nA\u0002\u0005M\u0011!B3yiJ\f\u0007c\u0001\u001f\u0002\u0016%\u0019\u0011qC\u001f\u0003\u0011A\u000b'/Y7NCBDs\u0001AA\u000e\u0003C\t\u0019\u0003E\u0002\"\u0003;I1!a\b\u0015\u0005IiU\r\u001e:jGN$Um]2sSB$\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003K\ta\f\u00165fA\rd\u0017m]:![\u0006\\Wm\u001d\u0011bm\u0006LG.\u00192mK\u0002\nG\u000e\u001c\u0011nKR\u0014\u0018nY:!i\"\fG\u000fI:iCJ,G\rI1de>\u001c8\u000fI1mY\u0002\nGnZ8sSRDWn\u001d\u0011tkB\u0004xN\u001d;j]\u001e\u00043\r\\;ti\u0016\u0014\u0018N\\4/\u0001")
public class H2OClusteringMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam totWithinss;
    private final DoubleParam totss;
    private final DoubleParam betweenss;
    private final NullableDataFrameParam centroidStats;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam totWithinss() {
        return this.totWithinss;
    }

    public DoubleParam totss() {
        return this.totss;
    }

    public DoubleParam betweenss() {
        return this.betweenss;
    }

    public NullableDataFrameParam centroidStats() {
        return this.centroidStats;
    }

    public double getTotWithinss() {
        return BoxesRunTime.unboxToDouble(this.$(this.totWithinss()));
    }

    public double getTotss() {
        return BoxesRunTime.unboxToDouble(this.$(this.totss()));
    }

    public double getBetweenss() {
        return BoxesRunTime.unboxToDouble(this.$(this.betweenss()));
    }

    public Dataset<Row> getCentroidStats() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.centroidStats()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block37: {
            Params params;
            block34: {
                block33: {
                    Params params2;
                    block30: {
                        block29: {
                            Params params3;
                            block26: {
                                super.setMetrics(json, context);
                                if (!json.has("tot_withinss")) break block26;
                                try {
                                    params3 = this.set("totWithinss", BoxesRunTime.boxToDouble((double)json.get("tot_withinss").getAsDouble()));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2;
                                    block28: {
                                        block27: {
                                            Throwable throwable3 = throwable;
                                            if (throwable3 == null) break block27;
                                            throwable2 = throwable3;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string2 = "true";
                                            if (string == null ? string2 != null : !string.equals(string2)) break block28;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unsuccessful try to extract 'tot_withinss' from ").append(context).toString(), throwable2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block29;
                            }
                            String message = new StringBuilder(45).append("The metric 'tot_withinss' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string3 = "true";
                            if (!(string == null ? string3 != null : !string.equals(string3))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("totss")) break block30;
                        try {
                            params2 = this.set("totss", BoxesRunTime.boxToDouble((double)json.get("totss").getAsDouble()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable4;
                            block32: {
                                block31: {
                                    Throwable throwable5 = throwable;
                                    if (throwable5 == null) break block31;
                                    throwable4 = throwable5;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string4 = "true";
                                    if (string == null ? string4 != null : !string.equals(string4)) break block32;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Unsuccessful try to extract 'totss' from ").append(context).toString(), throwable4);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block33;
                    }
                    String message = new StringBuilder(38).append("The metric 'totss' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string5 = "true";
                    if (!(string == null ? string5 != null : !string.equals(string5))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("betweenss")) break block34;
                try {
                    params = this.set("betweenss", BoxesRunTime.boxToDouble((double)json.get("betweenss").getAsDouble()));
                }
                catch (Throwable throwable) {
                    Throwable throwable6;
                    block36: {
                        block35: {
                            Throwable throwable7 = throwable;
                            if (throwable7 == null) break block35;
                            throwable6 = throwable7;
                            String string = System.getProperty("spark.testing", "false");
                            String string6 = "true";
                            if (string == null ? string6 != null : !string.equals(string6)) break block36;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Unsuccessful try to extract 'betweenss' from ").append(context).toString(), throwable6);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block37;
            }
            String message = new StringBuilder(42).append("The metric 'betweenss' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (!(string == null ? string7 != null : !string.equals(string7))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("centroid_stats")) {
            try {
                this.set("centroidStats", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "centroid_stats")));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 != null) {
                    Throwable throwable9 = throwable8;
                    String string = System.getProperty("spark.testing", "false");
                    String string8 = "true";
                    if (string == null ? string8 != null : !string.equals(string8)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Unsuccessful try to extract 'centroid_stats' from ").append(context).toString(), throwable9);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(47).append("The metric 'centroid_stats' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null ? string9 != null : !string.equals(string9)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2OClusteringMetrics copy(ParamMap extra) {
        return (H2OClusteringMetrics)this.defaultCopy(extra);
    }

    public H2OClusteringMetrics(String uid) {
        this.uid = uid;
        this.totWithinss = this.doubleParam("totWithinss", "Within Cluster Sum of Square Error.");
        this.totss = this.doubleParam("totss", "Total Sum of Square Error to Grand Mean.");
        this.betweenss = this.doubleParam("betweenss", "Between Cluster Sum of Square Error.");
        this.centroidStats = this.nullableDataFrameParam("centroidStats", "Centroid Statistics.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.totWithinss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.totss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.betweenss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.centroidStats().$minus$greater(null)}));
    }

    public H2OClusteringMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OClusteringMetrics"));
    }
}

