/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static final int BUFFER_LENGTH = 1024;
    static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private DigestUtils() {
    }

    public static byte[] hash(String algo, InputStream data) throws IOException {
        return DigestUtils.computeDigest(DigestUtils.getDigest(algo), data);
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
    }

    private static byte[] computeDigest(MessageDigest digest, InputStream data) throws IOException {
        return DigestUtils.updateDigest(digest, data).digest();
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream data) throws IOException {
        byte[] byArray = new byte[1024];
        int n2 = data.read(byArray, 0, 1024);
        while (n2 >= 0) {
            digest.update(byArray, 0, n2);
            n2 = data.read(byArray, 0, 1024);
        }
        return digest;
    }

    public static String toHex(byte[] bary) {
        StringBuilder stringBuilder = new StringBuilder(bary.length << 1);
        byte[] byArray = bary;
        int n2 = bary.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2];
            stringBuilder.append(HEX_DIGITS[(by & 0xFF) >> 4]).append(HEX_DIGITS[by & 0xF]);
        }
        assert (bary.length == 2 * stringBuilder.length());
        return stringBuilder.toString();
    }

    public static byte[] fromHex(String s2) {
        assert (s2 != null);
        return DigestUtils.fromHex(s2.toCharArray());
    }

    public static byte[] fromHex(char[] data) {
        if ((data.length & 1) != 0) {
            throw new IllegalArgumentException("Transformation from hex expects even number of characters");
        }
        byte[] byArray = new byte[data.length >> 1];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = DigestUtils.hexDigit(data[2 * i2]) << 4;
            byArray[i2] = (byte)(n2 |= DigestUtils.hexDigit(data[2 * i2 + 1]));
        }
        return byArray;
    }

    static int hexDigit(char c2) {
        int n2 = Character.digit(c2, 16);
        if (n2 == -1) {
            throw new IllegalArgumentException("Illegal hex-digit: " + c2);
        }
        return n2;
    }
}

