/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeParserBucket;

class DayOfWeekLetterParse
extends SubParser {
    private static final int TO_LOWER = 32;
    private static final String[] DAYS = new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};

    DayOfWeekLetterParse() {
    }

    @Override
    public int estimateParsedLength() {
        return 9;
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        int n2;
        int n3;
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        int n4 = text.length() - position;
        if (n4 > 9) {
            n4 = 9;
        } else if (n4 < 6) {
            return ~position;
        }
        char[] cArray = new char[n4];
        int n5 = position;
        text.getChars(n5, n5 + n4, cArray, 0);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = cArray[n3];
            if (n2 >= 97 && n2 <= 122 || n2 < 65 || n2 > 90) continue;
            int n6 = n3;
            cArray[n6] = (char)(cArray[n6] + 32);
        }
        block0 : switch (cArray[0]) {
            case 'm': {
                if (cArray[1] != 'o' || cArray[2] != 'n' || cArray[3] != 'd' || cArray[4] != 'a' || cArray[5] != 'y') {
                    n3 = -2;
                    break;
                }
                n3 = 1;
                break;
            }
            case 't': {
                switch (cArray[1]) {
                    case 'u': {
                        if (n4 < 7) {
                            return ~position;
                        }
                        if (cArray[2] != 'e' || cArray[3] != 's' || cArray[4] != 'd' || cArray[5] != 'a' || cArray[6] != 'y') {
                            n3 = -3;
                            break block0;
                        }
                        n3 = 2;
                        break block0;
                    }
                    case 'h': {
                        if (n4 < 8) {
                            return ~position;
                        }
                        if (cArray[2] != 'u' || cArray[3] != 'r' || cArray[4] != 's' || cArray[5] != 'd' || cArray[6] != 'a' || cArray[7] != 'y') {
                            n3 = -5;
                            break block0;
                        }
                        n3 = 4;
                        break block0;
                    }
                }
                return ~(position + 1);
            }
            case 'w': {
                if (n4 < 9) {
                    return ~position;
                }
                if (cArray[1] != 'e' || cArray[2] != 'd' || cArray[3] != 'n' || cArray[4] != 'e' || cArray[5] != 's' || cArray[6] != 'd' || cArray[7] != 'a' || cArray[8] != 'y') {
                    n3 = -4;
                    break;
                }
                n3 = 3;
                break;
            }
            case 'f': {
                if (cArray[1] != 'r' || cArray[2] != 'i' || cArray[3] != 'd' || cArray[4] != 'a' || cArray[5] != 'y') {
                    n3 = -6;
                    break;
                }
                n3 = 5;
                break;
            }
            case 's': {
                switch (cArray[1]) {
                    case 'a': {
                        if (n4 < 8) {
                            return ~position;
                        }
                        if (cArray[2] != 't' || cArray[3] != 'u' || cArray[4] != 'r' || cArray[5] != 'd' || cArray[6] != 'a' || cArray[7] != 'y') {
                            n3 = -7;
                            break block0;
                        }
                        n3 = 6;
                        break block0;
                    }
                    case 'u': {
                        if (cArray[2] != 'n' || cArray[3] != 'd' || cArray[4] != 'a' || cArray[5] != 'y') {
                            n3 = -8;
                            break block0;
                        }
                        n3 = 7;
                        break block0;
                    }
                }
                return ~(position + 1);
            }
            default: {
                return ~position;
            }
        }
        if (n3 < 0) {
            String string = DAYS[~n3 - 1];
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (cArray[i2] == string.charAt(i2)) continue;
                return ~(position + i2);
            }
            return ~position;
        }
        n2 = position + DAYS[n3 - 1].length();
        if (this.child != null) {
            n2 = this.child.parseInto(bucket, text, n2);
        } else if (this.ignoreSuffix) {
            n2 = text.length();
        }
        if (n2 >= 0) {
            bucket.saveField(DateTimeFieldType.dayOfWeek(), n3);
        }
        return n2;
    }
}

