/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumnFactory;
import ai.h2o.mojos.runtime.utils.ClassLoaderUtils;
import java.util.ArrayList;
import java.util.ServiceLoader;

final class MojoColumnFactoryService {
    private final MojoColumnFactory mojoColumnFactory;
    private final RuntimeException error;

    public static MojoColumnFactoryService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private MojoColumnFactoryService() {
        ServiceLoader<MojoColumnFactory> loader = ServiceLoader.load(MojoColumnFactory.class, ClassLoaderUtils.getPreferredSpiClassLoader(MojoColumnFactory.class));
        MojoColumnFactory[] factories = MojoColumnFactoryService.getAll(loader);
        if (factories.length == 0) {
            this.mojoColumnFactory = null;
            this.error = new RuntimeException("Cannot find MOJO column factory implementation! Check the classpath if it contains mojo2-runtime-impl!");
        } else if (factories.length > 1) {
            this.mojoColumnFactory = null;
            this.error = new RuntimeException("Found multiple MOJO column factories implementation backends, but expected only one! Check the classpath if it contains mojo2-runtime-impl!");
        } else {
            this.error = null;
            this.mojoColumnFactory = factories[0];
        }
    }

    public MojoColumnFactory getMojoColumnFactory() {
        if (this.mojoColumnFactory != null) {
            return this.mojoColumnFactory;
        }
        throw this.error;
    }

    private static MojoColumnFactory[] getAll(ServiceLoader<MojoColumnFactory> loader) {
        ArrayList<MojoColumnFactory> l2 = new ArrayList<MojoColumnFactory>();
        for (MojoColumnFactory mcf : loader) {
            l2.add(mcf);
        }
        return l2.toArray(new MojoColumnFactory[0]);
    }

    private static class InstanceHolder {
        private static MojoColumnFactoryService INSTANCE = new MojoColumnFactoryService();

        private InstanceHolder() {
        }
    }
}

