/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.frame.MojoFrame;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalMatrix {
    private static final Logger log = LoggerFactory.getLogger(OriginalMatrix.class);
    private final Map<String, OrigMatrixRow> rows = new LinkedHashMap<String, OrigMatrixRow>();

    public void add(String transName, String origName, double coef) {
        OrigMatrixRow origMatrixRow = this.rows.get(transName);
        if (origMatrixRow == null) {
            origMatrixRow = new OrigMatrixRow();
            this.rows.put(transName, origMatrixRow);
        }
        origMatrixRow.addValue(origName, coef);
    }

    void incrementOrigShap(MojoFrame globalFrame, int rowIndex, String columnName, double scaledContrib) {
        OrigMatrixRow origMatrixRow = this.rows.get(columnName);
        if (origMatrixRow != null) {
            origMatrixRow.incrementOrigShap(globalFrame, rowIndex, scaledContrib);
        }
    }

    public static class OrigMatrixRow {
        private final Map<String, Double> byOrigName = new LinkedHashMap<String, Double>();

        private void addValue(String origName, double coef) {
            this.byOrigName.put(origName, coef);
        }

        private void incrementOrigShap(MojoFrame globalFrame, int rowIndex, double scaledContrib) {
            for (Map.Entry<String, Double> entry : this.byOrigName.entrySet()) {
                String string = entry.getKey();
                Double d2 = entry.getValue();
                int n2 = globalFrame.getMeta().getColumnIndex(string);
                double[] dArray = (double[])globalFrame.getColumnData(n2);
                double[] dArray2 = dArray;
                int n3 = rowIndex;
                dArray[n3] = dArray[n3] + scaledContrib * d2;
            }
        }

        public String toString() {
            return this.byOrigName.toString();
        }
    }
}

