"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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