/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.codegen.cplan.CNode;
import org.tugraz.sysds.hops.codegen.cplan.CNodeMultiAgg;
import org.tugraz.sysds.hops.codegen.cplan.CNodeTpl;
import org.tugraz.sysds.hops.ipa.FunctionCallGraph;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.ForStatement;
import org.tugraz.sysds.parser.ForStatementBlock;
import org.tugraz.sysds.parser.FunctionStatement;
import org.tugraz.sysds.parser.FunctionStatementBlock;
import org.tugraz.sysds.parser.IfStatement;
import org.tugraz.sysds.parser.IfStatementBlock;
import org.tugraz.sysds.parser.ParForStatementBlock;
import org.tugraz.sysds.parser.StatementBlock;
import org.tugraz.sysds.parser.WhileStatement;
import org.tugraz.sysds.parser.WhileStatementBlock;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.IfProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ParForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.WhileProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.instructions.gpu.GPUInstruction;
import org.tugraz.sysds.runtime.instructions.spark.CSVReblockSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.CheckpointSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.ReblockSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.lineage.LineageItem;

public class Explain {
    private static final boolean REPLACE_SPECIAL_CHARACTERS = true;
    private static final boolean SHOW_MEM_ABOVE_BUDGET = true;
    private static final boolean SHOW_LITERAL_HOPS = false;
    private static final boolean SHOW_DATA_DEPENDENCIES = true;
    private static final boolean SHOW_DATA_FLOW_PROPERTIES = true;

    public static String display(DMLProgram prog, Program rtprog, ExplainType type, ExplainCounts counts) {
        if (counts == null) {
            counts = Explain.countDistributedOperations(rtprog);
        }
        return "# EXPLAIN (" + type.name() + "):\n" + Explain.explainMemoryBudget(counts) + "\n" + Explain.explainDegreeOfParallelism(counts) + Explain.explain(prog, rtprog, type, counts);
    }

    public static String explainMemoryBudget() {
        return Explain.explainMemoryBudget(new ExplainCounts());
    }

    public static String explainMemoryBudget(ExplainCounts counts) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Memory Budget local/remote = ");
        sb.append(OptimizerUtils.toMB(OptimizerUtils.getLocalMemBudget()));
        sb.append("MB/");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (counts.numJobs - counts.numReblocks - counts.numChkpts <= 0 || !SparkExecutionContext.isSparkContextCreated()) {
                sb.append("?MB/?MB/?MB");
            } else {
                sb.append(OptimizerUtils.toMB(SparkExecutionContext.getDataMemoryBudget(true, false)));
                sb.append("MB/");
                sb.append(OptimizerUtils.toMB(SparkExecutionContext.getDataMemoryBudget(false, false)));
                sb.append("MB/");
                sb.append(OptimizerUtils.toMB(SparkExecutionContext.getBroadcastMemoryBudget()));
                sb.append("MB");
            }
        } else {
            sb.append("?MB/?MB");
        }
        return sb.toString();
    }

    public static String explainDegreeOfParallelism() {
        return Explain.explainDegreeOfParallelism(new ExplainCounts());
    }

    public static String explainDegreeOfParallelism(ExplainCounts counts) {
        int lk = InfrastructureAnalyzer.getLocalParallelism();
        StringBuilder sb = new StringBuilder();
        sb.append("# Degree of Parallelism (vcores) local/remote = ");
        sb.append(lk);
        sb.append("/");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (counts.numJobs - counts.numReblocks - counts.numChkpts <= 0 || !SparkExecutionContext.isSparkContextCreated()) {
                sb.append("?");
            } else {
                sb.append(SparkExecutionContext.getDefaultParallelism(false));
            }
        }
        return sb.toString();
    }

    public static String explain(DMLProgram prog, Program rtprog, ExplainType type) {
        return Explain.explain(prog, rtprog, type, null);
    }

    public static String explain(DMLProgram prog, Program rtprog, ExplainType type, ExplainCounts counts) {
        switch (type) {
            case HOPS: 
            case RECOMPILE_HOPS: {
                return Explain.explain(prog);
            }
            case RUNTIME: 
            case RECOMPILE_RUNTIME: {
                return Explain.explain(rtprog, counts);
            }
        }
        return null;
    }

    public static String explain(DMLProgram prog) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nPROGRAM\n");
        if (prog.hasFunctionStatementBlocks()) {
            sb.append("--FUNCTIONS\n");
            sb.append("----FUNCTION CALL GRAPH\n");
            sb.append("------MAIN PROGRAM\n");
            FunctionCallGraph fgraph = new FunctionCallGraph(prog);
            sb.append(Explain.explainFunctionCallGraph(fgraph, new HashSet<String>(), null, 3));
            for (String namespace : prog.getNamespaces().keySet()) {
                for (String fname : prog.getFunctionStatementBlocks(namespace).keySet()) {
                    FunctionStatementBlock fsb = prog.getFunctionStatementBlock(namespace, fname);
                    FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                    String fkey = DMLProgram.constructFunctionKey(namespace, fname);
                    sb.append("----FUNCTION " + fkey + " [recompile=" + fsb.isRecompileOnce() + "]\n");
                    for (StatementBlock current : fstmt.getBody()) {
                        sb.append(Explain.explainStatementBlock(current, 3));
                    }
                }
            }
        }
        sb.append("--MAIN PROGRAM\n");
        for (StatementBlock sblk : prog.getStatementBlocks()) {
            sb.append(Explain.explainStatementBlock(sblk, 2));
        }
        return sb.toString();
    }

    public static String explain(Program rtprog) {
        return Explain.explain(rtprog, null);
    }

    public static String explain(Program rtprog, ExplainCounts counts) {
        boolean sparkExec = OptimizerUtils.isSparkExecutionMode();
        if (counts == null) {
            counts = new ExplainCounts();
            Explain.countCompiledInstructions(rtprog, counts, true, sparkExec);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\nPROGRAM ( size CP/" + (sparkExec ? "SP" : "MR") + " = ");
        sb.append(counts.numCPInst);
        sb.append("/");
        sb.append(counts.numJobs);
        sb.append(" )\n");
        HashMap<String, FunctionProgramBlock> funcMap = rtprog.getFunctionProgramBlocks();
        if (funcMap != null && !funcMap.isEmpty()) {
            sb.append("--FUNCTIONS\n");
            if (!rtprog.getProgramBlocks().isEmpty() && rtprog.getProgramBlocks().get(0).getStatementBlock() != null) {
                sb.append("----FUNCTION CALL GRAPH\n");
                sb.append("------MAIN PROGRAM\n");
                DMLProgram prog = rtprog.getProgramBlocks().get(0).getStatementBlock().getDMLProg();
                FunctionCallGraph functionCallGraph = new FunctionCallGraph(prog);
                sb.append(Explain.explainFunctionCallGraph(functionCallGraph, new HashSet<String>(), null, 3));
            }
            for (Map.Entry entry : funcMap.entrySet()) {
                String fkey = (String)entry.getKey();
                FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                sb.append("----FUNCTION " + fkey + " [recompile=" + fpb.isRecompileOnce() + "]\n");
                for (ProgramBlock pb : fpb.getChildBlocks()) {
                    sb.append(Explain.explainProgramBlock(pb, 3));
                }
            }
        }
        sb.append("--MAIN PROGRAM\n");
        for (ProgramBlock programBlock : rtprog.getProgramBlocks()) {
            sb.append(Explain.explainProgramBlock(programBlock, 2));
        }
        return sb.toString();
    }

    public static String explain(ProgramBlock pb) {
        return Explain.explainProgramBlock(pb, 0);
    }

    public static String explain(ArrayList<Instruction> inst) {
        return Explain.explainInstructions(inst, 0);
    }

    public static String explain(ArrayList<Instruction> inst, int level) {
        return Explain.explainInstructions(inst, level);
    }

    public static String explain(Instruction inst) {
        return Explain.explainGenericInstruction(inst, 0);
    }

    public static String explain(StatementBlock sb) {
        return Explain.explainStatementBlock(sb, 0);
    }

    public static String explainHops(ArrayList<Hop> hops) {
        return Explain.explainHops(hops, 0);
    }

    public static String explainHops(ArrayList<Hop> hops, int level) {
        StringBuilder sb = new StringBuilder();
        Hop.resetVisitStatus(hops);
        for (Hop hop : hops) {
            sb.append(Explain.explainHop(hop, level));
        }
        Hop.resetVisitStatus(hops);
        return sb.toString();
    }

    public static String explain(Hop hop) {
        return Explain.explain(hop, 0);
    }

    public static String explain(Hop hop, int level) {
        hop.resetVisitStatus();
        String ret = Explain.explainHop(hop, level);
        hop.resetVisitStatus();
        return ret;
    }

    public static String explainLineageItems(LineageItem[] lis) {
        return Explain.explainLineageItems(lis, 0);
    }

    public static String explainLineageItems(LineageItem[] lis, int level) {
        StringBuilder sb = new StringBuilder();
        LineageItem.resetVisitStatus(lis);
        for (LineageItem li : lis) {
            sb.append(Explain.explainLineageItem(li, level));
        }
        LineageItem.resetVisitStatus(lis);
        return sb.toString();
    }

    public static String explain(LineageItem li) {
        li.resetVisitStatus();
        String s = Explain.explain(li, 0);
        s = s + Explain.rExplainDedupItems(li, new ArrayList<String>());
        li.resetVisitStatus();
        return s;
    }

    private static String explain(LineageItem li, int level) {
        li.resetVisitStatus();
        String ret = Explain.explainLineageItem(li, level);
        li.resetVisitStatus();
        return ret;
    }

    private static String rExplainDedupItems(LineageItem li, List<String> paths) {
        if (li.isVisited()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (li.getType() == LineageItem.LineageItemType.Dedup && !paths.contains(li.getData())) {
            sb.append("\n").append("dedup").append(li.getData()).append(":\n");
            sb.append(Explain.explain(li, 0));
            paths.add(li.getData());
        }
        if (li.getInputs() != null) {
            for (LineageItem in : li.getInputs()) {
                sb.append(Explain.rExplainDedupItems(in, paths));
            }
        }
        li.setVisited();
        return sb.toString();
    }

    public static String explainCPlan(CNodeTpl cplan) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n----------------------------------------\n");
        sb.append("CPLAN: " + cplan.getTemplateInfo() + "\n");
        sb.append("--inputs: " + Arrays.toString(cplan.getInputNames()) + "\n");
        sb.append("----------------------------------------\n");
        cplan.resetVisitStatusOutputs();
        if (cplan instanceof CNodeMultiAgg) {
            for (CNode output : ((CNodeMultiAgg)cplan).getOutputs()) {
                sb.append(Explain.explainCNode(output, 1));
            }
        } else {
            sb.append(Explain.explainCNode(cplan.getOutput(), 1));
        }
        cplan.resetVisitStatusOutputs();
        sb.append("----------------------------------------\n");
        return sb.toString();
    }

    public static String explain(CNode node) {
        return Explain.explain(node, 0);
    }

    public static String explain(CNode node, int level) {
        return Explain.explainCNode(node, level);
    }

    public static ExplainCounts countDistributedOperations(Program rtprog) {
        ExplainCounts counts = new ExplainCounts();
        Explain.countCompiledInstructions(rtprog, counts, true, true);
        return counts;
    }

    public static String getIdentation(int level) {
        return Explain.createOffset(level);
    }

    private static String explainStatementBlock(StatementBlock sb, int level) {
        StringBuilder builder = new StringBuilder();
        String offset = Explain.createOffset(level);
        if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            builder.append(offset);
            if (!wsb.getUpdateInPlaceVars().isEmpty()) {
                builder.append("WHILE (lines " + wsb.getBeginLine() + "-" + wsb.getEndLine() + ") [in-place=" + wsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                builder.append("WHILE (lines " + wsb.getBeginLine() + "-" + wsb.getEndLine() + ")\n");
            }
            builder.append(Explain.explainHop(wsb.getPredicateHops(), level + 1));
            WhileStatement ws = (WhileStatement)sb.getStatement(0);
            for (StatementBlock current : ws.getBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock ifsb = (IfStatementBlock)sb;
            builder.append(offset);
            builder.append("IF (lines " + ifsb.getBeginLine() + "-" + ifsb.getEndLine() + ")\n");
            builder.append(Explain.explainHop(ifsb.getPredicateHops(), level + 1));
            IfStatement ifs = (IfStatement)sb.getStatement(0);
            for (StatementBlock current : ifs.getIfBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
            if (!ifs.getElseBody().isEmpty()) {
                builder.append(offset);
                builder.append("ELSE\n");
            }
            for (StatementBlock current : ifs.getElseBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            builder.append(offset);
            if (sb instanceof ParForStatementBlock) {
                if (!fsb.getUpdateInPlaceVars().isEmpty()) {
                    builder.append("PARFOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ") [in-place=" + fsb.getUpdateInPlaceVars().toString() + "]\n");
                } else {
                    builder.append("PARFOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")\n");
                }
            } else if (!fsb.getUpdateInPlaceVars().isEmpty()) {
                builder.append("FOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ") [in-place=" + fsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                builder.append("FOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")\n");
            }
            if (fsb.getFromHops() != null) {
                builder.append(Explain.explainHop(fsb.getFromHops(), level + 1));
            }
            if (fsb.getToHops() != null) {
                builder.append(Explain.explainHop(fsb.getToHops(), level + 1));
            }
            if (fsb.getIncrementHops() != null) {
                builder.append(Explain.explainHop(fsb.getIncrementHops(), level + 1));
            }
            ForStatement fs = (ForStatement)sb.getStatement(0);
            for (StatementBlock current : fs.getBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatement fsb = (FunctionStatement)sb.getStatement(0);
            for (StatementBlock current : fsb.getBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else {
            builder.append(offset);
            builder.append("GENERIC (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + ") [recompile=" + sb.requiresRecompilation() + "]\n");
            ArrayList<Hop> hopsDAG = sb.getHops();
            if (hopsDAG != null && !hopsDAG.isEmpty()) {
                Hop.resetVisitStatus(hopsDAG);
                for (Hop hop : hopsDAG) {
                    builder.append(Explain.explainHop(hop, level + 1));
                }
                Hop.resetVisitStatus(hopsDAG);
            }
        }
        return builder.toString();
    }

    private static String explainHop(Hop hop, int level) {
        if (hop.isVisited() || hop instanceof LiteralOp) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        for (Hop input : hop.getInput()) {
            sb.append(Explain.explainHop(input, level));
        }
        sb.append(offset);
        sb.append("(" + hop.getHopID() + ") ");
        sb.append(hop.getOpString());
        StringBuilder childs = new StringBuilder();
        childs.append(" (");
        boolean childAdded = false;
        for (Hop input : hop.getInput()) {
            if (input instanceof LiteralOp) continue;
            childs.append(childAdded ? "," : "");
            childs.append(input.getHopID());
            childAdded = true;
        }
        childs.append(")");
        if (childAdded) {
            sb.append(childs.toString());
        }
        sb.append(" [" + hop.getDim1() + "," + hop.getDim2() + "," + hop.getBlocksize() + "," + hop.getNnz());
        if (hop.getUpdateType().isInPlace()) {
            sb.append("," + hop.getUpdateType().toString().toLowerCase());
        }
        sb.append("]");
        sb.append(" [" + Explain.showMem(hop.getInputMemEstimate(), false) + "," + Explain.showMem(hop.getIntermediateMemEstimate(), false) + "," + Explain.showMem(hop.getOutputMemEstimate(), false) + " -> " + Explain.showMem(hop.getMemEstimate(), true) + "]");
        if (hop.requiresReblock() && hop.requiresCheckpoint()) {
            sb.append(" [rblk,chkpt]");
        } else if (hop.requiresReblock()) {
            sb.append(" [rblk]");
        } else if (hop.requiresCheckpoint()) {
            sb.append(" [chkpt]");
        }
        if (hop.getExecType() != null) {
            sb.append(", " + (Object)((Object)hop.getExecType()));
        }
        sb.append('\n');
        hop.setVisited();
        return sb.toString();
    }

    private static String explainLineageItem(LineageItem li, int level) {
        if (li.isVisited()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        if (li.getInputs() != null) {
            for (LineageItem input : li.getInputs()) {
                sb.append(Explain.explainLineageItem(input, level));
            }
        }
        sb.append(offset);
        sb.append(li.toString());
        sb.append('\n');
        li.setVisited();
        return sb.toString();
    }

    private static String explainCNode(CNode cnode, int level) {
        if (cnode.isVisited()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        for (CNode input : cnode.getInput()) {
            sb.append(Explain.explainCNode(input, level));
        }
        sb.append(offset);
        sb.append("(" + cnode.getID() + ") ");
        sb.append(cnode.toString());
        StringBuilder childs = new StringBuilder();
        childs.append(" (");
        boolean childAdded = false;
        for (CNode input : cnode.getInput()) {
            childs.append(childAdded ? "," : "");
            childs.append(input.getID());
            childAdded = true;
        }
        childs.append(")");
        if (childAdded) {
            sb.append(childs.toString());
        }
        sb.append('\n');
        cnode.setVisited();
        return sb.toString();
    }

    private static String explainProgramBlock(ProgramBlock pb, int level) {
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
        } else if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            StatementBlock wsb = pb.getStatementBlock();
            sb.append(offset);
            if (wsb != null && !wsb.getUpdateInPlaceVars().isEmpty()) {
                sb.append("WHILE (lines " + wpb.getBeginLine() + "-" + wpb.getEndLine() + ") [in-place=" + wsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                sb.append("WHILE (lines " + wpb.getBeginLine() + "-" + wpb.getEndLine() + ")\n");
            }
            sb.append(Explain.explainInstructions(wpb.getPredicate(), level + 1));
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            sb.append(offset);
            sb.append("IF (lines " + ipb.getBeginLine() + "-" + ipb.getEndLine() + ")\n");
            sb.append(Explain.explainInstructions(ipb.getPredicate(), level + 1));
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
            if (!ipb.getChildBlocksElseBody().isEmpty()) {
                sb.append(offset);
                sb.append("ELSE\n");
                for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                    sb.append(Explain.explainProgramBlock(pbc, level + 1));
                }
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            StatementBlock fsb = pb.getStatementBlock();
            sb.append(offset);
            if (pb instanceof ParForProgramBlock) {
                sb.append("PARFOR (lines " + fpb.getBeginLine() + "-" + fpb.getEndLine() + ")\n");
            } else if (fsb != null && !fsb.getUpdateInPlaceVars().isEmpty()) {
                sb.append("FOR (lines " + fpb.getBeginLine() + "-" + fpb.getEndLine() + ") [in-place=" + fsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                sb.append("FOR (lines " + fpb.getBeginLine() + "-" + fpb.getEndLine() + ")\n");
            }
            sb.append(Explain.explainInstructions(fpb.getFromInstructions(), level + 1));
            sb.append(Explain.explainInstructions(fpb.getToInstructions(), level + 1));
            sb.append(Explain.explainInstructions(fpb.getIncrementInstructions(), level + 1));
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
        } else if (pb instanceof BasicProgramBlock) {
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            sb.append(offset);
            if (pb.getStatementBlock() != null) {
                sb.append("GENERIC (lines " + pb.getBeginLine() + "-" + pb.getEndLine() + ") [recompile=" + pb.getStatementBlock().requiresRecompilation() + "]\n");
            } else {
                sb.append("GENERIC (lines " + pb.getBeginLine() + "-" + pb.getEndLine() + ") \n");
            }
            sb.append(Explain.explainInstructions(bpb.getInstructions(), level + 1));
        }
        return sb.toString();
    }

    private static String explainInstructions(ArrayList<Instruction> instSet, int level) {
        StringBuilder sb = new StringBuilder();
        String offsetInst = Explain.createOffset(level);
        for (Instruction inst : instSet) {
            String tmp = Explain.explainGenericInstruction(inst, level);
            sb.append(offsetInst);
            sb.append(tmp);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String explainGenericInstruction(Instruction inst, int level) {
        String tmp = null;
        if (inst instanceof SPInstruction || inst instanceof CPInstruction || inst instanceof GPUInstruction || inst instanceof FEDInstruction) {
            tmp = inst.toString();
        }
        tmp = tmp.replaceAll("\u00b0", " ");
        tmp = tmp.replaceAll("\u00b7", ".");
        tmp = tmp.replaceAll("\u2021", ", ");
        return tmp;
    }

    private static String showMem(double mem, boolean units) {
        return OptimizerUtils.toMB(mem) + (units ? "MB" : "");
    }

    private static String createOffset(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("--");
        }
        return sb.toString();
    }

    private static void countCompiledInstructions(Program rtprog, ExplainCounts counts, boolean CP, boolean SP) {
        for (FunctionProgramBlock fpb : rtprog.getFunctionProgramBlocks().values()) {
            Explain.countCompiledInstructions(fpb, counts, CP, SP);
        }
        for (ProgramBlock pb : rtprog.getProgramBlocks()) {
            Explain.countCompiledInstructions(pb, counts, CP, SP);
        }
    }

    private static void countCompiledInstructions(ProgramBlock pb, ExplainCounts counts, boolean CP, boolean SP) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock tmp = (WhileProgramBlock)pb;
            Explain.countCompiledInstructions(tmp.getPredicate(), counts, CP, SP);
            for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                Explain.countCompiledInstructions(pb2, counts, CP, SP);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock tmp = (IfProgramBlock)pb;
            Explain.countCompiledInstructions(tmp.getPredicate(), counts, CP, SP);
            for (ProgramBlock pb2 : tmp.getChildBlocksIfBody()) {
                Explain.countCompiledInstructions(pb2, counts, CP, SP);
            }
            for (ProgramBlock pb2 : tmp.getChildBlocksElseBody()) {
                Explain.countCompiledInstructions(pb2, counts, CP, SP);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock tmp = (ForProgramBlock)pb;
            Explain.countCompiledInstructions(tmp.getFromInstructions(), counts, CP, SP);
            Explain.countCompiledInstructions(tmp.getToInstructions(), counts, CP, SP);
            Explain.countCompiledInstructions(tmp.getIncrementInstructions(), counts, CP, SP);
            for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                Explain.countCompiledInstructions(pb2, counts, CP, SP);
            }
        } else if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            for (ProgramBlock pb2 : fpb.getChildBlocks()) {
                Explain.countCompiledInstructions(pb2, counts, CP, SP);
            }
        } else if (pb instanceof BasicProgramBlock) {
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            Explain.countCompiledInstructions(bpb.getInstructions(), counts, CP, SP);
        }
    }

    private static void countCompiledInstructions(ArrayList<Instruction> instSet, ExplainCounts counts, boolean CP, boolean SP) {
        for (Instruction inst : instSet) {
            if (CP && inst instanceof CPInstruction) {
                ++counts.numCPInst;
            } else if (SP && inst instanceof SPInstruction) {
                ++counts.numJobs;
            }
            if (SP && (inst instanceof CSVReblockSPInstruction || inst instanceof ReblockSPInstruction)) {
                ++counts.numReblocks;
            }
            if (!SP || !(inst instanceof CheckpointSPInstruction)) continue;
            ++counts.numChkpts;
        }
    }

    private static String explainFunctionCallGraph(FunctionCallGraph fgraph, HashSet<String> fstack, String fkey, int level) {
        StringBuilder builder = new StringBuilder();
        String offset = Explain.createOffset(level);
        Set<String> cfkeys = fgraph.getCalledFunctions(fkey);
        if (cfkeys != null) {
            for (String cfkey : cfkeys) {
                if (fstack.contains(cfkey) && fgraph.isRecursiveFunction(cfkey)) {
                    builder.append(offset + "--" + cfkey + " (recursive)\n");
                    continue;
                }
                fstack.add(cfkey);
                builder.append(offset + "--" + cfkey + "\n");
                builder.append(Explain.explainFunctionCallGraph(fgraph, fstack, cfkey, level + 1));
                fstack.remove(cfkey);
            }
        }
        return builder.toString();
    }

    public static class ExplainCounts {
        public int numCPInst = 0;
        public int numJobs = 0;
        public int numReblocks = 0;
        public int numChkpts = 0;
    }

    public static enum ExplainType {
        NONE,
        HOPS,
        RUNTIME,
        RECOMPILE_HOPS,
        RECOMPILE_RUNTIME;


        public boolean isHopsType(boolean recompile) {
            return this == RECOMPILE_HOPS || !recompile && this == HOPS;
        }

        public boolean isRuntimeType(boolean recompile) {
            return this == RECOMPILE_RUNTIME || !recompile && this == RUNTIME;
        }
    }
}

