/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.data.TensorIndexes;
import org.tugraz.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.Pair;
import org.tugraz.sysds.runtime.meta.TensorCharacteristics;
import org.tugraz.sysds.runtime.util.IndexRange;

public class UtilFunctions {
    public static final double DOUBLE_EPS = Math.pow(2.0, -53.0);
    public static final long ADD_PRIME1 = 99991L;
    public static final int DIVIDE_PRIME = 1405695061;

    public static int intHashCode(int key1, int key2) {
        return 31 * (31 + key1) + key2;
    }

    public static int longHashCode(long key1) {
        return (int)(key1 ^ key1 >>> 32);
    }

    public static int longHashCode(long key1, long key2) {
        int h = 31 + (int)(key1 ^ key1 >>> 32);
        return h * 31 + (int)(key2 ^ key2 >>> 32);
    }

    public static int longHashCode(long key1, long key2, long key3) {
        int h1 = 31 + (int)(key1 ^ key1 >>> 32);
        int h2 = h1 * 31 + (int)(key2 ^ key2 >>> 32);
        return h2 * 31 + (int)(key3 ^ key3 >>> 32);
    }

    public static int nextIntPow2(int in) {
        int expon = in == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(in - 1);
        long pow2 = UtilFunctions.pow(2, expon);
        return (int)(pow2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : pow2);
    }

    public static long pow(int base, int exp) {
        return base == 2 && 0 <= exp && exp < 63 ? 1L << exp : (long)Math.pow(base, exp);
    }

    public static long computeBlockIndex(long cellIndex, int blockSize) {
        return (cellIndex - 1L) / (long)blockSize + 1L;
    }

    public static int computeCellInBlock(long cellIndex, int blockSize) {
        return (int)((cellIndex - 1L) % (long)blockSize);
    }

    public static long computeCellIndex(long blockIndex, int blockSize, int cellInBlock) {
        return (blockIndex - 1L) * (long)blockSize + 1L + (long)cellInBlock;
    }

    public static int computeBlockSize(long len, long blockIndex, long blockSize) {
        long remain = len - (blockIndex - 1L) * blockSize;
        return (int)Math.min(blockSize, remain);
    }

    public static long[] computeNextTensorIndexes(TensorCharacteristics tc, long[] ix) {
        int n = tc.getNumDims() - 1;
        ix[n] = ix[n] + 1L;
        for (int i = tc.getNumDims() - 1; i > 0 && ix[i] == tc.getNumBlocks(i) + 1L; --i) {
            ix[i] = 1L;
            int n2 = i - 1;
            ix[n2] = ix[n2] + 1L;
        }
        return ix;
    }

    public static long[] computeTensorIndexes(TensorCharacteristics tc, long blockIndex) {
        long[] ix = new long[tc.getNumDims()];
        for (int j = tc.getNumDims() - 1; j >= 0; --j) {
            ix[j] = 1L + blockIndex % tc.getNumBlocks(j);
            blockIndex /= tc.getNumBlocks(j);
        }
        return ix;
    }

    public static void computeSliceInfo(TensorCharacteristics tc, long[] blockIx, int[] outDims, int[] offset) {
        for (int i = tc.getNumDims() - 1; i >= 0; --i) {
            outDims[i] = UtilFunctions.computeBlockSize(tc.getDim(i), blockIx[i], tc.getBlocksize());
            offset[i] = (int)((blockIx[i] - 1L) * (long)tc.getBlocksize());
        }
    }

    public static long computeBlockNumber(int[] ix, long[] dims, int blen) {
        long pos = ix[ix.length - 1] - 1;
        for (int i = ix.length - 2; i >= 0; --i) {
            pos = (long)((double)pos + (double)(ix[i] - 1) * Math.ceil((double)dims[i + 1] / (double)blen));
        }
        return pos;
    }

    public static ArrayList<Integer> getBalancedBlockSizesDefault(int len, int k, boolean constK) {
        int nk = constK ? k : UtilFunctions.roundToNext(Math.min(8 * k, len / 32), k);
        return UtilFunctions.getBalancedBlockSizes(len, nk);
    }

    public static ArrayList<Integer> getAlignedBlockSizes(int len, int k, int align) {
        int blklen;
        ArrayList<Integer> ret = new ArrayList<Integer>(len / (blklen += (blklen = (int)Math.ceil((double)len / (double)k)) % align != 0 ? align - blklen % align : 0));
        for (int i = 0; i < len; i += blklen) {
            ret.add(Math.min(blklen, len - i));
        }
        return ret;
    }

    private static ArrayList<Integer> getBalancedBlockSizes(int len, int k) {
        ArrayList<Integer> ret = new ArrayList<Integer>(k);
        int base = len / k;
        int rest = len % k;
        for (int i = 0; i < k; ++i) {
            int val = base + (i < rest ? 1 : 0);
            if (val <= 0) continue;
            ret.add(val);
        }
        return ret;
    }

    public static boolean isInBlockRange(MatrixIndexes ix, int blen, long rl, long ru, long cl, long cu) {
        long bRLowerIndex = (ix.getRowIndex() - 1L) * (long)blen + 1L;
        long bRUpperIndex = ix.getRowIndex() * (long)blen;
        long bCLowerIndex = (ix.getColumnIndex() - 1L) * (long)blen + 1L;
        long bCUpperIndex = ix.getColumnIndex() * (long)blen;
        if (rl > bRUpperIndex || ru < bRLowerIndex) {
            return false;
        }
        return cl <= bCUpperIndex && cu >= bCLowerIndex;
    }

    public static boolean isInFrameBlockRange(Long ix, int blen, long rl, long ru) {
        return rl <= ix + (long)blen - 1L && ru >= ix;
    }

    public static boolean isInBlockRange(MatrixIndexes ix, int blen, IndexRange ixrange) {
        return UtilFunctions.isInBlockRange(ix, blen, ixrange.rowStart, ixrange.rowEnd, ixrange.colStart, ixrange.colEnd);
    }

    public static boolean isInFrameBlockRange(Long ix, int blen, IndexRange ixrange) {
        return UtilFunctions.isInFrameBlockRange(ix, blen, ixrange.rowStart, ixrange.rowEnd);
    }

    public static IndexRange getSelectedRangeForZeroOut(IndexedMatrixValue in, int blen, IndexRange indexRange) {
        IndexRange tempRange = new IndexRange(-1L, -1L, -1L, -1L);
        long topBlockRowIndex = UtilFunctions.computeBlockIndex(indexRange.rowStart, blen);
        int topRowInTopBlock = UtilFunctions.computeCellInBlock(indexRange.rowStart, blen);
        long bottomBlockRowIndex = UtilFunctions.computeBlockIndex(indexRange.rowEnd, blen);
        int bottomRowInBottomBlock = UtilFunctions.computeCellInBlock(indexRange.rowEnd, blen);
        long leftBlockColIndex = UtilFunctions.computeBlockIndex(indexRange.colStart, blen);
        int leftColInLeftBlock = UtilFunctions.computeCellInBlock(indexRange.colStart, blen);
        long rightBlockColIndex = UtilFunctions.computeBlockIndex(indexRange.colEnd, blen);
        int rightColInRightBlock = UtilFunctions.computeCellInBlock(indexRange.colEnd, blen);
        if (in.getIndexes().getRowIndex() < topBlockRowIndex || in.getIndexes().getRowIndex() > bottomBlockRowIndex || in.getIndexes().getColumnIndex() < leftBlockColIndex || in.getIndexes().getColumnIndex() > rightBlockColIndex) {
            tempRange.set(-1L, -1L, -1L, -1L);
            return tempRange;
        }
        tempRange.set(0L, in.getValue().getNumRows() - 1, 0L, in.getValue().getNumColumns() - 1);
        if (topBlockRowIndex == in.getIndexes().getRowIndex()) {
            tempRange.rowStart = topRowInTopBlock;
        }
        if (bottomBlockRowIndex == in.getIndexes().getRowIndex()) {
            tempRange.rowEnd = bottomRowInBottomBlock;
        }
        if (leftBlockColIndex == in.getIndexes().getColumnIndex()) {
            tempRange.colStart = leftColInLeftBlock;
        }
        if (rightBlockColIndex == in.getIndexes().getColumnIndex()) {
            tempRange.colEnd = rightColInRightBlock;
        }
        return tempRange;
    }

    public static IndexRange getSelectedRangeForZeroOut(Pair<Long, FrameBlock> in, int blen, IndexRange indexRange, long lSrcRowIndex, long lDestRowIndex) {
        int iRowStart = indexRange.rowStart <= lDestRowIndex ? 0 : (int)(indexRange.rowStart - in.getKey());
        int iRowEnd = (int)Math.min(indexRange.rowEnd - lSrcRowIndex, (long)blen) - 1;
        int iColStart = UtilFunctions.computeCellInBlock(indexRange.colStart, blen);
        int iColEnd = UtilFunctions.computeCellInBlock(indexRange.colEnd, blen);
        return new IndexRange(iRowStart, iRowEnd, iColStart, iColEnd);
    }

    public static double parseToDouble(String str) {
        return "NA".equals(str) ? Double.NaN : Double.parseDouble(str);
    }

    public static int parseToInt(String str) {
        int ret = -1;
        ret = str.contains(".") ? UtilFunctions.toInt(Double.parseDouble(str)) : Integer.parseInt(str);
        return ret;
    }

    public static long parseToLong(String str) {
        long ret = -1L;
        ret = str.contains(".") ? UtilFunctions.toLong(Double.parseDouble(str)) : Long.parseLong(str);
        return ret;
    }

    public static int toInt(double val) {
        return (int)(Math.signum(val) * Math.floor(Math.abs(val) + DOUBLE_EPS));
    }

    public static long toLong(double val) {
        return (long)(Math.signum(val) * Math.floor(Math.abs(val) + DOUBLE_EPS));
    }

    public static int toInt(Object obj) {
        return obj instanceof Long ? ((Long)obj).intValue() : ((Integer)obj).intValue();
    }

    public static long getSeqLength(double from, double to, double incr) {
        return UtilFunctions.getSeqLength(from, to, incr, true);
    }

    public static long getSeqLength(double from, double to, double incr, boolean check) {
        if (check && (Double.isNaN(from) || Double.isNaN(to) || Double.isNaN(incr) || from > to && incr > 0.0 || from < to && incr < 0.0)) {
            throw new RuntimeException("Invalid seq parameters: (" + from + ", " + to + ", " + incr + ")");
        }
        return 1L + (long)Math.floor(to / incr - from / incr);
    }

    public static List<Integer> getSeqList(int low, int up, int incr) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = low; i <= up; i += incr) {
            ret.add(i);
        }
        return ret;
    }

    public static int[] getSeqArray(int low, int up, int incr) {
        int len = (int)UtilFunctions.getSeqLength(low, up, incr);
        int[] ret = new int[len];
        int i = 0;
        int val = low;
        while (i < len) {
            ret[i] = val;
            ++i;
            val += incr;
        }
        return ret;
    }

    public static int roundToNext(int val, int factor) {
        int pval = Math.max(val, factor);
        return (pval + factor - 1) / factor * factor;
    }

    public static Object doubleToObject(Types.ValueType vt, double in) {
        return UtilFunctions.doubleToObject(vt, in, true);
    }

    public static Object doubleToObject(Types.ValueType vt, double in, boolean sparse) {
        if (in == 0.0 && sparse) {
            return null;
        }
        switch (vt) {
            case STRING: {
                return String.valueOf(in);
            }
            case BOOLEAN: {
                return in != 0.0;
            }
            case INT32: {
                return UtilFunctions.toInt(in);
            }
            case INT64: {
                return UtilFunctions.toLong(in);
            }
            case FP32: {
                return Float.valueOf((float)in);
            }
            case FP64: {
                return in;
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static Object stringToObject(Types.ValueType vt, String in) {
        if (in == null) {
            return null;
        }
        switch (vt) {
            case STRING: {
                return in;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(in);
            }
            case INT32: {
                return Integer.parseInt(in);
            }
            case INT64: {
                return Long.parseLong(in);
            }
            case FP64: {
                return Double.parseDouble(in);
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static double objectToDouble(Types.ValueType vt, Object in) {
        if (in == null) {
            return 0.0;
        }
        switch (vt) {
            case FP64: {
                return (Double)in;
            }
            case FP32: {
                return ((Float)in).floatValue();
            }
            case INT64: {
                return ((Long)in).longValue();
            }
            case INT32: {
                return ((Integer)in).intValue();
            }
            case BOOLEAN: {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            case STRING: {
                return !((String)in).isEmpty() ? Double.parseDouble((String)in) : 0.0;
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static String objectToString(Object in) {
        return in != null ? in.toString() : null;
    }

    public static String objectToString(Object in, boolean ignoreNull) {
        String strReturn = UtilFunctions.objectToString(in);
        if (strReturn == null) {
            return strReturn;
        }
        if (ignoreNull) {
            if (in instanceof Double && (Double)in == 0.0) {
                return null;
            }
            if (in instanceof Long && (Long)in == 0L) {
                return null;
            }
            if (in instanceof Long && (Integer)in == 0) {
                return null;
            }
            if (in instanceof Boolean && !((Boolean)in).booleanValue()) {
                return null;
            }
            if (in instanceof String && ((String)in).trim().length() == 0) {
                return null;
            }
            return strReturn;
        }
        return strReturn;
    }

    public static Object objectToObject(Types.ValueType vt, Object in) {
        if (in instanceof Double && vt == Types.ValueType.FP64 || in instanceof Long && vt == Types.ValueType.INT64 || in instanceof Integer && vt == Types.ValueType.INT32 || in instanceof Boolean && vt == Types.ValueType.BOOLEAN || in instanceof String && vt == Types.ValueType.STRING) {
            return in;
        }
        return UtilFunctions.stringToObject(vt, UtilFunctions.objectToString(in));
    }

    public static Object objectToObject(Types.ValueType vt, Object in, boolean ignoreNull) {
        String str = UtilFunctions.objectToString(in, ignoreNull);
        if (str == null || vt == Types.ValueType.STRING) {
            return str;
        }
        return UtilFunctions.stringToObject(vt, str);
    }

    public static int compareTo(Types.ValueType vt, Object in1, Object in2) {
        if (in1 == null && in2 == null) {
            return 0;
        }
        if (in1 == null) {
            return -1;
        }
        if (in2 == null) {
            return 1;
        }
        switch (vt) {
            case STRING: {
                return ((String)in1).compareTo((String)in2);
            }
            case BOOLEAN: {
                return ((Boolean)in1).compareTo((Boolean)in2);
            }
            case INT64: {
                return ((Long)in1).compareTo((Long)in2);
            }
            case INT32: {
                return ((Integer)in1).compareTo((Integer)in2);
            }
            case FP64: {
                return ((Double)in1).compareTo((Double)in2);
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static int compareVersion(String version1, String version2) {
        String[] partsv1 = version1.split("\\.");
        String[] partsv2 = version2.split("\\.");
        int len = Math.min(partsv1.length, partsv2.length);
        for (int i = 0; i < partsv1.length && i < len; ++i) {
            Integer iv2;
            Integer iv1 = Integer.parseInt(partsv1[i]);
            if (iv1.compareTo(iv2 = Integer.valueOf(Integer.parseInt(partsv2[i]))) == 0) continue;
            return iv1.compareTo(iv2);
        }
        return 0;
    }

    public static boolean isIntegerNumber(String str) {
        byte[] c = str.getBytes();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= 48 && c[i] <= 57) continue;
            return false;
        }
        return true;
    }

    public static int[] getSortedSampleIndexes(int range, int sampleSize) {
        return UtilFunctions.getSortedSampleIndexes(range, sampleSize, -1L);
    }

    public static int[] getSortedSampleIndexes(int range, int sampleSize, long seed) {
        RandomDataGenerator rng = new RandomDataGenerator();
        if (seed != -1L) {
            rng.reSeed(seed);
        }
        int[] sample = rng.nextPermutation(range, sampleSize);
        Arrays.sort(sample);
        return sample;
    }

    public static byte max(byte[] array) {
        byte ret = -128;
        for (int i = 0; i < array.length; ++i) {
            ret = array[i] > ret ? array[i] : ret;
        }
        return ret;
    }

    public static String unquote(String s) {
        if (s != null && s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static long parseMemorySize(String arg) {
        if (arg.endsWith("g") || arg.endsWith("G")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L * 1024L;
        }
        if (arg.endsWith("m") || arg.endsWith("M")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L;
        }
        if (arg.endsWith("k") || arg.endsWith("K")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L;
        }
        return Long.parseLong(arg.substring(0, arg.length()));
    }

    public static String formatMemorySize(long arg) {
        if (arg >= 0x40000000L) {
            return String.format("%d GB", arg / 0x40000000L);
        }
        if (arg >= 0x100000L) {
            return String.format("%d MB", arg / 0x100000L);
        }
        if (arg >= 1024L) {
            return String.format("%d KB", arg / 1024L);
        }
        return String.format("%d", arg);
    }

    public static double getDouble(Object obj) {
        return obj instanceof Double ? (Double)obj : Double.parseDouble(obj.toString());
    }

    public static boolean isNonZero(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj != 0.0;
        }
        String sobj = obj.toString();
        return !sobj.equals("0") && !sobj.equals("0.0");
    }

    public static int computeNnz(double[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0.0 ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(float[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0.0f ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(long[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0L ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(int[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0 ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(BitSet a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a.get(i) ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(String[] a, int ai, int len) {
        int lnnz = 0;
        for (int k = ai; k < ai + len; ++k) {
            lnnz += a[k] != null && !a[k].isEmpty() && Double.parseDouble(a[k]) != 0.0 ? 1 : 0;
        }
        return lnnz;
    }

    public static long computeNnz(SparseBlock a, int[] aix, int ai, int alen) {
        long lnnz = 0L;
        for (int k = ai; k < ai + alen; ++k) {
            lnnz += (long)a.size(aix[k]);
        }
        return lnnz;
    }

    public static Types.ValueType[] nCopies(int n, Types.ValueType vt) {
        Types.ValueType[] ret = new Types.ValueType[n];
        Arrays.fill((Object[])ret, (Object)vt);
        return ret;
    }

    public static int frequency(Types.ValueType[] schema, Types.ValueType vt) {
        int count = 0;
        for (Types.ValueType tmp : schema) {
            count += tmp.equals((Object)vt) ? 1 : 0;
        }
        return count;
    }

    public static Types.ValueType[] copyOf(Types.ValueType[] schema1, Types.ValueType[] schema2) {
        return (Types.ValueType[])ArrayUtils.addAll((Object[])schema1, (Object[])schema2);
    }

    public static int countNonZeros(double[] data, int pos, int len) {
        int ret = 0;
        for (int i = pos; i < pos + len; ++i) {
            ret += data[i] != 0.0 ? 1 : 0;
        }
        return ret;
    }

    public static boolean containsZero(double[] data, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            if (data[i] != 0.0) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> List<T> asList(List<T> ... inputs) {
        ArrayList<T> ret = new ArrayList<T>();
        for (List<T> list : inputs) {
            ret.addAll(list);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(List<T> ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        for (List<T> list : inputs) {
            ret.addAll(list);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T[] ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        T[][] TArray = inputs;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] input;
            for (T element : input = TArray[i]) {
                ret.add(element);
            }
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        for (T element : inputs) {
            ret.add(element);
        }
        return ret;
    }

    public static <T> Stream<T> getStream(Iterator<T> iter) {
        Iterable iterable = () -> iter;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static long prod(long[] arr) {
        long ret = 1L;
        for (int i = 0; i < arr.length; ++i) {
            ret *= arr[i];
        }
        return ret;
    }

    public static long prod(int[] arr) {
        long ret = 1L;
        for (int i = 0; i < arr.length; ++i) {
            ret *= (long)arr[i];
        }
        return ret;
    }

    public static long prod(int[] arr, int off) {
        long ret = 1L;
        for (int i = off; i < arr.length; ++i) {
            ret *= (long)arr[i];
        }
        return ret;
    }

    public static void getBlockBounds(TensorIndexes ix, long[] dims, int blen, int[] lower, int[] upper) {
        int i;
        for (i = 0; i < dims.length; ++i) {
            lower[i] = (int)(ix.getIndex(i) - 1L) * blen;
            upper[i] = (int)((long)lower[i] + dims[i] - 1L);
        }
        int n = upper.length - 1;
        upper[n] = upper[n] + 1;
        for (i = upper.length - 1; i > 0 && (long)upper[i] == dims[i]; --i) {
            upper[i] = 0;
            int n2 = i - 1;
            upper[n2] = upper[n2] + 1;
        }
    }
}

