/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.conf.DMLConfig;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.parser.ForStatementBlock;
import org.tugraz.sysds.parser.IfStatementBlock;
import org.tugraz.sysds.parser.ParForStatementBlock;
import org.tugraz.sysds.parser.StatementBlock;
import org.tugraz.sysds.parser.WhileStatementBlock;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.codegen.CodegenUtils;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.IfProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.ParForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.WhileProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.controlprogram.paramserv.SparkPSBody;
import org.tugraz.sysds.runtime.controlprogram.parfor.ParForBody;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.instructions.CPInstructionParser;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.InstructionParser;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.IntObject;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.SpoofCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.StringObject;
import org.tugraz.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.tugraz.sysds.runtime.instructions.gpu.GPUInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.lineage.Lineage;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;

public class ProgramConverter {
    protected static final Log LOG = LogFactory.getLog((String)ProgramConverter.class.getName());
    public static final String NEWLINE = "\n";
    public static final String COMPONENTS_DELIM = "\u236e";
    public static final String ELEMENT_DELIM = "\u236a";
    public static final String ELEMENT_DELIM2 = ",";
    public static final String DATA_FIELD_DELIM = "|";
    public static final String KEY_VALUE_DELIM = "=";
    public static final String LEVELIN = "\u23a8";
    public static final String LEVELOUT = "\u23ac";
    public static final String EMPTY = "null";
    public static final String DASH = "-";
    public static final String REF = "ref";
    public static final String LIST_ELEMENT_DELIM = "\t";
    public static final String CDATA_BEGIN = "<![CDATA[";
    public static final String CDATA_END = " ]]>";
    public static final String PROG_BEGIN = " PROG\u23a8";
    public static final String PROG_END = "\u23ac";
    public static final String VARS_BEGIN = "VARS: ";
    public static final String VARS_END = "";
    public static final String PBS_BEGIN = " PBS\u23a8";
    public static final String PBS_END = "\u23ac";
    public static final String INST_BEGIN = " INST: ";
    public static final String INST_END = "";
    public static final String EC_BEGIN = " EC: ";
    public static final String EC_END = "";
    public static final String PB_BEGIN = " PB\u23a8";
    public static final String PB_END = "\u23ac";
    public static final String PB_WHILE = " WHILE\u23a8";
    public static final String PB_FOR = " FOR\u23a8";
    public static final String PB_PARFOR = " PARFOR\u23a8";
    public static final String PB_IF = " IF\u23a8";
    public static final String PB_FC = " FC\u23a8";
    public static final String PB_EFC = " EFC\u23a8";
    public static final String CONF_STATS = "stats";
    public static final String PARFORBODY_BEGIN = "<![CDATA[PARFORBODY\u23a8";
    public static final String PARFORBODY_END = "\u23ac ]]>";
    public static final String PSBODY_BEGIN = "<![CDATA[PSBODY\u23a8";
    public static final String PSBODY_END = "\u23ac ]]>";
    public static final String NOT_SUPPORTED_EXTERNALFUNCTION_PB = "Not supported: ExternalFunctionProgramBlock contains MR instructions. (ExternalFunctionPRogramBlockCP can be used)";
    public static final String NOT_SUPPORTED_SPARK_INSTRUCTION = "Not supported: Instructions of type other than CP instructions";
    public static final String NOT_SUPPORTED_SPARK_PARFOR = "Not supported: Nested ParFOR REMOTE_SPARK due to possible deadlocks.(LOCAL can be used for innner ParFOR)";
    public static final String NOT_SUPPORTED_PB = "Not supported: type of program block";

    public static ExecutionContext createDeepCopyExecutionContext(ExecutionContext ec) throws CloneNotSupportedException {
        ExecutionContext cpec = ExecutionContextFactory.createContext(false, ec.getProgram());
        cpec.setVariables((LocalVariableMap)ec.getVariables().clone());
        if (ec.getLineage() != null) {
            cpec.setLineage(new Lineage(ec.getLineage()));
        }
        for (String var : cpec.getVariables().keySet()) {
            Data dat = cpec.getVariables().get(var);
            if (!(dat instanceof MatrixObject) || !((MatrixObject)dat).getUpdateType().isInPlace()) continue;
            MatrixObject mo = (MatrixObject)dat;
            MatrixObject moNew = new MatrixObject(mo);
            if (mo.getNnz() != 0L) {
                MatrixBlock mbVar = mo.acquireRead();
                moNew.acquireModify(new MatrixBlock(mbVar));
                mo.release();
            } else {
                moNew.acquireModify(new MatrixBlock((int)mo.getNumRows(), (int)mo.getNumColumns(), false));
            }
            moNew.release();
            cpec.setVariable(var, moNew);
        }
        return cpec;
    }

    public static ArrayList<ProgramBlock> rcreateDeepCopyProgramBlocks(ArrayList<ProgramBlock> childBlocks, long pid, int IDPrefix, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) {
        ArrayList<ProgramBlock> tmp = new ArrayList<ProgramBlock>();
        for (ProgramBlock pb : childBlocks) {
            Program prog = pb.getProgram();
            ProgramBlock tmpPB = null;
            if (pb instanceof WhileProgramBlock) {
                tmpPB = ProgramConverter.createDeepCopyWhileProgramBlock((WhileProgramBlock)pb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
                tmpPB = ProgramConverter.createDeepCopyForProgramBlock((ForProgramBlock)pb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof ParForProgramBlock) {
                ParForProgramBlock pfpb = (ParForProgramBlock)pb;
                tmpPB = ProgramConverter.createDeepCopyParForProgramBlock(pfpb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof IfProgramBlock) {
                tmpPB = ProgramConverter.createDeepCopyIfProgramBlock((IfProgramBlock)pb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof BasicProgramBlock) {
                BasicProgramBlock bpb = (BasicProgramBlock)pb;
                tmpPB = new BasicProgramBlock(prog);
                tmpPB.setStatementBlock(ProgramConverter.createStatementBlockCopy(bpb.getStatementBlock(), pid, plain, forceDeepCopy));
                tmpPB.setThreadID(pid);
                ((BasicProgramBlock)tmpPB).setInstructions(ProgramConverter.createDeepCopyInstructionSet(bpb.getInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
            }
            tmp.add(tmpPB);
        }
        return tmp;
    }

    public static WhileProgramBlock createDeepCopyWhileProgramBlock(WhileProgramBlock wpb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) {
        ArrayList<Instruction> predinst = ProgramConverter.createDeepCopyInstructionSet(wpb.getPredicate(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true);
        WhileProgramBlock tmpPB = new WhileProgramBlock(prog, predinst);
        tmpPB.setStatementBlock(ProgramConverter.createWhileStatementBlockCopy((WhileStatementBlock)wpb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(wpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        return tmpPB;
    }

    public static IfProgramBlock createDeepCopyIfProgramBlock(IfProgramBlock ipb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) {
        ArrayList<Instruction> predinst = ProgramConverter.createDeepCopyInstructionSet(ipb.getPredicate(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true);
        IfProgramBlock tmpPB = new IfProgramBlock(prog, predinst);
        tmpPB.setStatementBlock(ProgramConverter.createIfStatementBlockCopy((IfStatementBlock)ipb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.setChildBlocksIfBody(ProgramConverter.rcreateDeepCopyProgramBlocks(ipb.getChildBlocksIfBody(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        tmpPB.setChildBlocksElseBody(ProgramConverter.rcreateDeepCopyProgramBlocks(ipb.getChildBlocksElseBody(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        return tmpPB;
    }

    public static ForProgramBlock createDeepCopyForProgramBlock(ForProgramBlock fpb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) {
        ForProgramBlock tmpPB = new ForProgramBlock(prog, fpb.getIterVar());
        tmpPB.setStatementBlock(ProgramConverter.createForStatementBlockCopy((ForStatementBlock)fpb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.setFromInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getFromInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setToInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getToInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setIncrementInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getIncrementInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(fpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        return tmpPB;
    }

    public static ForProgramBlock createShallowCopyForProgramBlock(ForProgramBlock fpb, Program prog) {
        ForProgramBlock tmpPB = new ForProgramBlock(prog, fpb.getIterVar());
        tmpPB.setFromInstructions(fpb.getFromInstructions());
        tmpPB.setToInstructions(fpb.getToInstructions());
        tmpPB.setIncrementInstructions(fpb.getIncrementInstructions());
        tmpPB.setChildBlocks(fpb.getChildBlocks());
        return tmpPB;
    }

    public static ParForProgramBlock createDeepCopyParForProgramBlock(ParForProgramBlock pfpb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) {
        ParForProgramBlock tmpPB = null;
        tmpPB = IDPrefix == -1 ? new ParForProgramBlock(prog, pfpb.getIterVar(), pfpb.getParForParams(), pfpb.getResultVariables()) : new ParForProgramBlock(IDPrefix, prog, pfpb.getIterVar(), pfpb.getParForParams(), pfpb.getResultVariables());
        tmpPB.setStatementBlock(ProgramConverter.createForStatementBlockCopy((ForStatementBlock)pfpb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.disableOptimization();
        tmpPB.disableMonitorReport();
        tmpPB.setFromInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getFromInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setToInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getToInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setIncrementInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getIncrementInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        if (plain || forceDeepCopy) {
            tmpPB.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(pfpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        } else {
            tmpPB.setChildBlocks(pfpb.getChildBlocks());
        }
        return tmpPB;
    }

    public static void createDeepCopyFunctionProgramBlock(String namespace, String oldName, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain) {
        FunctionProgramBlock fpb = prog.getFunctionProgramBlock(namespace, oldName);
        String fnameNew = plain ? oldName : oldName + "_t" + pid;
        String fnameNewKey = DMLProgram.constructFunctionKey(namespace, fnameNew);
        if (prog.getFunctionProgramBlocks().containsKey(fnameNewKey)) {
            return;
        }
        FunctionProgramBlock copy = null;
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>();
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>();
        if (fpb.getInputParams() != null) {
            tmp1.addAll(fpb.getInputParams());
        }
        if (fpb.getOutputParams() != null) {
            tmp2.addAll(fpb.getOutputParams());
        }
        if (!fnStack.contains(fnameNewKey)) {
            fnStack.add(fnameNewKey);
            copy = new FunctionProgramBlock(prog, tmp1, tmp2);
            copy.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(fpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, fpb.isRecompileOnce()));
            copy.setRecompileOnce(fpb.isRecompileOnce());
            copy.setThreadID(pid);
            fnStack.remove(fnameNewKey);
        } else {
            copy = fpb;
        }
        prog.addFunctionProgramBlock(namespace, fnameNew, copy);
        fnCreated.add(DMLProgram.constructFunctionKey(namespace, fnameNew));
    }

    public static FunctionProgramBlock createDeepCopyFunctionProgramBlock(FunctionProgramBlock fpb, HashSet<String> fnStack, HashSet<String> fnCreated) {
        if (fpb == null) {
            throw new DMLRuntimeException("Unable to create a deep copy of a non-existing FunctionProgramBlock.");
        }
        FunctionProgramBlock copy = null;
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>();
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>();
        if (fpb.getInputParams() != null) {
            tmp1.addAll(fpb.getInputParams());
        }
        if (fpb.getOutputParams() != null) {
            tmp2.addAll(fpb.getOutputParams());
        }
        copy = new FunctionProgramBlock(fpb.getProgram(), tmp1, tmp2);
        copy.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(fpb.getChildBlocks(), 0L, -1, fnStack, fnCreated, true, fpb.isRecompileOnce()));
        copy.setStatementBlock(fpb.getStatementBlock());
        copy.setRecompileOnce(fpb.isRecompileOnce());
        return copy;
    }

    public static ArrayList<Instruction> createDeepCopyInstructionSet(ArrayList<Instruction> instSet, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean cpFunctions) {
        ArrayList<Instruction> tmp = new ArrayList<Instruction>();
        for (Instruction inst : instSet) {
            if (inst instanceof FunctionCallCPInstruction && cpFunctions) {
                FunctionCallCPInstruction finst = (FunctionCallCPInstruction)inst;
                ProgramConverter.createDeepCopyFunctionProgramBlock(finst.getNamespace(), finst.getFunctionName(), pid, IDPrefix, prog, fnStack, fnCreated, plain);
            }
            tmp.add(ProgramConverter.cloneInstruction(inst, pid, plain, cpFunctions));
        }
        return tmp;
    }

    public static Instruction cloneInstruction(Instruction oInst, long pid, boolean plain, boolean cpFunctions) {
        Instruction inst = null;
        String tmpString = oInst.toString();
        try {
            if (oInst instanceof CPInstruction || oInst instanceof SPInstruction || oInst instanceof GPUInstruction) {
                if (oInst instanceof FunctionCallCPInstruction && cpFunctions) {
                    FunctionCallCPInstruction tmp = (FunctionCallCPInstruction)oInst;
                    if (!plain) {
                        tmpString = tmp.updateInstStringFunctionName(tmp.getFunctionName(), tmp.getFunctionName() + "_t" + pid);
                    }
                }
            } else {
                throw new DMLRuntimeException("Failed to clone instruction: " + oInst);
            }
            inst = InstructionParser.parseSingleInstruction(tmpString);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        inst = ProgramConverter.saveReplaceThreadID(inst, "_t0", "_t" + pid);
        return inst;
    }

    public static StatementBlock createStatementBlockCopy(StatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) {
        StatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getHops()) || forceDeepCopy)) {
                ret = new StatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ArrayList<Hop> hops = Recompiler.deepCopyHopsDag(sb.getHops());
                if (!plain) {
                    Recompiler.updateFunctionNames(hops, pid);
                }
                ret.setHops(hops);
                ret.updateRecompilationFlag();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static IfStatementBlock createIfStatementBlockCopy(IfStatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) {
        IfStatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getPredicateHops()) || forceDeepCopy)) {
                ret = new IfStatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ret.setStatements(sb.getStatements());
                Hop hops = Recompiler.deepCopyHopsDag(sb.getPredicateHops());
                ret.setPredicateHops(hops);
                ret.updatePredicateRecompilationFlag();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static WhileStatementBlock createWhileStatementBlockCopy(WhileStatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) {
        WhileStatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getPredicateHops()) || forceDeepCopy)) {
                ret = new WhileStatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ret.setUpdateInPlaceVars(sb.getUpdateInPlaceVars());
                ret.setStatements(sb.getStatements());
                Hop hops = Recompiler.deepCopyHopsDag(sb.getPredicateHops());
                ret.setPredicateHops(hops);
                ret.updatePredicateRecompilationFlag();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static ForStatementBlock createForStatementBlockCopy(ForStatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) {
        ForStatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getFromHops()) || Recompiler.requiresRecompilation(sb.getToHops()) || Recompiler.requiresRecompilation(sb.getIncrementHops()) || forceDeepCopy)) {
                Hop hops;
                ret = sb instanceof ParForStatementBlock ? new ParForStatementBlock() : new ForStatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ret.setUpdateInPlaceVars(sb.getUpdateInPlaceVars());
                ret.setStatements(sb.getStatements());
                if (sb.requiresFromRecompilation()) {
                    hops = Recompiler.deepCopyHopsDag(sb.getFromHops());
                    ret.setFromHops(hops);
                }
                if (sb.requiresToRecompilation()) {
                    hops = Recompiler.deepCopyHopsDag(sb.getToHops());
                    ret.setToHops(hops);
                }
                if (sb.requiresIncrementRecompilation()) {
                    hops = Recompiler.deepCopyHopsDag(sb.getIncrementHops());
                    ret.setIncrementHops(hops);
                }
                ret.updatePredicateRecompilationFlags();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static String serializeSparkPSBody(SparkPSBody body, HashMap<String, byte[]> clsMap) {
        ExecutionContext ec = body.getEc();
        StringBuilder builder = new StringBuilder();
        builder.append(PSBODY_BEGIN);
        builder.append(NEWLINE);
        builder.append(DMLScript.getUUID());
        builder.append(COMPONENTS_DELIM);
        builder.append(NEWLINE);
        builder.append(ConfigurationManager.getDMLConfig().serializeDMLConfig());
        builder.append(COMPONENTS_DELIM);
        builder.append(NEWLINE);
        builder.append("stats=" + DMLScript.STATISTICS);
        builder.append(COMPONENTS_DELIM);
        builder.append(NEWLINE);
        builder.append(PROG_BEGIN);
        builder.append(NEWLINE);
        builder.append(ProgramConverter.rSerializeFunctionProgramBlocks(ec.getProgram().getFunctionProgramBlocks(), new HashSet<String>(ec.getProgram().getFunctionProgramBlocks().keySet()), clsMap));
        builder.append("\u23ac");
        builder.append(NEWLINE);
        builder.append(COMPONENTS_DELIM);
        builder.append(NEWLINE);
        builder.append(EC_BEGIN);
        builder.append(ProgramConverter.serializeExecutionContext(ec));
        builder.append("");
        builder.append(NEWLINE);
        builder.append(COMPONENTS_DELIM);
        builder.append(NEWLINE);
        builder.append(PBS_BEGIN);
        builder.append(NEWLINE);
        builder.append(ProgramConverter.rSerializeProgramBlocks(ec.getProgram().getProgramBlocks(), clsMap));
        builder.append("\u23ac");
        builder.append(NEWLINE);
        builder.append(COMPONENTS_DELIM);
        builder.append(NEWLINE);
        builder.append("\u23ac ]]>");
        return builder.toString();
    }

    public static String serializeParForBody(ParForBody body) {
        return ProgramConverter.serializeParForBody(body, new HashMap<String, byte[]>());
    }

    public static String serializeParForBody(ParForBody body, HashMap<String, byte[]> clsMap) {
        ArrayList<ProgramBlock> pbs = body.getChildBlocks();
        ArrayList<ParForStatementBlock.ResultVar> rVnames = body.getResultVariables();
        ExecutionContext ec = body.getEc();
        if (pbs.isEmpty()) {
            return "<![CDATA[PARFORBODY\u23a8\u23ac ]]>";
        }
        Program prog = pbs.get(0).getProgram();
        StringBuilder sb = new StringBuilder();
        sb.append(PARFORBODY_BEGIN);
        sb.append(NEWLINE);
        sb.append(DMLScript.getUUID());
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(ConfigurationManager.getDMLConfig().serializeDMLConfig());
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append("stats=" + DMLScript.STATISTICS);
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(PROG_BEGIN);
        sb.append(NEWLINE);
        sb.append(ProgramConverter.serializeProgram(prog, pbs, clsMap));
        sb.append("\u23ac");
        sb.append(NEWLINE);
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(ProgramConverter.serializeResultVariables(rVnames));
        sb.append(COMPONENTS_DELIM);
        sb.append(EC_BEGIN);
        sb.append(ProgramConverter.serializeExecutionContext(ec));
        sb.append("");
        sb.append(NEWLINE);
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(PBS_BEGIN);
        sb.append(NEWLINE);
        sb.append(ProgramConverter.rSerializeProgramBlocks(pbs, clsMap));
        sb.append("\u23ac");
        sb.append(NEWLINE);
        sb.append("\u23ac ]]>");
        return sb.toString();
    }

    private static String serializeProgram(Program prog, ArrayList<ProgramBlock> pbs, HashMap<String, byte[]> clsMap) {
        HashMap<String, FunctionProgramBlock> fpb = prog.getFunctionProgramBlocks();
        HashSet<String> cand = new HashSet<String>();
        ProgramConverter.rFindSerializationCandidates(pbs, cand);
        return ProgramConverter.rSerializeFunctionProgramBlocks(fpb, cand, clsMap);
    }

    private static void rFindSerializationCandidates(ArrayList<ProgramBlock> pbs, HashSet<String> cand) {
        for (ProgramBlock pb : pbs) {
            if (pb instanceof WhileProgramBlock) {
                WhileProgramBlock wpb = (WhileProgramBlock)pb;
                ProgramConverter.rFindSerializationCandidates(wpb.getChildBlocks(), cand);
                continue;
            }
            if (pb instanceof ForProgramBlock || pb instanceof ParForProgramBlock) {
                ForProgramBlock fpb = (ForProgramBlock)pb;
                ProgramConverter.rFindSerializationCandidates(fpb.getChildBlocks(), cand);
                continue;
            }
            if (pb instanceof IfProgramBlock) {
                IfProgramBlock ipb = (IfProgramBlock)pb;
                ProgramConverter.rFindSerializationCandidates(ipb.getChildBlocksIfBody(), cand);
                if (ipb.getChildBlocksElseBody() == null) continue;
                ProgramConverter.rFindSerializationCandidates(ipb.getChildBlocksElseBody(), cand);
                continue;
            }
            if (!(pb instanceof BasicProgramBlock)) continue;
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            for (Instruction inst : bpb.getInstructions()) {
                FunctionCallCPInstruction fci;
                String fkey;
                if (!(inst instanceof FunctionCallCPInstruction) || cand.contains(fkey = DMLProgram.constructFunctionKey((fci = (FunctionCallCPInstruction)inst).getNamespace(), fci.getFunctionName()))) continue;
                cand.add(fkey);
                FunctionProgramBlock fpb = pb.getProgram().getFunctionProgramBlock(fci.getNamespace(), fci.getFunctionName());
                ProgramConverter.rFindSerializationCandidates(fpb.getChildBlocks(), cand);
            }
        }
    }

    private static String serializeVariables(LocalVariableMap vars) {
        StringBuilder sb = new StringBuilder();
        sb.append(VARS_BEGIN);
        sb.append(vars.serialize());
        sb.append("");
        return sb.toString();
    }

    public static String serializeDataObject(String key, Data dat) {
        StringBuilder sb = new StringBuilder();
        String name = key;
        Types.DataType datatype = dat.getDataType();
        Types.ValueType valuetype = dat.getValueType();
        String value = null;
        String[] metaData = null;
        String[] listData = null;
        switch (datatype) {
            case SCALAR: {
                ScalarObject so = (ScalarObject)dat;
                value = so.getStringValue();
                break;
            }
            case MATRIX: {
                MatrixObject mo = (MatrixObject)dat;
                MetaDataFormat md = (MetaDataFormat)dat.getMetaData();
                DataCharacteristics dc = md.getDataCharacteristics();
                value = mo.getFileName();
                ParForProgramBlock.PartitionFormat partFormat = mo.getPartitionFormat() != null ? new ParForProgramBlock.PartitionFormat(mo.getPartitionFormat(), mo.getPartitionSize()) : ParForProgramBlock.PartitionFormat.NONE;
                metaData = new String[]{String.valueOf(dc.getRows()), String.valueOf(dc.getCols()), String.valueOf(dc.getBlocksize()), String.valueOf(dc.getNonZeros()), InputInfo.inputInfoToString(md.getInputInfo()), OutputInfo.outputInfoToString(md.getOutputInfo()), String.valueOf(partFormat), String.valueOf((Object)mo.getUpdateType()), String.valueOf(mo.isHDFSFileExists()), String.valueOf(mo.isCleanupEnabled())};
                break;
            }
            case LIST: {
                ListObject lo = (ListObject)dat;
                value = REF;
                metaData = new String[]{String.valueOf(lo.getLength()), lo.getNames() == null ? EMPTY : ProgramConverter.serializeList(lo.getNames(), ELEMENT_DELIM2)};
                listData = new String[lo.getLength()];
                for (int index = 0; index < lo.getLength(); ++index) {
                    listData[index] = ProgramConverter.serializeDataObject(name + DASH + index, lo.slice(index));
                }
                break;
            }
            default: {
                throw new DMLRuntimeException("Unable to serialize datatype " + (Object)((Object)datatype));
            }
        }
        sb.append(name);
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)datatype);
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)valuetype);
        sb.append(DATA_FIELD_DELIM);
        sb.append(value);
        if (metaData != null) {
            for (int i = 0; i < metaData.length; ++i) {
                sb.append(DATA_FIELD_DELIM);
                sb.append(metaData[i]);
            }
        }
        if (listData != null) {
            sb.append(DATA_FIELD_DELIM);
            for (String ld : listData) {
                sb.append(LIST_ELEMENT_DELIM);
                sb.append(ld);
            }
        }
        return sb.toString();
    }

    private static String serializeExecutionContext(ExecutionContext ec) {
        return ec != null ? ProgramConverter.serializeVariables(ec.getVariables()) : EMPTY;
    }

    private static String serializeInstructions(ArrayList<Instruction> inst, HashMap<String, byte[]> clsMap) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Instruction linst : inst) {
            if (!(linst instanceof CPInstruction)) {
                throw new DMLRuntimeException("Not supported: Instructions of type other than CP instructions " + linst.getClass().getName() + NEWLINE + linst);
            }
            if (linst instanceof SpoofCPInstruction) {
                Class<?> cla = ((SpoofCPInstruction)linst).getOperatorClass();
                clsMap.put(cla.getName(), CodegenUtils.getClassData(cla.getName()));
            }
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(ProgramConverter.checkAndReplaceLiterals(linst.toString()));
            ++count;
        }
        return sb.toString();
    }

    private static String checkAndReplaceLiterals(String instStr) {
        String tmp = instStr;
        if (tmp.contains(COMPONENTS_DELIM)) {
            tmp = tmp.replaceAll(COMPONENTS_DELIM, ".");
            LOG.warn((Object)"Replaced special literal character sequence \u236e with '.'");
        }
        if (tmp.contains(ELEMENT_DELIM)) {
            tmp = tmp.replaceAll(ELEMENT_DELIM, ".");
            LOG.warn((Object)"Replaced special literal character sequence \u236a with '.'");
        }
        if (tmp.contains(LEVELIN)) {
            tmp = tmp.replaceAll(LEVELIN, "(");
            LOG.warn((Object)"Replaced special literal character sequence \u23a8 with '('");
        }
        if (tmp.contains("\u23ac")) {
            tmp = tmp.replaceAll("\u23ac", ")");
            LOG.warn((Object)"Replaced special literal character sequence \u23ac with ')'");
        }
        if (tmp.contains(CDATA_END)) {
            tmp = tmp.replaceAll(CDATA_END, ".");
            LOG.warn((Object)"Replaced special literal character sequence  ]]> with '.'");
        }
        return tmp;
    }

    private static String serializeStringHashMap(HashMap<String, String> vars) {
        return ProgramConverter.serializeList(vars.entrySet().stream().map(e -> (String)e.getKey() + KEY_VALUE_DELIM + (String)e.getValue()).collect(Collectors.toList()));
    }

    public static String serializeResultVariables(List<ParForStatementBlock.ResultVar> vars) {
        return ProgramConverter.serializeList(vars.stream().map(v -> v._isAccum ? v._name + "+" : v._name).collect(Collectors.toList()));
    }

    public static String serializeList(List<String> elements) {
        return ProgramConverter.serializeList(elements, ELEMENT_DELIM);
    }

    public static String serializeList(List<String> elements, String delim) {
        return StringUtils.join(elements, (String)delim);
    }

    private static String serializeDataIdentifiers(List<DataIdentifier> vars) {
        return ProgramConverter.serializeList(vars.stream().map(v -> ProgramConverter.serializeDataIdentifier(v)).collect(Collectors.toList()));
    }

    private static String serializeDataIdentifier(DataIdentifier dat) {
        StringBuilder sb = new StringBuilder();
        sb.append(dat.getName());
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)dat.getDataType());
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)dat.getValueType());
        return sb.toString();
    }

    private static String rSerializeFunctionProgramBlocks(HashMap<String, FunctionProgramBlock> pbs, HashSet<String> cand, HashMap<String, byte[]> clsMap) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, FunctionProgramBlock> pb : pbs.entrySet()) {
            if (!cand.contains(pb.getKey())) continue;
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
                sb.append(NEWLINE);
            }
            sb.append(pb.getKey());
            sb.append(KEY_VALUE_DELIM);
            sb.append(ProgramConverter.rSerializeProgramBlock(pb.getValue(), clsMap));
            ++count;
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String rSerializeProgramBlocks(ArrayList<ProgramBlock> pbs, HashMap<String, byte[]> clsMap) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (ProgramBlock pb : pbs) {
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
                sb.append(NEWLINE);
            }
            sb.append(ProgramConverter.rSerializeProgramBlock(pb, clsMap));
            ++count;
        }
        return sb.toString();
    }

    private static String rSerializeProgramBlock(ProgramBlock pb, HashMap<String, byte[]> clsMap) {
        StringBuilder sb = new StringBuilder();
        if (pb instanceof WhileProgramBlock) {
            sb.append(PB_WHILE);
        } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
            sb.append(PB_FOR);
        } else if (pb instanceof ParForProgramBlock) {
            sb.append(PB_PARFOR);
        } else if (pb instanceof IfProgramBlock) {
            sb.append(PB_IF);
        } else if (pb instanceof FunctionProgramBlock) {
            sb.append(PB_FC);
        } else {
            sb.append(PB_BEGIN);
        }
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(wpb.getPredicate(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(wpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            sb.append(fpb.getIterVar());
            sb.append(COMPONENTS_DELIM);
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getFromInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getToInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getIncrementInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(fpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof ParForProgramBlock) {
            ParForProgramBlock pfpb = (ParForProgramBlock)pb;
            if (ParForProgramBlock.PExecMode.valueOf(pfpb.getParForParams().get("mode")) == ParForProgramBlock.PExecMode.REMOTE_SPARK) {
                throw new DMLRuntimeException(NOT_SUPPORTED_SPARK_PARFOR);
            }
            sb.append(pfpb.getIterVar());
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeResultVariables(pfpb.getResultVariables()));
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeStringHashMap(pfpb.getParForParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getFromInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getToInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getIncrementInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(pfpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(ipb.getPredicate(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(ipb.getChildBlocksIfBody(), clsMap));
            sb.append("\u23ac");
            sb.append(COMPONENTS_DELIM);
            sb.append(PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(ipb.getChildBlocksElseBody(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            sb.append(ProgramConverter.serializeDataIdentifiers(fpb.getInputParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeDataIdentifiers(fpb.getOutputParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(fpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
            sb.append(COMPONENTS_DELIM);
        } else if (pb instanceof BasicProgramBlock) {
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            sb.append(INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(bpb.getInstructions(), clsMap));
            sb.append("");
        }
        sb.append("\u23ac");
        return sb.toString();
    }

    public static SparkPSBody parseSparkPSBody(String in, int id) {
        SparkPSBody body = new SparkPSBody();
        String tmpin = in.replaceAll(NEWLINE, "");
        tmpin = tmpin.substring(PSBODY_BEGIN.length(), tmpin.length() - "\u23ac ]]>".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(tmpin, COMPONENTS_DELIM);
        DMLScript.setUUID(st.nextToken());
        ProgramConverter.handleDMLConfig(st.nextToken());
        ProgramConverter.parseAndSetAdditionalConfigurations(st.nextToken());
        Program prog = ProgramConverter.parseProgram(st.nextToken(), id);
        ExecutionContext ec = ProgramConverter.parseExecutionContext(st.nextToken(), prog);
        ec.setProgram(prog);
        String spbs = st.nextToken();
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(spbs, prog, id);
        prog.getProgramBlocks().addAll(pbs);
        body.setEc(ec);
        return body;
    }

    public static ParForBody parseParForBody(String in, int id) {
        return ProgramConverter.parseParForBody(in, id, false);
    }

    public static ParForBody parseParForBody(String in, int id, boolean inSpark) {
        ParForBody body = new ParForBody();
        String tmpin = in.replaceAll(NEWLINE, "");
        tmpin = tmpin.substring(PARFORBODY_BEGIN.length(), tmpin.length() - "\u23ac ]]>".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(tmpin, COMPONENTS_DELIM);
        DMLScript.setUUID(st.nextToken());
        String confStr = st.nextToken();
        JobConf job = ConfigurationManager.getCachedJobConf();
        if (!InfrastructureAnalyzer.isLocalMode(job)) {
            ProgramConverter.handleDMLConfig(confStr);
        }
        String aconfs = st.nextToken();
        if (!inSpark) {
            ProgramConverter.parseAndSetAdditionalConfigurations(aconfs);
        }
        String progStr = st.nextToken();
        Program prog = ProgramConverter.parseProgram(progStr, id);
        String rvarStr = st.nextToken();
        ArrayList<ParForStatementBlock.ResultVar> rvars = ProgramConverter.parseResultVariables(rvarStr);
        body.setResultVariables(rvars);
        String ecStr = st.nextToken();
        ExecutionContext ec = ProgramConverter.parseExecutionContext(ecStr, prog);
        String spbs = st.nextToken();
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(spbs, prog, id);
        body.setChildBlocks(pbs);
        body.setEc(ec);
        return body;
    }

    private static void handleDMLConfig(String confStr) {
        if (confStr != null && !confStr.trim().isEmpty()) {
            DMLConfig dmlconf = DMLConfig.parseDMLConfig(confStr);
            CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(dmlconf);
            ConfigurationManager.setLocalConfig(dmlconf);
            ConfigurationManager.setLocalConfig(cconf);
        }
    }

    public static Program parseProgram(String in, int id) {
        String lin = in.substring(PROG_BEGIN.length(), in.length() - "\u23ac".length()).trim();
        Program prog = new Program();
        HashMap<String, FunctionProgramBlock> fc = ProgramConverter.parseFunctionProgramBlocks(lin, prog, id);
        for (Map.Entry<String, FunctionProgramBlock> e : fc.entrySet()) {
            String[] keypart = e.getKey().split("::");
            String namespace = keypart[0];
            String name = keypart[1];
            prog.addFunctionProgramBlock(namespace, name, e.getValue());
        }
        return prog;
    }

    private static LocalVariableMap parseVariables(String in) {
        LocalVariableMap ret = null;
        if (in.length() > VARS_BEGIN.length() + "".length()) {
            String varStr = in.substring(VARS_BEGIN.length(), in.length() - "".length()).trim();
            ret = LocalVariableMap.deserialize(varStr);
        } else {
            ret = new LocalVariableMap();
        }
        return ret;
    }

    private static HashMap<String, FunctionProgramBlock> parseFunctionProgramBlocks(String in, Program prog, int id) {
        HashMap<String, FunctionProgramBlock> ret = new HashMap<String, FunctionProgramBlock>();
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String lvar = st.nextToken();
            int index = lvar.indexOf(KEY_VALUE_DELIM);
            String tmp1 = lvar.substring(0, index);
            String tmp2 = lvar.substring(index + 1);
            ret.put(tmp1, (FunctionProgramBlock)ProgramConverter.rParseProgramBlock(tmp2, prog, id));
        }
        return ret;
    }

    private static ArrayList<ProgramBlock> rParseProgramBlocks(String in, Program prog, int id) {
        ArrayList<ProgramBlock> pbs = new ArrayList<ProgramBlock>();
        String tmpdata = in.substring(PBS_BEGIN.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(tmpdata, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            pbs.add(ProgramConverter.rParseProgramBlock(st.nextToken(), prog, id));
        }
        return pbs;
    }

    private static ProgramBlock rParseProgramBlock(String in, Program prog, int id) {
        ProgramBlock pb = null;
        if (in.startsWith(PB_WHILE)) {
            pb = ProgramConverter.rParseWhileProgramBlock(in, prog, id);
        } else if (in.startsWith(PB_FOR)) {
            pb = ProgramConverter.rParseForProgramBlock(in, prog, id);
        } else if (in.startsWith(PB_PARFOR)) {
            pb = ProgramConverter.rParseParForProgramBlock(in, prog, id);
        } else if (in.startsWith(PB_IF)) {
            pb = ProgramConverter.rParseIfProgramBlock(in, prog, id);
        } else if (in.startsWith(PB_FC)) {
            pb = ProgramConverter.rParseFunctionProgramBlock(in, prog, id);
        } else if (in.startsWith(PB_BEGIN)) {
            pb = ProgramConverter.rParseGenericProgramBlock(in, prog, id);
        } else {
            throw new DMLRuntimeException("Not supported: type of program block " + in);
        }
        return pb;
    }

    private static WhileProgramBlock rParseWhileProgramBlock(String in, Program prog, int id) {
        String lin = in.substring(PB_WHILE.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<Instruction> inst = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        WhileProgramBlock wpb = new WhileProgramBlock(prog, inst);
        wpb.setChildBlocks(pbs);
        return wpb;
    }

    private static ForProgramBlock rParseForProgramBlock(String in, Program prog, int id) {
        String lin = in.substring(PB_FOR.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        String iterVar = st.nextToken();
        ArrayList<Instruction> from = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> to = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> incr = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ForProgramBlock fpb = new ForProgramBlock(prog, iterVar);
        fpb.setFromInstructions(from);
        fpb.setToInstructions(to);
        fpb.setIncrementInstructions(incr);
        fpb.setChildBlocks(pbs);
        return fpb;
    }

    private static ParForProgramBlock rParseParForProgramBlock(String in, Program prog, int id) {
        String lin = in.substring(PB_PARFOR.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        String iterVar = st.nextToken();
        ArrayList<ParForStatementBlock.ResultVar> resultVars = ProgramConverter.parseResultVariables(st.nextToken());
        HashMap<String, String> params = ProgramConverter.parseStringHashMap(st.nextToken());
        ArrayList<Instruction> from = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<Instruction> to = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<Instruction> incr = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, 0);
        ParForProgramBlock pfpb = new ParForProgramBlock(id, prog, iterVar, params, resultVars);
        pfpb.disableOptimization();
        pfpb.setFromInstructions(from);
        pfpb.setToInstructions(to);
        pfpb.setIncrementInstructions(incr);
        pfpb.setChildBlocks(pbs);
        return pfpb;
    }

    private static IfProgramBlock rParseIfProgramBlock(String in, Program prog, int id) {
        String lin = in.substring(PB_IF.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<Instruction> inst = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs1 = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ArrayList<ProgramBlock> pbs2 = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        IfProgramBlock ipb = new IfProgramBlock(prog, inst);
        ipb.setChildBlocksIfBody(pbs1);
        ipb.setChildBlocksElseBody(pbs2);
        return ipb;
    }

    private static FunctionProgramBlock rParseFunctionProgramBlock(String in, Program prog, int id) {
        String lin = in.substring(PB_FC.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<DataIdentifier> dat1 = ProgramConverter.parseDataIdentifiers(st.nextToken());
        ArrayList<DataIdentifier> dat2 = ProgramConverter.parseDataIdentifiers(st.nextToken());
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>(dat1);
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>(dat2);
        FunctionProgramBlock fpb = new FunctionProgramBlock(prog, tmp1, tmp2);
        fpb.setChildBlocks(pbs);
        return fpb;
    }

    private static ProgramBlock rParseGenericProgramBlock(String in, Program prog, int id) {
        String lin = in.substring(PB_BEGIN.length(), in.length() - "\u23ac".length());
        StringTokenizer st = new StringTokenizer(lin, COMPONENTS_DELIM);
        BasicProgramBlock pb = new BasicProgramBlock(prog);
        pb.setInstructions(ProgramConverter.parseInstructions(st.nextToken(), id));
        return pb;
    }

    private static ArrayList<Instruction> parseInstructions(String in, int id) {
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        String lin = in.substring(INST_BEGIN.length(), in.length() - "".length());
        StringTokenizer st = new StringTokenizer(lin, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String instStr = st.nextToken();
            try {
                Instruction tmpinst = CPInstructionParser.parseSingleInstruction(instStr);
                tmpinst = ProgramConverter.saveReplaceThreadID(tmpinst, "_t0", "_t" + id);
                insts.add(tmpinst);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Failed to parse instruction: " + instStr, ex);
            }
        }
        return insts;
    }

    private static ArrayList<ParForStatementBlock.ResultVar> parseResultVariables(String in) {
        ArrayList<ParForStatementBlock.ResultVar> ret = new ArrayList<ParForStatementBlock.ResultVar>();
        for (String var : ProgramConverter.parseStringArrayList(in)) {
            boolean accum = var.endsWith("+");
            ret.add(new ParForStatementBlock.ResultVar(accum ? var.substring(0, var.length() - 1) : var, accum));
        }
        return ret;
    }

    private static HashMap<String, String> parseStringHashMap(String in) {
        HashMap<String, String> vars = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String lin = st.nextToken();
            int index = lin.indexOf(KEY_VALUE_DELIM);
            String tmp1 = lin.substring(0, index);
            String tmp2 = lin.substring(index + 1);
            vars.put(tmp1, tmp2);
        }
        return vars;
    }

    private static ArrayList<String> parseStringArrayList(String in) {
        return ProgramConverter.parseStringArrayList(in, ELEMENT_DELIM);
    }

    private static ArrayList<String> parseStringArrayList(String in, String delim) {
        StringTokenizer st = new StringTokenizer(in, delim);
        ArrayList<String> vars = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            vars.add(st.nextToken());
        }
        return vars;
    }

    private static ArrayList<DataIdentifier> parseDataIdentifiers(String in) {
        ArrayList<DataIdentifier> vars = new ArrayList<DataIdentifier>();
        StringTokenizer st = new StringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            DataIdentifier dat = ProgramConverter.parseDataIdentifier(tmp);
            vars.add(dat);
        }
        return vars;
    }

    private static DataIdentifier parseDataIdentifier(String in) {
        StringTokenizer st = new StringTokenizer(in, DATA_FIELD_DELIM);
        DataIdentifier dat = new DataIdentifier(st.nextToken());
        dat.setDataType(Types.DataType.valueOf(st.nextToken()));
        dat.setValueType(Types.ValueType.valueOf(st.nextToken()));
        return dat;
    }

    public static Object[] parseDataObject(String in) {
        Object[] ret = new Object[2];
        StringTokenizer st = new StringTokenizer(in, DATA_FIELD_DELIM);
        String name = st.nextToken();
        Types.DataType datatype = Types.DataType.valueOf(st.nextToken());
        Types.ValueType valuetype = Types.ValueType.valueOf(st.nextToken());
        String valString = st.hasMoreTokens() ? st.nextToken() : "";
        Data dat = null;
        block0 : switch (datatype) {
            case SCALAR: {
                switch (valuetype) {
                    case INT64: {
                        dat = new IntObject(Long.parseLong(valString));
                        break block0;
                    }
                    case FP64: {
                        dat = new DoubleObject(Double.parseDouble(valString));
                        break block0;
                    }
                    case BOOLEAN: {
                        dat = new BooleanObject(Boolean.parseBoolean(valString));
                        break block0;
                    }
                    case STRING: {
                        dat = new StringObject(valString);
                        break block0;
                    }
                }
                throw new DMLRuntimeException("Unable to parse valuetype " + (Object)((Object)valuetype));
            }
            case MATRIX: {
                MatrixObject mo = new MatrixObject(valuetype, valString);
                long rows = Long.parseLong(st.nextToken());
                long cols = Long.parseLong(st.nextToken());
                int blen = Integer.parseInt(st.nextToken());
                long nnz = Long.parseLong(st.nextToken());
                InputInfo iin = InputInfo.stringToInputInfo(st.nextToken());
                OutputInfo oin = OutputInfo.stringToOutputInfo(st.nextToken());
                ParForProgramBlock.PartitionFormat partFormat = ParForProgramBlock.PartitionFormat.valueOf(st.nextToken());
                MatrixObject.UpdateType inplace = MatrixObject.UpdateType.valueOf(st.nextToken());
                MatrixCharacteristics mc = new MatrixCharacteristics(rows, cols, blen, nnz);
                MetaDataFormat md = new MetaDataFormat(mc, oin, iin);
                mo.setMetaData(md);
                if (partFormat._dpf != ParForProgramBlock.PDataPartitionFormat.NONE) {
                    mo.setPartitioned(partFormat._dpf, partFormat._N);
                }
                mo.setUpdateType(inplace);
                mo.setHDFSFileExists(Boolean.valueOf(st.nextToken()));
                mo.enableCleanup(Boolean.valueOf(st.nextToken()));
                dat = mo;
                break;
            }
            case LIST: {
                int size = Integer.parseInt(st.nextToken());
                String namesStr = st.nextToken();
                ArrayList<String> names = namesStr.equals(EMPTY) ? null : ProgramConverter.parseStringArrayList(namesStr, ELEMENT_DELIM2);
                ArrayList<Data> data = new ArrayList<Data>(size);
                st.nextToken(LIST_ELEMENT_DELIM);
                for (int i = 0; i < size; ++i) {
                    String dataStr = st.nextToken();
                    Object[] obj = ProgramConverter.parseDataObject(dataStr);
                    data.add((Data)obj[1]);
                }
                dat = new ListObject(data, names);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unable to parse datatype " + (Object)((Object)datatype));
            }
        }
        ret[0] = name;
        ret[1] = dat;
        return ret;
    }

    private static ExecutionContext parseExecutionContext(String in, Program prog) {
        ExecutionContext ec = null;
        String lin = in.substring(EC_BEGIN.length(), in.length() - "".length()).trim();
        if (!lin.equals(EMPTY)) {
            LocalVariableMap vars = ProgramConverter.parseVariables(lin);
            ec = ExecutionContextFactory.createContext(false, prog);
            ec.setVariables(vars);
        }
        return ec;
    }

    private static void parseAndSetAdditionalConfigurations(String conf) {
        String[] statsFlag = conf.split(KEY_VALUE_DELIM);
        DMLScript.STATISTICS = Boolean.parseBoolean(statsFlag[1]);
    }

    private static Instruction saveReplaceThreadID(Instruction inst, String pattern, String replacement) {
        if (inst instanceof VariableCPInstruction) {
            inst.updateInstructionThreadID(pattern, replacement);
        }
        return inst;
    }

    public static String saveReplaceFilenameThreadID(String fname, String pattern, String replace) {
        int pos = fname.lastIndexOf(pattern);
        return pos < 0 ? fname : fname.substring(0, pos) + replace + fname.substring(pos + pattern.length());
    }

    private static class HierarchyAwareStringTokenizer {
        private String _str = null;
        private String _del = null;
        private int _off = -1;

        public HierarchyAwareStringTokenizer(String in, String delim) {
            this._str = in;
            this._del = delim;
            this._off = delim.length();
        }

        public boolean hasMoreTokens() {
            return this._str.length() > 0;
        }

        public String nextToken() {
            int nextDelim = HierarchyAwareStringTokenizer.determineNextSameLevelIndexOf(this._str, this._del);
            String token = null;
            if (nextDelim < 0) {
                nextDelim = this._str.length();
                this._off = 0;
            }
            token = this._str.substring(0, nextDelim);
            this._str = this._str.substring(nextDelim + this._off);
            return token;
        }

        private static int determineNextSameLevelIndexOf(String data, String pattern) {
            String tmpdata = data;
            int index = 0;
            int count = 0;
            int off = 0;
            while (true) {
                int i1 = tmpdata.indexOf(pattern);
                int i2 = tmpdata.indexOf(ProgramConverter.LEVELIN);
                int i3 = tmpdata.indexOf("\u23ac");
                if (i1 < 0) {
                    return i1;
                }
                int min = i1;
                if (i2 >= 0) {
                    min = Math.min(min, i2);
                }
                if (i3 >= 0) {
                    min = Math.min(min, i3);
                }
                if (i1 == min && count == 0) {
                    return index + i1;
                }
                if (i2 == min) {
                    ++count;
                    off = ProgramConverter.LEVELIN.length();
                } else if (i3 == min) {
                    --count;
                    off = "\u23ac".length();
                }
                index += min + off;
                tmpdata = tmpdata.substring(min + off);
            }
        }
    }
}

