/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.encode;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class EncoderPassThrough
extends Encoder {
    private static final long serialVersionUID = -8473768154646831882L;

    protected EncoderPassThrough(int[] ptCols, int clen) {
        super(ptCols, clen);
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int col = this._colList[j] - 1;
            Types.ValueType vt = in.getSchema()[col];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object val = in.get(i, col);
                out.quickSetValue(i, col, val == null || vt == Types.ValueType.STRING && val.toString().isEmpty() ? Double.NaN : UtilFunctions.objectToDouble(vt, val));
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }
}

