/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.encode;

import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.transform.TfUtils;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.transform.meta.TfMetaUtils;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class EncoderFeatureHash
extends Encoder {
    private static final long serialVersionUID = 7435806042138687342L;
    private long _K;

    public EncoderFeatureHash(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        this._colList = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, TfUtils.TfMethod.HASH.toString());
        this._K = EncoderFeatureHash.getK(parsedSpec);
    }

    private static long getK(JSONObject parsedSpec) throws JSONException {
        return parsedSpec.getLong("K");
    }

    private long getCode(String key) {
        return (long)key.hashCode() % this._K;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        if (!this.isApplicable()) {
            return out;
        }
        this.apply(in, out);
        return out;
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object okey = in.get(i, colID - 1);
                String key = okey != null ? okey.toString() : null;
                long code = this.getCode(key);
                out.quickSetValue(i, colID - 1, code >= 0L ? (double)code : Double.NaN);
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        meta.ensureAllocatedColumns(1);
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            meta.set(0, colID - 1, String.valueOf(this._K));
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._K = UtilFunctions.parseToLong(meta.get(0, colID - 1).toString());
        }
    }
}

