/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.transform.TfUtils;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.transform.encode.EncoderBin;
import org.tugraz.sysds.runtime.transform.encode.EncoderComposite;
import org.tugraz.sysds.runtime.transform.encode.EncoderDummycode;
import org.tugraz.sysds.runtime.transform.encode.EncoderFeatureHash;
import org.tugraz.sysds.runtime.transform.encode.EncoderMVImpute;
import org.tugraz.sysds.runtime.transform.encode.EncoderOmit;
import org.tugraz.sysds.runtime.transform.encode.EncoderPassThrough;
import org.tugraz.sysds.runtime.transform.encode.EncoderRecode;
import org.tugraz.sysds.runtime.transform.meta.TfMetaUtils;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class EncoderFactory {
    public static Encoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta) {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Types.ValueType.STRING), meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, int clen, FrameBlock meta) {
        Types.ValueType[] lschema = schema == null ? UtilFunctions.nCopies(clen, Types.ValueType.STRING) : schema;
        return EncoderFactory.createEncoder(spec, colnames, lschema, meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta) {
        EncoderComposite encoder = null;
        int clen = schema.length;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Encoder> lencoders = new ArrayList<Encoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.RECODE.toString())));
            List<Integer> haIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.HASH.toString())));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString())));
            List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(jSpec, colnames);
            rcIDs = new ArrayList<Integer>(CollectionUtils.subtract((Collection)CollectionUtils.union(rcIDs, (Collection)CollectionUtils.subtract(dcIDs, binIDs)), haIDs));
            ArrayList ptIDs = new ArrayList(CollectionUtils.subtract((Collection)CollectionUtils.subtract(UtilFunctions.getSeqList(1, clen, 1), (Collection)CollectionUtils.union(rcIDs, haIDs)), binIDs));
            List<Integer> oIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.OMIT.toString())));
            List<Integer> mvIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, TfUtils.TfMethod.IMPUTE.toString())));
            if (!rcIDs.isEmpty()) {
                EncoderRecode ra = new EncoderRecode(jSpec, colnames, clen);
                ra.setColList(ArrayUtils.toPrimitive((Integer[])rcIDs.toArray(new Integer[0])));
                lencoders.add(ra);
            }
            if (!haIDs.isEmpty()) {
                EncoderFeatureHash ha = new EncoderFeatureHash(jSpec, colnames, clen);
                ha.setColList(ArrayUtils.toPrimitive((Integer[])haIDs.toArray(new Integer[0])));
                lencoders.add(ha);
            }
            if (!ptIDs.isEmpty()) {
                lencoders.add(new EncoderPassThrough(ArrayUtils.toPrimitive((Integer[])ptIDs.toArray(new Integer[0])), clen));
            }
            if (!binIDs.isEmpty()) {
                lencoders.add(new EncoderBin(jSpec, colnames, schema.length));
            }
            if (!dcIDs.isEmpty()) {
                lencoders.add(new EncoderDummycode(jSpec, colnames, schema.length));
            }
            if (!oIDs.isEmpty()) {
                lencoders.add(new EncoderOmit(jSpec, colnames, schema.length));
            }
            if (!mvIDs.isEmpty()) {
                EncoderMVImpute ma = new EncoderMVImpute(jSpec, colnames, schema.length);
                ma.initRecodeIDList(rcIDs);
                lencoders.add(ma);
            }
            encoder = new EncoderComposite(lencoders);
            if (meta != null) {
                Object[] colnames2 = meta.getColumnNames();
                if (!TfMetaUtils.isIDSpec(jSpec) && colnames != null && colnames2 != null && !ArrayUtils.isEquals((Object)colnames, (Object)colnames2)) {
                    HashMap<String, Integer> colPos = EncoderFactory.getColumnPositions((String[])colnames2);
                    FrameBlock meta2 = new FrameBlock(meta.getSchema(), (String[])colnames2);
                    meta2.setNumRows(meta.getNumRows());
                    for (int i = 0; i < colnames.length; ++i) {
                        if (!colPos.containsKey(colnames[i])) {
                            throw new DMLRuntimeException("Column name not found in meta data: " + colnames[i] + " (meta: " + Arrays.toString(colnames2) + ")");
                        }
                        int pos = colPos.get(colnames[i]);
                        meta2.setColumn(i, meta.getColumn(pos));
                        meta2.setColumnMetadata(i, meta.getColumnMetadata(pos));
                    }
                    meta = meta2;
                }
                ((Encoder)encoder).initMetaData(meta);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return encoder;
    }

    private static HashMap<String, Integer> getColumnPositions(String[] colnames) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < colnames.length; ++i) {
            ret.put(colnames[i], i);
        }
        return ret;
    }
}

