/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.encode;

import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.transform.TfUtils;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.transform.meta.TfMetaUtils;

public class EncoderDummycode
extends Encoder {
    private static final long serialVersionUID = 5832130477659116489L;
    private int[] _domainSizes = null;
    private long _dummycodedLength = 0L;

    public EncoderDummycode(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        if (parsedSpec.containsKey(TfUtils.TfMethod.DUMMYCODE.toString())) {
            int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString());
            this.initColList(collist);
        }
    }

    @Override
    public int getNumCols() {
        return (int)this._dummycodedLength;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(out.getNumRows(), this.getNumCols(), out.getNonZeros());
        MatrixBlock ret = new MatrixBlock(out.getNumRows(), this.getNumCols(), sparse);
        int clen = out.getNumColumns();
        for (int i = 0; i < out.getNumRows(); ++i) {
            int idx = 0;
            int ncolID = 1;
            for (int colID = 1; colID <= clen; ++colID) {
                double val = out.quickGetValue(i, colID - 1);
                if (idx < this._colList.length && colID == this._colList[idx]) {
                    ret.appendValue(i, ncolID - 1 + (int)val - 1, 1.0);
                    ncolID += this._domainSizes[idx];
                    ++idx;
                    continue;
                }
                double ptval = out.quickGetValue(i, colID - 1);
                ret.appendValue(i, ncolID - 1, ptval);
                ++ncolID;
            }
        }
        return ret;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._domainSizes = new int[this._colList.length];
        this._dummycodedLength = this._clen;
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._domainSizes[j] = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._dummycodedLength += (long)(this._domainSizes[j] - 1);
        }
    }

    @Override
    public MatrixBlock getColMapping(FrameBlock meta, MatrixBlock out) {
        int clen = out.getNumRows();
        int idx = 0;
        int ncolID = 1;
        for (int colID = 1; colID <= clen; ++colID) {
            int start = ncolID;
            if (idx < this._colList.length && colID == this._colList[idx]) {
                ncolID = (int)((long)ncolID + meta.getColumnMetadata(colID - 1).getNumDistinct());
                ++idx;
            } else {
                ++ncolID;
            }
            out.quickSetValue(colID - 1, 0, colID);
            out.quickSetValue(colID - 1, 1, start);
            out.quickSetValue(colID - 1, 2, ncolID - 1);
        }
        return out;
    }
}

