/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.encode;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.transform.TfUtils;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.transform.meta.TfMetaUtils;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class EncoderBin
extends Encoder {
    private static final long serialVersionUID = 1917445005206076078L;
    public static final String MIN_PREFIX = "min";
    public static final String MAX_PREFIX = "max";
    public static final String NBINS_PREFIX = "nbins";
    private int[] _numBins = null;
    private double[][] _binMins = null;
    private double[][] _binMaxs = null;

    public EncoderBin(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException, IOException {
        super(null, clen);
        if (!parsedSpec.containsKey(TfUtils.TfMethod.BIN.toString())) {
            return;
        }
        List<Integer> collist = TfMetaUtils.parseBinningColIDs(parsedSpec, colnames);
        this.initColList(ArrayUtils.toPrimitive((Integer[])collist.toArray(new Integer[0])));
        boolean ids = parsedSpec.containsKey("ids") && parsedSpec.getBoolean("ids");
        JSONArray group = (JSONArray)parsedSpec.get(TfUtils.TfMethod.BIN.toString());
        this._numBins = new int[collist.size()];
        for (int i = 0; i < this._numBins.length; ++i) {
            JSONObject colspec = (JSONObject)group.get(i);
            int pos = collist.indexOf(ids ? colspec.getInt("id") : ArrayUtils.indexOf((Object[])colnames, (Object)colspec.get("name")) + 1);
            this._numBins[pos] = colspec.containsKey("numbins") ? colspec.getInt("numbins") : 1;
        }
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        this.build(in);
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int j = 0; j < this._colList.length; ++j) {
            int i;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int colID = this._colList[j];
            for (i = 0; i < in.getNumRows(); ++i) {
                double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                min = Math.min(min, inVal);
                max = Math.max(max, inVal);
            }
            this._binMins[j] = new double[this._numBins[j]];
            this._binMaxs[j] = new double[this._numBins[j]];
            for (i = 0; i < this._numBins[j]; ++i) {
                this._binMins[j][i] = min + (double)i * (max - min) / (double)this._numBins[j];
                this._binMaxs[j][i] = min + (double)(i + 1) * (max - min) / (double)this._numBins[j];
            }
        }
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                int ix = Arrays.binarySearch(this._binMaxs[j], inVal);
                int binID = (ix < 0 ? Math.abs(ix + 1) : ix) + 1;
                out.quickSetValue(i, colID - 1, binID);
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        int j;
        int maxLength = 0;
        for (j = 0; j < this._colList.length; ++j) {
            maxLength = Math.max(maxLength, this._binMaxs[j].length);
        }
        meta.ensureAllocatedColumns(maxLength);
        for (j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            meta.getColumnMetadata(colID - 1).setNumDistinct(this._numBins[j]);
            for (int i = 0; i < this._binMaxs[j].length; ++i) {
                StringBuilder sb = new StringBuilder(16);
                sb.append(this._binMins[j][i]);
                sb.append("\u00b7");
                sb.append(this._binMaxs[j][i]);
                meta.set(i, colID - 1, sb.toString());
            }
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || this._binMaxs != null) {
            return;
        }
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int nbins = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._binMins[j] = new double[nbins];
            this._binMaxs[j] = new double[nbins];
            for (int i = 0; i < nbins; ++i) {
                String[] tmp = meta.get(i, colID - 1).toString().split("\u00b7");
                this._binMins[j][i] = Double.parseDouble(tmp[0]);
                this._binMaxs[j][i] = Double.parseDouble(tmp[1]);
            }
        }
    }
}

