/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.encode;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wink.json4j.JSONArray;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public abstract class Encoder
implements Serializable {
    private static final long serialVersionUID = 2299156350718979064L;
    protected static final Log LOG = LogFactory.getLog((String)Encoder.class.getName());
    protected int _clen = -1;
    protected int[] _colList = null;

    protected Encoder(int[] colList, int clen) {
        this._colList = colList;
        this._clen = clen;
    }

    public int[] getColList() {
        return this._colList;
    }

    public void setColList(int[] colList) {
        this._colList = colList;
    }

    public int getNumCols() {
        return this._clen;
    }

    public int initColList(JSONArray attrs) {
        this._colList = new int[attrs.size()];
        for (int i = 0; i < this._colList.length; ++i) {
            this._colList[i] = UtilFunctions.toInt(attrs.get(i));
        }
        return this._colList.length;
    }

    public int initColList(int[] colList) {
        this._colList = colList;
        return this._colList.length;
    }

    public boolean isApplicable() {
        return this._colList != null && this._colList.length > 0;
    }

    public int isApplicable(int colID) {
        if (this._colList == null) {
            return -1;
        }
        int idx = Arrays.binarySearch(this._colList, colID);
        return idx >= 0 ? idx : -1;
    }

    public abstract MatrixBlock encode(FrameBlock var1, MatrixBlock var2);

    public abstract void build(FrameBlock var1);

    public abstract MatrixBlock apply(FrameBlock var1, MatrixBlock var2);

    public abstract FrameBlock getMetaData(FrameBlock var1);

    public abstract void initMetaData(FrameBlock var1);

    public MatrixBlock getColMapping(FrameBlock meta, MatrixBlock out) {
        return out;
    }
}

