/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.transform.TfUtils;
import org.tugraz.sysds.runtime.transform.decode.Decoder;
import org.tugraz.sysds.runtime.transform.decode.DecoderComposite;
import org.tugraz.sysds.runtime.transform.decode.DecoderDummycode;
import org.tugraz.sysds.runtime.transform.decode.DecoderPassThrough;
import org.tugraz.sysds.runtime.transform.decode.DecoderRecode;
import org.tugraz.sysds.runtime.transform.meta.TfMetaUtils;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class DecoderFactory {
    public static Decoder createDecoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta) {
        return DecoderFactory.createDecoder(spec, colnames, schema, meta, meta.getNumColumns());
    }

    public static Decoder createDecoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta, int clen) {
        DecoderComposite decoder = null;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Decoder> ldecoders = new ArrayList<Decoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.RECODE.toString())));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString())));
            rcIDs = new ArrayList<Integer>(CollectionUtils.union(rcIDs, dcIDs));
            int len = dcIDs.isEmpty() ? Math.min(meta.getNumColumns(), clen) : meta.getNumColumns();
            ArrayList ptIDs = new ArrayList(CollectionUtils.subtract(UtilFunctions.getSeqList(1, len, 1), rcIDs));
            if (schema == null) {
                schema = UtilFunctions.nCopies(len, Types.ValueType.STRING);
                for (Integer col : ptIDs) {
                    schema[col.intValue() - 1] = Types.ValueType.FP64;
                }
            }
            if (!dcIDs.isEmpty()) {
                ldecoders.add(new DecoderDummycode(schema, ArrayUtils.toPrimitive((Integer[])dcIDs.toArray(new Integer[0]))));
            }
            if (!rcIDs.isEmpty()) {
                ldecoders.add(new DecoderRecode(schema, !dcIDs.isEmpty(), ArrayUtils.toPrimitive((Integer[])rcIDs.toArray(new Integer[0]))));
            }
            if (!ptIDs.isEmpty()) {
                ldecoders.add(new DecoderPassThrough(schema, ArrayUtils.toPrimitive((Integer[])ptIDs.toArray(new Integer[0])), ArrayUtils.toPrimitive((Integer[])dcIDs.toArray(new Integer[0]))));
            }
            decoder = new DecoderComposite(schema, ldecoders);
            decoder.setColnames(colnames);
            ((Decoder)decoder).initMetaData(meta);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return decoder;
    }
}

