/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.matrix.operators;

import java.io.Serializable;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.runtime.functionobjects.And;
import org.tugraz.sysds.runtime.functionobjects.BitwAnd;
import org.tugraz.sysds.runtime.functionobjects.BitwOr;
import org.tugraz.sysds.runtime.functionobjects.BitwShiftL;
import org.tugraz.sysds.runtime.functionobjects.BitwShiftR;
import org.tugraz.sysds.runtime.functionobjects.BitwXor;
import org.tugraz.sysds.runtime.functionobjects.Builtin;
import org.tugraz.sysds.runtime.functionobjects.Divide;
import org.tugraz.sysds.runtime.functionobjects.Equals;
import org.tugraz.sysds.runtime.functionobjects.GreaterThan;
import org.tugraz.sysds.runtime.functionobjects.GreaterThanEquals;
import org.tugraz.sysds.runtime.functionobjects.IntegerDivide;
import org.tugraz.sysds.runtime.functionobjects.LessThan;
import org.tugraz.sysds.runtime.functionobjects.LessThanEquals;
import org.tugraz.sysds.runtime.functionobjects.Minus;
import org.tugraz.sysds.runtime.functionobjects.MinusMultiply;
import org.tugraz.sysds.runtime.functionobjects.MinusNz;
import org.tugraz.sysds.runtime.functionobjects.Modulus;
import org.tugraz.sysds.runtime.functionobjects.Multiply;
import org.tugraz.sysds.runtime.functionobjects.NotEquals;
import org.tugraz.sysds.runtime.functionobjects.Or;
import org.tugraz.sysds.runtime.functionobjects.Plus;
import org.tugraz.sysds.runtime.functionobjects.PlusMultiply;
import org.tugraz.sysds.runtime.functionobjects.Power;
import org.tugraz.sysds.runtime.functionobjects.ValueFunction;
import org.tugraz.sysds.runtime.functionobjects.Xor;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class BinaryOperator
extends Operator
implements Serializable {
    private static final long serialVersionUID = -2547950181558989209L;
    public final ValueFunction fn;

    public BinaryOperator(ValueFunction p) {
        super(p instanceof Plus || p instanceof Multiply || p instanceof Minus || p instanceof PlusMultiply || p instanceof MinusMultiply || p instanceof And || p instanceof Or || p instanceof Xor || p instanceof BitwAnd || p instanceof BitwOr || p instanceof BitwXor || p instanceof BitwShiftL || p instanceof BitwShiftR);
        this.fn = p;
    }

    public Hop.OpOp2 getBinaryOperatorOpOp2() {
        if (this.fn instanceof Plus) {
            return Hop.OpOp2.PLUS;
        }
        if (this.fn instanceof Minus) {
            return Hop.OpOp2.MINUS;
        }
        if (this.fn instanceof Multiply) {
            return Hop.OpOp2.MULT;
        }
        if (this.fn instanceof Divide) {
            return Hop.OpOp2.DIV;
        }
        if (this.fn instanceof Modulus) {
            return Hop.OpOp2.MODULUS;
        }
        if (this.fn instanceof IntegerDivide) {
            return Hop.OpOp2.INTDIV;
        }
        if (this.fn instanceof LessThan) {
            return Hop.OpOp2.LESS;
        }
        if (this.fn instanceof LessThanEquals) {
            return Hop.OpOp2.LESSEQUAL;
        }
        if (this.fn instanceof GreaterThan) {
            return Hop.OpOp2.GREATER;
        }
        if (this.fn instanceof GreaterThanEquals) {
            return Hop.OpOp2.GREATEREQUAL;
        }
        if (this.fn instanceof Equals) {
            return Hop.OpOp2.EQUAL;
        }
        if (this.fn instanceof NotEquals) {
            return Hop.OpOp2.NOTEQUAL;
        }
        if (this.fn instanceof And) {
            return Hop.OpOp2.AND;
        }
        if (this.fn instanceof Or) {
            return Hop.OpOp2.OR;
        }
        if (this.fn instanceof Xor) {
            return Hop.OpOp2.XOR;
        }
        if (this.fn instanceof BitwAnd) {
            return Hop.OpOp2.BITWAND;
        }
        if (this.fn instanceof BitwOr) {
            return Hop.OpOp2.BITWOR;
        }
        if (this.fn instanceof BitwXor) {
            return Hop.OpOp2.BITWXOR;
        }
        if (this.fn instanceof BitwShiftL) {
            return Hop.OpOp2.BITWSHIFTL;
        }
        if (this.fn instanceof BitwShiftR) {
            return Hop.OpOp2.BITWSHIFTR;
        }
        if (this.fn instanceof Power) {
            return Hop.OpOp2.POW;
        }
        if (this.fn instanceof MinusNz) {
            return Hop.OpOp2.MINUS_NZ;
        }
        if (this.fn instanceof Builtin) {
            Builtin.BuiltinCode bfc = ((Builtin)this.fn).getBuiltinCode();
            if (bfc == Builtin.BuiltinCode.MIN) {
                return Hop.OpOp2.MIN;
            }
            if (bfc == Builtin.BuiltinCode.MAX) {
                return Hop.OpOp2.MAX;
            }
            if (bfc == Builtin.BuiltinCode.LOG) {
                return Hop.OpOp2.LOG;
            }
            if (bfc == Builtin.BuiltinCode.LOG_NZ) {
                return Hop.OpOp2.LOG_NZ;
            }
        }
        return Hop.OpOp2.INVALID;
    }

    public String toString() {
        return "BinaryOperator(" + this.fn.getClass().getSimpleName() + ")";
    }
}

