/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.matrix.data;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.data.TensorIndexes;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixCell;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;

public class OutputInfo
implements Serializable {
    private static final long serialVersionUID = -3115943514779675817L;
    public Class<? extends OutputFormat> outputFormatClass;
    public Class<? extends Writable> outputKeyClass;
    public Class<? extends Writable> outputValueClass;
    public static final OutputInfo TextCellOutputInfo = new OutputInfo(TextOutputFormat.class, NullWritable.class, Text.class);
    public static final OutputInfo MatrixMarketOutputInfo = new OutputInfo(TextOutputFormat.class, NullWritable.class, Text.class);
    public static final OutputInfo BinaryCellOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, MatrixIndexes.class, MatrixCell.class);
    public static final OutputInfo BinaryBlockOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, MatrixIndexes.class, MatrixBlock.class);
    public static final OutputInfo BinaryTensorBlockOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, TensorIndexes.class, TensorBlock.class);
    public static final OutputInfo BinaryBlockFrameOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, LongWritable.class, FrameBlock.class);
    public static final OutputInfo CSVOutputInfo = null;
    public static final OutputInfo LIBSVMOutputInfo = new OutputInfo(TextOutputFormat.class, NullWritable.class, Text.class);

    public OutputInfo(Class<? extends OutputFormat> formatCls, Class<? extends Writable> keyCls, Class<? extends Writable> valueCls) {
        this.outputFormatClass = formatCls;
        this.outputKeyClass = keyCls;
        this.outputValueClass = valueCls;
    }

    public static InputInfo getMatchingInputInfo(OutputInfo oi) {
        if (oi == BinaryBlockOutputInfo) {
            return InputInfo.BinaryBlockInputInfo;
        }
        if (oi == BinaryTensorBlockOutputInfo) {
            return InputInfo.BinaryTensorBlockInputInfo;
        }
        if (oi == MatrixMarketOutputInfo) {
            return InputInfo.MatrixMarketInputInfo;
        }
        if (oi == BinaryCellOutputInfo) {
            return InputInfo.BinaryCellInputInfo;
        }
        if (oi == TextCellOutputInfo) {
            return InputInfo.TextCellInputInfo;
        }
        if (oi == CSVOutputInfo) {
            return InputInfo.CSVInputInfo;
        }
        if (oi == LIBSVMOutputInfo) {
            return InputInfo.LIBSVMInputInfo;
        }
        throw new DMLRuntimeException("Unrecognized output info: " + oi);
    }

    public static OutputInfo stringToOutputInfo(String str) {
        if (str.equalsIgnoreCase("textcell")) {
            return TextCellOutputInfo;
        }
        if (str.equalsIgnoreCase("text")) {
            return TextCellOutputInfo;
        }
        if (str.equalsIgnoreCase("matrixmarket")) {
            return MatrixMarketOutputInfo;
        }
        if (str.equalsIgnoreCase("mm")) {
            return MatrixMarketOutputInfo;
        }
        if (str.equalsIgnoreCase("binarycell")) {
            return BinaryCellOutputInfo;
        }
        if (str.equalsIgnoreCase("binaryblock")) {
            return BinaryBlockOutputInfo;
        }
        if (str.equalsIgnoreCase("binary")) {
            return BinaryBlockOutputInfo;
        }
        if (str.equalsIgnoreCase("binarytensorblock")) {
            return BinaryTensorBlockOutputInfo;
        }
        if (str.equalsIgnoreCase("csv")) {
            return CSVOutputInfo;
        }
        if (str.equalsIgnoreCase("libsvm")) {
            return LIBSVMOutputInfo;
        }
        return null;
    }

    public static String outputInfoToString(OutputInfo oi) {
        if (oi == TextCellOutputInfo) {
            return "textcell";
        }
        if (oi == MatrixMarketOutputInfo) {
            return "matrixmarket";
        }
        if (oi == BinaryCellOutputInfo) {
            return "binarycell";
        }
        if (oi == BinaryBlockOutputInfo) {
            return "binaryblock";
        }
        if (oi == BinaryTensorBlockOutputInfo) {
            return "binarytensorblock";
        }
        if (oi == CSVOutputInfo) {
            return "csv";
        }
        if (oi == LIBSVMOutputInfo) {
            return "libsvm";
        }
        throw new DMLRuntimeException("Unrecognized outputInfo: " + oi);
    }

    public static String outputInfoToStringExternal(OutputInfo oinfo) {
        if (oinfo == TextCellOutputInfo) {
            return "text";
        }
        if (oinfo == MatrixMarketOutputInfo) {
            return "mm";
        }
        if (oinfo == CSVOutputInfo) {
            return "csv";
        }
        if (oinfo == LIBSVMOutputInfo) {
            return "libsvm";
        }
        if (oinfo == BinaryBlockOutputInfo || oinfo == BinaryCellOutputInfo || oinfo == BinaryTensorBlockOutputInfo) {
            return "binary";
        }
        return "specialized";
    }

    public static OutputInfo outputInfoFromStringExternal(String format) {
        if (format.equalsIgnoreCase("text")) {
            return TextCellOutputInfo;
        }
        if (format.equalsIgnoreCase("binary")) {
            return BinaryBlockOutputInfo;
        }
        if (format.equalsIgnoreCase("mm")) {
            return MatrixMarketOutputInfo;
        }
        if (format.equalsIgnoreCase("libsvm")) {
            return LIBSVMOutputInfo;
        }
        if (format.equalsIgnoreCase("csv")) {
            return CSVOutputInfo;
        }
        throw new DMLRuntimeException("Invalid external file format: " + format);
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.outputFormatClass.hashCode(), this.outputKeyClass.hashCode(), this.outputValueClass.hashCode()});
    }

    public boolean equals(Object o) {
        if (!(o instanceof OutputInfo)) {
            return false;
        }
        OutputInfo that = (OutputInfo)o;
        return this.outputFormatClass == that.outputFormatClass && this.outputKeyClass == that.outputKeyClass && this.outputValueClass == that.outputValueClass;
    }
}

