/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.matrix.data;

import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.matrix.data.DnnParameters;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixDNNHelper;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public class LibMatrixDNNRotate180 {

    private static class SparseRotate180Worker
    implements Rotate180Worker {
        private final MatrixBlock in;
        private final MatrixBlock out;
        private final DnnParameters params;
        private final boolean trans;

        public SparseRotate180Worker(MatrixBlock input, MatrixBlock output, DnnParameters params, boolean trans) {
            this.in = input;
            this.out = output;
            this.params = params;
            this.trans = trans;
        }

        @Override
        public void execute(int inputN, int outputN) {
            this.out.reset();
            SparseBlock sblock = this.in.sparseBlock;
            if (sblock == null || sblock.isEmpty(inputN)) {
                return;
            }
            LibMatrixDNNHelper.CellIndex3 ix = new LibMatrixDNNHelper.CellIndex3();
            int outputOffset = outputN * this.params.P * this.params.Q;
            int apos = sblock.pos(inputN);
            int alen = sblock.size(inputN);
            int[] aix = sblock.indexes(inputN);
            double[] avals = sblock.values(inputN);
            for (int j = apos; j < apos + alen; ++j) {
                ix = LibMatrixDNNHelper.computeTensorIndexes(aix[j], this.params.P, this.params.Q, ix);
                if (this.trans) {
                    this.out.appendValue(ix.ix1, outputOffset + ix.ix2 * this.params.Q + ix.ix3, avals[j]);
                    continue;
                }
                this.out.appendValue(outputOffset + ix.ix2 * this.params.Q + ix.ix3, ix.ix1, avals[j]);
            }
        }
    }

    private static class DenseRotate180Worker
    implements Rotate180Worker {
        private final DenseBlock in;
        private final DenseBlock out;
        private final DnnParameters params;

        public DenseRotate180Worker(MatrixBlock input, MatrixBlock output, DnnParameters params) {
            this.in = input.getDenseBlock();
            this.out = output.getDenseBlock();
            this.params = params;
        }

        @Override
        public void execute(int inputN, int outputN) {
            double[] avals = this.in.values(inputN);
            double[] cvals = this.out.values(outputN);
            int aix = this.in.pos(inputN);
            int cix = this.out.pos(outputN);
            int K = this.params.K;
            int P = this.params.P;
            int Q = this.params.Q;
            for (int k = 0; k < K; ++k) {
                for (int p = 0; p < P; ++p) {
                    for (int q = 0; q < Q; ++q) {
                        cvals[cix + p * Q * K + q * K + k] = avals[aix + k * P * Q + p * Q + q];
                    }
                }
            }
        }
    }

    public static interface Rotate180Worker {
        public void execute(int var1, int var2);

        public static Rotate180Worker getWorker(MatrixBlock in, MatrixBlock out, DnnParameters params, boolean zeroOutSparseOutput, boolean trans) {
            return in.isInSparseFormat() ? new SparseRotate180Worker(in, out, params, trans) : new DenseRotate180Worker(in, out, params);
        }
    }
}

