/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.matrix.data;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixReorg;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.DataConverter;

public class LibCommonsMath {
    private LibCommonsMath() {
    }

    public static boolean isSupportedUnaryOperation(String opcode) {
        return opcode.equals("inverse") || opcode.equals("cholesky");
    }

    public static boolean isSupportedMultiReturnOperation(String opcode) {
        return opcode.equals("qr") || opcode.equals("lu") || opcode.equals("eigen") || opcode.equals("svd");
    }

    public static boolean isSupportedMatrixMatrixOperation(String opcode) {
        return opcode.equals("solve");
    }

    public static MatrixBlock unaryOperations(MatrixBlock inj, String opcode) {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(inj);
        if (opcode.equals("inverse")) {
            return LibCommonsMath.computeMatrixInverse(matrixInput);
        }
        if (opcode.equals("cholesky")) {
            return LibCommonsMath.computeCholesky(matrixInput);
        }
        return null;
    }

    public static MatrixBlock[] multiReturnOperations(MatrixBlock in, String opcode) {
        if (opcode.equals("qr")) {
            return LibCommonsMath.computeQR(in);
        }
        if (opcode.equals("lu")) {
            return LibCommonsMath.computeLU(in);
        }
        if (opcode.equals("eigen")) {
            return LibCommonsMath.computeEigen(in);
        }
        if (opcode.equals("svd")) {
            return LibCommonsMath.computeSvd(in);
        }
        return null;
    }

    public static MatrixBlock matrixMatrixOperations(MatrixBlock in1, MatrixBlock in2, String opcode) {
        if (opcode.equals("solve")) {
            if (in1.getNumRows() != in1.getNumColumns()) {
                throw new DMLRuntimeException("The A matrix, in solve(A,b) should have squared dimensions.");
            }
            return LibCommonsMath.computeSolve(in1, in2);
        }
        return null;
    }

    private static MatrixBlock computeSolve(MatrixBlock in1, MatrixBlock in2) {
        BlockRealMatrix matrixInput = DataConverter.convertToBlockRealMatrix(in1);
        BlockRealMatrix vectorInput = DataConverter.convertToBlockRealMatrix(in2);
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)matrixInput);
        DecompositionSolver solver = qrdecompose.getSolver();
        RealMatrix solutionMatrix = solver.solve((RealMatrix)vectorInput);
        return DataConverter.convertToMatrixBlock(solutionMatrix);
    }

    private static MatrixBlock[] computeQR(MatrixBlock in) {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)matrixInput);
        RealMatrix H = qrdecompose.getH();
        RealMatrix R = qrdecompose.getR();
        MatrixBlock mbH = DataConverter.convertToMatrixBlock(H.getData());
        MatrixBlock mbR = DataConverter.convertToMatrixBlock(R.getData());
        return new MatrixBlock[]{mbH, mbR};
    }

    private static MatrixBlock[] computeLU(MatrixBlock in) {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("LU Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        LUDecomposition ludecompose = new LUDecomposition((RealMatrix)matrixInput);
        RealMatrix P = ludecompose.getP();
        RealMatrix L = ludecompose.getL();
        RealMatrix U = ludecompose.getU();
        MatrixBlock mbP = DataConverter.convertToMatrixBlock(P.getData());
        MatrixBlock mbL = DataConverter.convertToMatrixBlock(L.getData());
        MatrixBlock mbU = DataConverter.convertToMatrixBlock(U.getData());
        return new MatrixBlock[]{mbP, mbL, mbU};
    }

    private static MatrixBlock[] computeEigen(MatrixBlock in) {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("Eigen Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        EigenDecomposition eigendecompose = new EigenDecomposition((RealMatrix)matrixInput);
        RealMatrix eVectorsMatrix = eigendecompose.getV();
        double[][] eVectors = eVectorsMatrix.getData();
        double[] eValues = eigendecompose.getRealEigenvalues();
        int n = eValues.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int k = i;
            double p = eValues[i];
            for (j = i + 1; j < n; ++j) {
                if (!(eValues[j] < p)) continue;
                k = j;
                p = eValues[j];
            }
            if (k == i) continue;
            eValues[k] = eValues[i];
            eValues[i] = p;
            for (j = 0; j < n; ++j) {
                p = eVectors[j][i];
                eVectors[j][i] = eVectors[j][k];
                eVectors[j][k] = p;
            }
        }
        MatrixBlock mbValues = DataConverter.convertToMatrixBlock(eValues, true);
        MatrixBlock mbVectors = DataConverter.convertToMatrixBlock(eVectors);
        return new MatrixBlock[]{mbValues, mbVectors};
    }

    private static MatrixBlock[] computeSvd(MatrixBlock in) {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)matrixInput);
        double[] sigma = svd.getSingularValues();
        RealMatrix u = svd.getU();
        RealMatrix v = svd.getV();
        MatrixBlock U = DataConverter.convertToMatrixBlock(u.getData());
        MatrixBlock Sigma = DataConverter.convertToMatrixBlock(sigma, true);
        Sigma = LibMatrixReorg.diag(Sigma, new MatrixBlock(Sigma.rlen, Sigma.rlen, true));
        MatrixBlock V = DataConverter.convertToMatrixBlock(v.getData());
        return new MatrixBlock[]{U, Sigma, V};
    }

    private static MatrixBlock computeMatrixInverse(Array2DRowRealMatrix in) {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Input to inv() must be square matrix -- given: a " + in.getRowDimension() + "x" + in.getColumnDimension() + " matrix.");
        }
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)in);
        DecompositionSolver solver = qrdecompose.getSolver();
        RealMatrix inverseMatrix = solver.getInverse();
        return DataConverter.convertToMatrixBlock(inverseMatrix.getData());
    }

    private static MatrixBlock computeCholesky(Array2DRowRealMatrix in) {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Input to cholesky() must be square matrix -- given: a " + in.getRowDimension() + "x" + in.getColumnDimension() + " matrix.");
        }
        CholeskyDecomposition cholesky = new CholeskyDecomposition((RealMatrix)in, 1.0E-14, 1.0E-10);
        RealMatrix rmL = cholesky.getL();
        return DataConverter.convertToMatrixBlock(rmL.getData());
    }
}

