/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.matrix.data;

import java.io.Serializable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.data.TensorIndexes;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixCell;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.MetaData;

public class InputInfo
implements Serializable {
    private static final long serialVersionUID = 7059677437144672023L;
    public Class<? extends InputFormat> inputFormatClass;
    public Class<? extends Writable> inputKeyClass;
    public Class<? extends Writable> inputValueClass;
    public MetaData metadata = null;
    public static final InputInfo TextCellInputInfo = new InputInfo(TextInputFormat.class, LongWritable.class, Text.class);
    public static final InputInfo MatrixMarketInputInfo = new InputInfo(TextInputFormat.class, LongWritable.class, Text.class);
    public static final InputInfo BinaryCellInputInfo = new InputInfo(SequenceFileInputFormat.class, MatrixIndexes.class, MatrixCell.class);
    public static final InputInfo BinaryBlockInputInfo = new InputInfo(SequenceFileInputFormat.class, MatrixIndexes.class, MatrixBlock.class);
    public static final InputInfo BinaryTensorBlockInputInfo = new InputInfo(SequenceFileInputFormat.class, TensorIndexes.class, TensorBlock.class);
    public static final InputInfo BinaryBlockFrameInputInfo = new InputInfo(SequenceFileInputFormat.class, LongWritable.class, FrameBlock.class);
    public static final InputInfo CSVInputInfo = new InputInfo(TextInputFormat.class, LongWritable.class, Text.class);
    public static final InputInfo LIBSVMInputInfo = new InputInfo(TextInputFormat.class, LongWritable.class, Text.class);

    public InputInfo(Class<? extends InputFormat> formatCls, Class<? extends Writable> keyCls, Class<? extends Writable> valueCls) {
        this.inputFormatClass = formatCls;
        this.inputKeyClass = keyCls;
        this.inputValueClass = valueCls;
    }

    public void setMetaData(MetaData md) {
        this.metadata = md;
    }

    public boolean isTextIJV() {
        return this == TextCellInputInfo || this == MatrixMarketInputInfo;
    }

    public static OutputInfo getMatchingOutputInfo(InputInfo ii) {
        if (ii == BinaryBlockInputInfo) {
            return OutputInfo.BinaryBlockOutputInfo;
        }
        if (ii == BinaryTensorBlockInputInfo) {
            return OutputInfo.BinaryTensorBlockOutputInfo;
        }
        if (ii == MatrixMarketInputInfo) {
            return OutputInfo.MatrixMarketOutputInfo;
        }
        if (ii == BinaryCellInputInfo) {
            return OutputInfo.BinaryCellOutputInfo;
        }
        if (ii == TextCellInputInfo) {
            return OutputInfo.TextCellOutputInfo;
        }
        if (ii == CSVInputInfo) {
            return OutputInfo.CSVOutputInfo;
        }
        if (ii == LIBSVMInputInfo) {
            return OutputInfo.LIBSVMOutputInfo;
        }
        throw new DMLRuntimeException("Unrecognized output info: " + ii);
    }

    public static InputInfo stringToInputInfo(String str) {
        if (str.equalsIgnoreCase("textcell")) {
            return TextCellInputInfo;
        }
        if (str.equalsIgnoreCase("matrixmarket")) {
            return MatrixMarketInputInfo;
        }
        if (str.equalsIgnoreCase("binarycell")) {
            return BinaryCellInputInfo;
        }
        if (str.equalsIgnoreCase("binaryblock")) {
            return BinaryBlockInputInfo;
        }
        if (str.equalsIgnoreCase("binarytensorblock")) {
            return BinaryTensorBlockInputInfo;
        }
        if (str.equalsIgnoreCase("csv")) {
            return CSVInputInfo;
        }
        if (str.equalsIgnoreCase("libsvm")) {
            return LIBSVMInputInfo;
        }
        return null;
    }

    public static InputInfo stringExternalToInputInfo(String str) {
        if ("text".equals(str)) {
            return TextCellInputInfo;
        }
        if ("mm".equals(str)) {
            return MatrixMarketInputInfo;
        }
        if ("csv".equals(str)) {
            return CSVInputInfo;
        }
        if ("libsvm".equals(str)) {
            return LIBSVMInputInfo;
        }
        if ("binary".equals(str)) {
            return BinaryBlockInputInfo;
        }
        return null;
    }

    public static String inputInfoToString(InputInfo ii) {
        if (ii == TextCellInputInfo) {
            return "textcell";
        }
        if (ii == BinaryCellInputInfo) {
            return "binarycell";
        }
        if (ii == BinaryBlockInputInfo) {
            return "binaryblock";
        }
        if (ii == BinaryTensorBlockInputInfo) {
            return "binarytensorblock";
        }
        if (ii == MatrixMarketInputInfo) {
            return "matrixmarket";
        }
        if (ii == CSVInputInfo) {
            return "csv";
        }
        if (ii == LIBSVMInputInfo) {
            return "libsvm";
        }
        throw new DMLRuntimeException("Unrecognized inputInfo: " + ii);
    }
}

