/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tugraz.sysds.parser.ParseException;

public class LineageTokenizer {
    private List<TokenInfo> _tokenInfos = new ArrayList<TokenInfo>();

    public void add(String regex, String key) {
        this._tokenInfos.add(new TokenInfo(Pattern.compile("^(" + regex + ")"), key));
    }

    public void add(String regex) {
        this._tokenInfos.add(new TokenInfo(Pattern.compile("^(" + regex + ")"), ""));
    }

    public Map<String, String> tokenize(String str) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (TokenInfo info : this._tokenInfos) {
            Matcher m = info.regex.matcher(str);
            if (!m.find()) continue;
            String tok = m.group().trim();
            if (!info.key.isEmpty()) {
                tokens.put(info.key, tok);
            }
            str = m.replaceFirst("");
        }
        if (!str.isEmpty()) {
            throw new ParseException("Unexpected character in input: " + str);
        }
        return tokens;
    }

    private class TokenInfo {
        public final Pattern regex;
        public final String key;

        public TokenInfo(Pattern regex, String key) {
            this.regex = regex;
            this.key = key;
        }
    }
}

