/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.hops.BinaryOp;
import org.tugraz.sysds.hops.DataOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.IndexingOp;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.NaryOp;
import org.tugraz.sysds.hops.ParameterizedBuiltinOp;
import org.tugraz.sysds.hops.ReorgOp;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.tugraz.sysds.runtime.lineage.LineageCache;
import org.tugraz.sysds.runtime.lineage.LineageCacheConfig;
import org.tugraz.sysds.runtime.lineage.LineageCacheStatistics;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.meta.MetaData;
import org.tugraz.sysds.utils.Explain;

public class LineageRewriteReuse {
    private static final String LR_VAR = "__lrwrt";
    private static BasicProgramBlock _lrPB = null;
    private static ExecutionContext _lrEC = null;
    private static final Log LOG = LogFactory.getLog((String)LineageRewriteReuse.class.getName());

    public static boolean executeRewrites(Instruction curr, ExecutionContext ec) {
        ExecutionContext lrwec = LineageRewriteReuse.getExecutionContext();
        Explain.ExplainType et = DMLScript.EXPLAIN;
        DMLScript.EXPLAIN = Explain.ExplainType.NONE;
        ArrayList<Instruction> newInst = LineageRewriteReuse.rewriteTsmmCbind(curr, ec, lrwec);
        newInst = newInst == null ? LineageRewriteReuse.rewriteTsmm2Cbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteTsmmRbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteMatMulRbindLeft(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteMatMulCbindRight(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteElementMulRbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteElementMulCbind(curr, ec, lrwec) : newInst;
        ArrayList<Instruction> arrayList = newInst = newInst == null ? LineageRewriteReuse.rewriteAggregateCbind(curr, ec, lrwec) : newInst;
        if (newInst == null) {
            return false;
        }
        LineageRewriteReuse.executeInst(newInst, lrwec);
        ec.setVariable(((ComputationCPInstruction)curr).output.getName(), lrwec.getVariable(LR_VAR));
        LineageCache.put(curr, ec);
        DMLScript.EXPLAIN = et;
        return true;
    }

    private static ArrayList<Instruction> rewriteTsmmCbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastCol;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmmCbind(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        IndexingOp oldMatrix = HopRewriteUtils.createIndexingOp(newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(1L), new LiteralOp(mo.getNumColumns() - 1L));
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastCol = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastCol = HopRewriteUtils.createIndexingOp(newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()));
        }
        ReorgOp tOldM = HopRewriteUtils.createTranspose(oldMatrix);
        AggBinaryOp topRight = HopRewriteUtils.createMatrixMultiply(tOldM, lastCol);
        ReorgOp tLastCol = HopRewriteUtils.createTranspose(lastCol);
        AggBinaryOp bottomLeft = HopRewriteUtils.createMatrixMultiply(tLastCol, oldMatrix);
        AggBinaryOp bottomRight = HopRewriteUtils.createMatrixMultiply(tLastCol, lastCol);
        BinaryOp rowOne = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)topRight, Hop.OpOp2.CBIND);
        BinaryOp rowTwo = HopRewriteUtils.createBinary((Hop)bottomLeft, (Hop)bottomRight, Hop.OpOp2.CBIND);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)rowOne, (Hop)rowTwo, Hop.OpOp2.RBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        LOG.debug((Object)"LINEAGE REWRITE rewriteTsmmCbind APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteTsmmRbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastRow;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmmRbind(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastRow = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastRow = HopRewriteUtils.createIndexingOp(newMatrix, new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumRows()), new LiteralOp(1L), new LiteralOp(mo.getNumColumns()));
        }
        ReorgOp tlastRow = HopRewriteUtils.createTranspose(lastRow);
        AggBinaryOp tsmm_lr = HopRewriteUtils.createMatrixMultiply(tlastRow, lastRow);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)tsmm_lr, Hop.OpOp2.PLUS);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteTsmmRbind APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteTsmm2Cbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastCol;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmm2Cbind(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        MatrixObject newmo = LineageRewriteReuse.convMBtoMO(cachedEntry);
        lrwec.setVariable("cachedEntry", newmo);
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastCol = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastCol = HopRewriteUtils.createIndexingOp(newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumColumns() - 1L), new LiteralOp(mo.getNumColumns() - 1L));
        }
        ReorgOp tlastCol = HopRewriteUtils.createTranspose(lastCol);
        AggBinaryOp newCol = HopRewriteUtils.createMatrixMultiply(tlastCol, newMatrix);
        ReorgOp tnewCol = HopRewriteUtils.createTranspose(newCol);
        IndexingOp topLeft = HopRewriteUtils.createIndexingOp(lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 1L), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 1L));
        IndexingOp topRight = HopRewriteUtils.createIndexingOp(lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 1L), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp bottomLeft = HopRewriteUtils.createIndexingOp(lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 1L));
        IndexingOp bottomRight = HopRewriteUtils.createIndexingOp(lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp topCol = HopRewriteUtils.createIndexingOp(tnewCol, new LiteralOp(1L), new LiteralOp(mo.getNumColumns() - 2L), new LiteralOp(1L), new LiteralOp(1L));
        IndexingOp bottomCol = HopRewriteUtils.createIndexingOp(tnewCol, new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()), new LiteralOp(1L), new LiteralOp(1L));
        NaryOp rowOne = HopRewriteUtils.createNary(Types.OpOpN.CBIND, topLeft, topCol, topRight);
        NaryOp rowTwo = HopRewriteUtils.createNary(Types.OpOpN.CBIND, bottomLeft, bottomCol, bottomRight);
        NaryOp lrwHop = HopRewriteUtils.createNary(Types.OpOpN.RBIND, rowOne, newCol, rowTwo);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteTsmm2Cbind APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteMatMulRbindLeft(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isMatMulRbindLeft(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("leftMatrix", moL);
        DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
        MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
        lrwec.setVariable("rightMatrix", moR);
        DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            DataOp dataOp = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        }
        IndexingOp lastRow = HopRewriteUtils.createIndexingOp(leftMatrix, new LiteralOp(moL.getNumRows()), new LiteralOp(moL.getNumRows()), new LiteralOp(1L), new LiteralOp(moL.getNumColumns()));
        AggBinaryOp rowTwo = HopRewriteUtils.createMatrixMultiply(lastRow, rightMatrix);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Hop.OpOp2.RBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteMetMulRbindLeft APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteMatMulCbindRight(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isMatMulCbindRight(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("leftMatrix", moL);
        DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
        MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
        lrwec.setVariable("rightMatrix", moR);
        DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
        if (inCache.containsKey("deltaY")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaY");
            lrwec.setVariable("deltaY", LineageRewriteReuse.convMBtoMO(cachedRI));
            DataOp dataOp = HopRewriteUtils.createTransientRead("deltaY", cachedRI);
        }
        IndexingOp lastCol = HopRewriteUtils.createIndexingOp(rightMatrix, new LiteralOp(1L), new LiteralOp(moR.getNumRows()), new LiteralOp(moR.getNumColumns()), new LiteralOp(moR.getNumColumns()));
        AggBinaryOp rowTwo = HopRewriteUtils.createMatrixMultiply(leftMatrix, lastCol);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Hop.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteMatMulCbindRight APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteElementMulRbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastRowR;
        Hop lastRowL;
        MatrixBlock cachedRI;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isElementMulRbind(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        if (inCache.containsKey("deltaX")) {
            cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastRowL = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
            lrwec.setVariable("leftMatrix", moL);
            DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
            lastRowL = HopRewriteUtils.createIndexingOp(leftMatrix, new LiteralOp(moL.getNumRows()), new LiteralOp(moL.getNumRows()), new LiteralOp(1L), new LiteralOp(moL.getNumColumns()));
        }
        if (inCache.containsKey("deltaY")) {
            cachedRI = (MatrixBlock)inCache.get("deltaY");
            lrwec.setVariable("deltaY", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastRowR = HopRewriteUtils.createTransientRead("deltaY", cachedRI);
        } else {
            MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
            lrwec.setVariable("rightMatrix", moR);
            DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
            lastRowR = HopRewriteUtils.createIndexingOp(rightMatrix, new LiteralOp(moR.getNumRows()), new LiteralOp(moR.getNumRows()), new LiteralOp(1L), new LiteralOp(moR.getNumColumns()));
        }
        BinaryOp rowTwo = HopRewriteUtils.createBinary(lastRowL, lastRowR, Hop.OpOp2.MULT);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Hop.OpOp2.RBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteElementMulRbind APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteElementMulCbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastColR;
        Hop lastColL;
        MatrixBlock cachedRI;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isElementMulCbind(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        if (inCache.containsKey("deltaX")) {
            cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastColL = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
            lrwec.setVariable("leftMatrix", moL);
            DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
            lastColL = HopRewriteUtils.createIndexingOp(leftMatrix, new LiteralOp(1L), new LiteralOp(moL.getNumRows()), new LiteralOp(moL.getNumColumns()), new LiteralOp(moL.getNumColumns()));
        }
        if (inCache.containsKey("deltaY")) {
            cachedRI = (MatrixBlock)inCache.get("deltaY");
            lrwec.setVariable("deltaY", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastColR = HopRewriteUtils.createTransientRead("deltaY", cachedRI);
        } else {
            MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
            lrwec.setVariable("rightMatrix", moR);
            DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
            lastColR = HopRewriteUtils.createIndexingOp(rightMatrix, new LiteralOp(1L), new LiteralOp(moR.getNumRows()), new LiteralOp(moR.getNumColumns()), new LiteralOp(moR.getNumColumns()));
        }
        BinaryOp rowTwo = HopRewriteUtils.createBinary(lastColL, lastColR, Hop.OpOp2.MULT);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Hop.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteElementMulCbind APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteAggregateCbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastCol;
        int ngroups;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isAggCbind(curr, ec, inCache)) {
            return null;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.convMBtoMO(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        HashMap<String, String> params = ((ParameterizedBuiltinCPInstruction)curr).getParameterMap();
        MatrixObject mo = ec.getMatrixObject(params.get("target"));
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        MatrixObject moG = ec.getMatrixObject(params.get("groups"));
        lrwec.setVariable("groups", moG);
        DataOp groups = HopRewriteUtils.createTransientRead("groups", moG);
        String fn = params.get("fn");
        int n = ngroups = params.get("ngroups") != null ? (int)Double.parseDouble(params.get("ngroups")) : -1;
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.convMBtoMO(cachedRI));
            lastCol = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastCol = HopRewriteUtils.createIndexingOp(newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()));
        }
        LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
        args.put("target", lastCol);
        args.put("groups", groups);
        args.put("fn", new LiteralOp(fn));
        if (ngroups != -1) {
            args.put("ngroups", new LiteralOp(ngroups));
        }
        ParameterizedBuiltinOp rowTwo = HopRewriteUtils.createParameterizedBuiltinOp(newMatrix, args, Types.ParamBuiltinOp.GROUPEDAGG);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Hop.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        LOG.debug((Object)"LINEAGE REWRITE rewriteElementMulCbind APPLIED");
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewriteTime(System.nanoTime() - t0);
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static boolean isTsmmCbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        LineageItem item = items[0];
        for (LineageItem source : item.getInputs()) {
            if (!source.getOpcode().equalsIgnoreCase("cbind")) continue;
            LineageItem input1 = source.getInputs()[0];
            LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{input1});
            if (LineageCache.probe(tmp)) {
                inCache.put("lastMatrix", LineageCache.get(tmp));
            }
            if (!LineageCache.probe(source.getInputs()[1])) continue;
            inCache.put("deltaX", LineageCache.get(source.getInputs()[1]));
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isTsmmRbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        LineageItem item = items[0];
        for (LineageItem source : item.getInputs()) {
            if (!source.getOpcode().equalsIgnoreCase("rbind")) continue;
            LineageItem input1 = source.getInputs()[0];
            LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{input1});
            if (LineageCache.probe(tmp)) {
                inCache.put("lastMatrix", LineageCache.get(tmp));
            }
            if (!LineageCache.probe(source.getInputs()[1])) continue;
            inCache.put("deltaX", LineageCache.get(source.getInputs()[1]));
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isTsmm2Cbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        LineageItem item = items[0];
        for (LineageItem source : item.getInputs()) {
            LineageItem input;
            if (!source.getOpcode().equalsIgnoreCase("cbind") || !(input = source.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind")) continue;
            LineageItem L2appin1 = input.getInputs()[0];
            LineageItem tmp = new LineageItem("comb", "cbind", new LineageItem[]{L2appin1, source.getInputs()[1]});
            LineageItem toProbe = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{tmp});
            if (LineageCache.probe(toProbe)) {
                inCache.put("lastMatrix", LineageCache.get(toProbe));
            }
            if (!LineageCache.probe(input.getInputs()[1])) continue;
            inCache.put("deltaX", LineageCache.get(input.getInputs()[1]));
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isMatMulRbindLeft(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        if (curr.getOpcode().equalsIgnoreCase("ba+*")) {
            LineageItem left = items[0].getInputs()[0];
            LineageItem right = items[0].getInputs()[1];
            if (left.getOpcode().equalsIgnoreCase("rbind")) {
                LineageItem leftSource = left.getInputs()[0];
                LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{leftSource, right});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.get(tmp));
                }
                if (LineageCache.probe(left.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.get(left.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isMatMulCbindRight(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        if (curr.getOpcode().equalsIgnoreCase("ba+*")) {
            LineageItem left = items[0].getInputs()[0];
            LineageItem right = items[0].getInputs()[1];
            if (right.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem rightSource = right.getInputs()[0];
                LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{left, rightSource});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.get(tmp));
                }
                if (LineageCache.probe(right.getInputs()[1])) {
                    inCache.put("deltaY", LineageCache.get(right.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isElementMulRbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        if (curr.getOpcode().equalsIgnoreCase("*")) {
            LineageItem left = items[0].getInputs()[0];
            LineageItem right = items[0].getInputs()[1];
            if (left.getOpcode().equalsIgnoreCase("rbind") && right.getOpcode().equalsIgnoreCase("rbind")) {
                LineageItem leftSource = left.getInputs()[0];
                LineageItem rightSource = right.getInputs()[0];
                LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{leftSource, rightSource});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.get(tmp));
                }
                if (LineageCache.probe(left.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.get(left.getInputs()[1]));
                }
                if (LineageCache.probe(right.getInputs()[1])) {
                    inCache.put("deltaY", LineageCache.get(right.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isElementMulCbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        if (curr.getOpcode().equalsIgnoreCase("*")) {
            LineageItem left = items[0].getInputs()[0];
            LineageItem right = items[0].getInputs()[1];
            if (left.getOpcode().equalsIgnoreCase("cbind") && right.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem leftSource = left.getInputs()[0];
                LineageItem rightSource = right.getInputs()[0];
                LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{leftSource, rightSource});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.get(tmp));
                }
                if (LineageCache.probe(left.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.get(left.getInputs()[1]));
                }
                if (LineageCache.probe(right.getInputs()[1])) {
                    inCache.put("deltaY", LineageCache.get(right.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isAggCbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCache.isReusable(curr, ec)) {
            return false;
        }
        LineageItem[] items = ((ComputationCPInstruction)curr).getLineageItems(ec);
        if (curr.getOpcode().equalsIgnoreCase("groupedagg")) {
            LineageItem target = items[0].getInputs()[0];
            LineageItem groups = items[0].getInputs()[1];
            LineageItem weights = items[0].getInputs()[2];
            LineageItem fn = items[0].getInputs()[3];
            LineageItem ngroups = items[0].getInputs()[4];
            if (target.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem input1 = target.getInputs()[0];
                LineageItem tmp = new LineageItem("toProbe", curr.getOpcode(), new LineageItem[]{input1, groups, weights, fn, ngroups});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.get(tmp));
                }
                if (LineageCache.probe(target.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.get(target.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static ArrayList<Instruction> genInst(Hop hops, ExecutionContext ec) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ArrayList<Instruction> newInst = Recompiler.recompileHopsDag(hops, ec.getVariables(), null, true, true, 0L);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRwExecTime(System.nanoTime() - t0);
        }
        LOG.debug((Object)("EXPLAIN LINEAGE REWRITE \nGENERIC (line " + hops.getBeginLine() + "):\n" + Explain.explain(hops, 1)));
        LOG.debug((Object)("EXPLAIN LINEAGE REWRITE \nGENERIC (line " + hops.getBeginLine() + "):\n" + Explain.explain(newInst, 1)));
        return newInst;
    }

    private static void executeInst(ArrayList<Instruction> newInst, ExecutionContext lrwec) {
        DMLScript.EXPLAIN = Explain.ExplainType.NONE;
        try {
            long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            BasicProgramBlock pb = LineageRewriteReuse.getProgramBlock();
            pb.setInstructions(newInst);
            LineageCacheConfig.ReuseCacheType oldReuseOption = DMLScript.LINEAGE_REUSE;
            LineageCacheConfig.shutdownReuse();
            pb.execute(lrwec);
            LineageCacheConfig.restartReuse(oldReuseOption);
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementPRwExecTime(System.nanoTime() - t0);
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Error executing lineage rewrites", e);
        }
    }

    private static MatrixObject convMBtoMO(MatrixBlock cachedEntry) {
        MetaData md = new MetaData(cachedEntry.getDataCharacteristics());
        MatrixObject mo = new MatrixObject(Types.ValueType.FP64, "cachedEntry", md);
        mo.acquireModify(cachedEntry);
        mo.release();
        return mo;
    }

    private static ExecutionContext getExecutionContext() {
        if (_lrEC == null) {
            _lrEC = ExecutionContextFactory.createContext();
        }
        return _lrEC;
    }

    private static BasicProgramBlock getProgramBlock() {
        if (_lrPB == null) {
            _lrPB = new BasicProgramBlock(new Program());
        }
        return _lrPB;
    }
}

