/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tugraz.sysds.parser.ParseException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.InstructionParser;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.lineage.LineageTokenizer;
import org.tugraz.sysds.runtime.lineage.LineageTraceable;

public class LineageParser {
    public static LineageTokenizer lineageTraceTokenizer = new LineageTokenizer();

    public static LineageItem parseLineageTrace(String str) {
        return LineageParser.parseLineageTrace(str, null);
    }

    public static LineageItem parseLineageTrace(String str, String name) {
        ExecutionContext ec = ExecutionContextFactory.createContext();
        LineageItem li = null;
        HashMap<Long, LineageItem> map = new HashMap<Long, LineageItem>();
        for (String line : str.split("\\r?\\n")) {
            li = null;
            Map<String, String> tokens = lineageTraceTokenizer.tokenize(line);
            Long id = Long.valueOf(tokens.get("id"));
            LineageItem.LineageItemType type = LineageItemUtils.getType(tokens.get("type"));
            String representation = tokens.get("representation");
            switch (type) {
                case Creation: {
                    Instruction inst = InstructionParser.parseSingleInstruction(representation);
                    if (!(inst instanceof LineageTraceable)) {
                        throw new ParseException("Invalid Instruction (" + inst.getOpcode() + ") traced");
                    }
                    LineageItem[] items = ((LineageTraceable)((Object)inst)).getLineageItems(ec);
                    if (items == null) {
                        throw new ParseException("Instruction without output (" + inst.getOpcode() + ") not supported");
                    }
                    if (items.length != 1) {
                        throw new ParseException("Instruction with multiple outputs (" + inst.getOpcode() + ") not supported");
                    }
                    li = new LineageItem(id, items[0]);
                    break;
                }
                case Literal: {
                    li = new LineageItem(id, new CPOperand(representation).getName(), representation);
                    break;
                }
                case Instruction: {
                    li = LineageParser.parseLineageInstruction(id, representation, map, name);
                    break;
                }
                default: {
                    throw new ParseException("Invalid LineageItemType given");
                }
            }
            map.put(id, li);
        }
        return li;
    }

    private static LineageItem parseLineageInstruction(Long id, String str, Map<Long, LineageItem> map, String name) {
        ArrayList<LineageItem> inputs = new ArrayList<LineageItem>();
        String[] tokens = str.split(" ");
        if (tokens.length < 2) {
            throw new ParseException("Invalid length ot lineage item " + tokens.length + ".");
        }
        String opcode = tokens[0];
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!token.startsWith("(") || !token.endsWith(")")) {
                throw new ParseException("Invalid format for LineageItem reference");
            }
            token = token.substring(1, token.length() - 1);
            inputs.add(map.get(Long.valueOf(token)));
        }
        return new LineageItem(id, name, opcode, inputs.toArray(new LineageItem[0]));
    }

    static {
        lineageTraceTokenizer.add("\\(");
        lineageTraceTokenizer.add("[0-9]+", "id");
        lineageTraceTokenizer.add("\\) \\(");
        lineageTraceTokenizer.add("L|C|I", "type");
        lineageTraceTokenizer.add("\\) ");
        lineageTraceTokenizer.add(".+", "representation");
    }
}

