/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.util.HashMap;
import java.util.Map;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.WriteSPInstruction;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.lineage.LineageTraceable;
import org.tugraz.sysds.utils.Explain;

public class LineageMap {
    private Map<String, LineageItem> _traces = new HashMap<String, LineageItem>();
    private Map<String, LineageItem> _literals = new HashMap<String, LineageItem>();

    public LineageMap() {
    }

    public LineageMap(LineageMap that) {
        this._traces.putAll(that._traces);
        this._literals.putAll(that._literals);
    }

    public void trace(Instruction inst, ExecutionContext ec) {
        if (inst instanceof FunctionCallCPInstruction) {
            return;
        }
        if (!(inst instanceof LineageTraceable)) {
            throw new DMLRuntimeException("Unknown Instruction (" + inst.getOpcode() + ") traced.");
        }
        LineageItem[] items = ((LineageTraceable)((Object)inst)).getLineageItems(ec);
        if (items == null || items.length < 1) {
            this.trace(inst, ec, null);
        } else {
            for (LineageItem li : items) {
                this.trace(inst, ec, this.cleanupInputLiterals(li, ec));
            }
        }
    }

    public void processDedupItem(LineageMap lm, Long path) {
        for (Map.Entry<String, LineageItem> entry : lm._traces.entrySet()) {
            if (!this._traces.containsKey(entry.getKey())) continue;
            this.addLineageItem(new LineageItem(entry.getKey(), path.toString(), "dedup", new LineageItem[]{this._traces.get(entry.getKey()), entry.getValue()}));
        }
    }

    public LineageItem getOrCreate(CPOperand variable) {
        if (variable == null) {
            return null;
        }
        String varname = variable.getName();
        if (variable.isLiteral()) {
            LineageItem ret = this._literals.get(varname);
            if (ret == null) {
                ret = new LineageItem(varname, variable.getLineageLiteral());
                this._literals.put(varname, ret);
            }
            return ret;
        }
        LineageItem ret = this._traces.get(variable.getName());
        return ret != null ? ret : new LineageItem(varname, variable.getLineageLiteral());
    }

    public LineageItem get(String varName) {
        return this._traces.get(varName);
    }

    public LineageItem set(String varName, LineageItem li) {
        return this._traces.put(varName, li);
    }

    public LineageItem setLiteral(String varName, LineageItem li) {
        return this._literals.put(varName, li);
    }

    public LineageItem get(CPOperand variable) {
        if (variable == null) {
            return null;
        }
        return this._traces.get(variable.getName());
    }

    public boolean contains(CPOperand variable) {
        return this._traces.containsKey(variable.getName());
    }

    public boolean containsKey(String key) {
        return this._traces.containsKey(key);
    }

    public void resetLineageMaps() {
        this._traces.clear();
        this._literals.clear();
    }

    public Map<String, LineageItem> getTraces() {
        return this._traces;
    }

    public Map<String, LineageItem> getLiterals() {
        return this._literals;
    }

    private void trace(Instruction inst, ExecutionContext ec, LineageItem li) {
        block13: {
            block12: {
                if (!(inst instanceof VariableCPInstruction)) break block12;
                VariableCPInstruction vcp_inst = (VariableCPInstruction)inst;
                switch (vcp_inst.getVariableOpcode()) {
                    case AssignVariable: 
                    case CopyVariable: {
                        this.processCopyLI(li);
                        break;
                    }
                    case Read: 
                    case CreateVariable: {
                        if (li != null) {
                            this.addLineageItem(li);
                            break;
                        }
                        break block13;
                    }
                    case RemoveVariable: {
                        for (CPOperand input : vcp_inst.getInputs()) {
                            this.removeLineageItem(input.getName());
                        }
                        break block13;
                    }
                    case Write: {
                        this.processWriteLI(vcp_inst.getInput1(), vcp_inst.getInput2(), ec);
                        break;
                    }
                    case MoveVariable: {
                        this.processMoveLI(li);
                        break;
                    }
                    case CastAsBooleanVariable: 
                    case CastAsDoubleVariable: 
                    case CastAsIntegerVariable: 
                    case CastAsScalarVariable: 
                    case CastAsMatrixVariable: 
                    case CastAsFrameVariable: {
                        this.addLineageItem(li);
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unknown VariableCPInstruction (" + inst.getOpcode() + ") traced.");
                    }
                }
                break block13;
            }
            if (inst instanceof WriteSPInstruction) {
                this.processWriteLI(((WriteSPInstruction)inst).getInput1(), ((WriteSPInstruction)inst).getInput2(), ec);
            } else {
                this.addLineageItem(li);
            }
        }
    }

    private LineageItem cleanupInputLiterals(LineageItem li, ExecutionContext ec) {
        if (li.getInputs() == null) {
            return li;
        }
        for (int i = 0; i < li.getInputs().length; ++i) {
            CPOperand cp;
            LineageItem tmp = li.getInputs()[i];
            if (tmp.getType() != LineageItem.LineageItemType.Literal || !tmp.getData().endsWith("false") || !(cp = new CPOperand(tmp.getData())).getDataType().isScalar()) continue;
            cp.setLiteral(ec.getScalarInput(cp));
            li.getInputs()[i] = this.getOrCreate(cp);
        }
        return li;
    }

    private void processCopyLI(LineageItem li) {
        if (li.getInputs().length != 1) {
            throw new DMLRuntimeException("AssignVariable and CopyVariable must have one input lineage item!");
        }
        this._traces.put(li.getName(), li.getInputs()[0]);
    }

    private void removeLineageItem(String key) {
        this._traces.remove(key);
    }

    private void addLineageItem(LineageItem li) {
        this._traces.put(li.getName(), li);
    }

    private void processWriteLI(CPOperand input1, CPOperand input2, ExecutionContext ec) {
        LineageItem li = this.get(input1);
        String fName = ec.getScalarInput(input2.getName(), Types.ValueType.STRING, input2.isLiteral()).getStringValue();
        if (DMLScript.LINEAGE_DEDUP) {
            LineageItemUtils.writeTraceToHDFS(Explain.explain(li), fName + ".lineage.dedup");
            li = LineageItemUtils.rDecompress(li);
        }
        LineageItemUtils.writeTraceToHDFS(Explain.explain(li), fName + ".lineage");
    }

    private void processMoveLI(LineageItem li) {
        if (li.getName().equals("__pred")) {
            this.removeLineageItem(li.getInputs()[0].getName());
        } else {
            this._traces.put(li.getName(), li.getInputs()[0]);
        }
    }
}

