/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.hops.AggUnaryOp;
import org.tugraz.sysds.hops.BinaryOp;
import org.tugraz.sysds.hops.DataGenOp;
import org.tugraz.sysds.hops.DataOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.IndexingOp;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.MultiThreadedHop;
import org.tugraz.sysds.hops.ReorgOp;
import org.tugraz.sysds.hops.TernaryOp;
import org.tugraz.sysds.hops.UnaryOp;
import org.tugraz.sysds.hops.codegen.SpoofFusedOp;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;
import org.tugraz.sysds.lops.Binary;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.PartialAggregate;
import org.tugraz.sysds.lops.UnaryCP;
import org.tugraz.sysds.lops.compile.Dag;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.InstructionParser;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.tugraz.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.RandSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.lineage.LineageCache;
import org.tugraz.sysds.runtime.lineage.LineageCacheConfig;
import org.tugraz.sysds.runtime.lineage.LineageCodegenItem;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class LineageItemUtils {
    private static final String LVARPREFIX = "lvar";

    public static LineageItem.LineageItemType getType(String str) {
        if (str.length() == 1) {
            switch (str) {
                case "C": {
                    return LineageItem.LineageItemType.Creation;
                }
                case "L": {
                    return LineageItem.LineageItemType.Literal;
                }
                case "I": {
                    return LineageItem.LineageItemType.Instruction;
                }
                case "D": {
                    return LineageItem.LineageItemType.Dedup;
                }
            }
            throw new DMLRuntimeException("Unknown LineageItemType given!");
        }
        throw new DMLRuntimeException("Unknown LineageItemType given!");
    }

    private static String getString(LineageItem.LineageItemType lit) {
        switch (lit) {
            case Creation: {
                return "C";
            }
            case Literal: {
                return "L";
            }
            case Instruction: {
                return "I";
            }
            case Dedup: {
                return "D";
            }
        }
        throw new DMLRuntimeException("Unknown LineageItemType given!");
    }

    private static String getString(LineageItem li) {
        return LineageItemUtils.getString(li.getType());
    }

    public static String explainSingleLineageItem(LineageItem li) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(li.getId()).append(") ");
        sb.append("(").append(LineageItemUtils.getString(li)).append(") ");
        if (li.isLeaf()) {
            sb.append(li.getData()).append(" ");
        } else {
            if (li.getType() == LineageItem.LineageItemType.Dedup) {
                sb.append(li.getOpcode()).append(li.getData()).append(" ");
            } else {
                sb.append(li.getOpcode()).append(" ");
            }
            String ids = Arrays.stream(li.getInputs()).map(i -> String.format("(%d)", i.getId())).collect(Collectors.joining(" "));
            sb.append(ids);
        }
        return sb.toString().trim();
    }

    public static Data computeByLineage(LineageItem root) {
        long rootId = root.getOpcode().equals("write") ? root.getInputs()[0].getId() : root.getId();
        String varname = LVARPREFIX + rootId;
        root.resetVisitStatus();
        HashMap<Long, Hop> operands = new HashMap<Long, Hop>();
        LineageItemUtils.rConstructHops(root, operands);
        DataOp out = HopRewriteUtils.createTransientWrite(varname, (Hop)operands.get(rootId));
        ExecutionContext ec = ExecutionContextFactory.createContext();
        BasicProgramBlock pb = new BasicProgramBlock(new Program());
        Dag<Lop> dag = new Dag<Lop>();
        Lop lops = ((Hop)out).constructLops();
        lops.addToDag(dag);
        pb.setInstructions(dag.getJobs(null, ConfigurationManager.getDMLConfig()));
        LineageCache.resetCache();
        pb.execute(ec);
        return ec.getVariable(varname);
    }

    public static LineageItem[] getLineage(ExecutionContext ec, CPOperand ... operands) {
        return (LineageItem[])Arrays.stream(operands).filter(c -> c != null).map(c -> ec.getLineage().getOrCreate((CPOperand)c)).toArray(LineageItem[]::new);
    }

    private static void rConstructHops(LineageItem item, Map<Long, Hop> operands) {
        if (item.isVisited()) {
            return;
        }
        if (!item.isLeaf()) {
            for (LineageItem c : item.getInputs()) {
                LineageItemUtils.rConstructHops(c, operands);
            }
        }
        block0 : switch (item.getType()) {
            case Creation: {
                DataGenOp datagen;
                Instruction inst = InstructionParser.parseSingleInstruction(item.getData());
                if (inst instanceof DataGenCPInstruction) {
                    DataGenCPInstruction rand = (DataGenCPInstruction)inst;
                    HashMap<String, Hop> params = new HashMap<String, Hop>();
                    if (rand.output.getDataType() == Types.DataType.TENSOR) {
                        params.put("dims", new LiteralOp(rand.getDims()));
                    } else {
                        params.put("rows", new LiteralOp(rand.getRows()));
                        params.put("cols", new LiteralOp(rand.getCols()));
                    }
                    params.put("min", new LiteralOp(rand.getMinValue()));
                    params.put("max", new LiteralOp(rand.getMaxValue()));
                    params.put("pdf", new LiteralOp(rand.getPdf()));
                    params.put("lambda", new LiteralOp(rand.getPdfParams()));
                    params.put("sparsity", new LiteralOp(rand.getSparsity()));
                    params.put("seed", new LiteralOp(rand.getSeed()));
                    datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
                    datagen.setBlocksize(rand.getBlocksize());
                    operands.put(item.getId(), datagen);
                    break;
                }
                if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isCreateVariable()) {
                    String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst.toString());
                    Types.DataType dt = Types.DataType.valueOf(parts[4]);
                    Types.ValueType vt = dt == Types.DataType.MATRIX ? Types.ValueType.FP64 : Types.ValueType.STRING;
                    HashMap<String, Hop> params = new HashMap<String, Hop>();
                    params.put("iofilename", new LiteralOp(parts[2]));
                    params.put("rows", new LiteralOp(Long.parseLong(parts[6])));
                    params.put("cols", new LiteralOp(Long.parseLong(parts[7])));
                    params.put("nnz", new LiteralOp(Long.parseLong(parts[8])));
                    params.put("format", new LiteralOp(parts[5]));
                    DataOp pread = new DataOp(parts[1].substring(5), dt, vt, Types.OpOpData.PERSISTENTREAD, params);
                    pread.setFileName(parts[2]);
                    operands.put(item.getId(), pread);
                    break;
                }
                if (!(inst instanceof RandSPInstruction)) break;
                RandSPInstruction rand = (RandSPInstruction)inst;
                HashMap<String, Hop> params = new HashMap<String, Hop>();
                if (rand.output.getDataType() == Types.DataType.TENSOR) {
                    params.put("dims", new LiteralOp(rand.getDims()));
                } else {
                    params.put("rows", new LiteralOp(rand.getRows()));
                    params.put("cols", new LiteralOp(rand.getCols()));
                }
                params.put("min", new LiteralOp(rand.getMinValue()));
                params.put("max", new LiteralOp(rand.getMaxValue()));
                params.put("pdf", new LiteralOp(rand.getPdf()));
                params.put("lambda", new LiteralOp(rand.getPdfParams()));
                params.put("sparsity", new LiteralOp(rand.getSparsity()));
                params.put("seed", new LiteralOp(rand.getSeed()));
                datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
                datagen.setBlocksize(rand.getBlocksize());
                operands.put(item.getId(), datagen);
                break;
            }
            case Instruction: {
                CPInstruction.CPType ctype = InstructionUtils.getCPTypeByOpcode(item.getOpcode());
                SPInstruction.SPType stype = InstructionUtils.getSPTypeByOpcode(item.getOpcode());
                if (ctype != null) {
                    switch (ctype) {
                        case AggregateUnary: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            MultiThreadedHop aggunary = HopRewriteUtils.createAggUnaryOp(input, item.getOpcode());
                            operands.put(item.getId(), aggunary);
                            break block0;
                        }
                        case Unary: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            UnaryOp unary = HopRewriteUtils.createUnary(input, item.getOpcode());
                            operands.put(item.getId(), unary);
                            break block0;
                        }
                        case Reorg: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            ReorgOp reorg = HopRewriteUtils.createReorg(input, Types.ReOrgOp.TRANS);
                            operands.put(item.getId(), reorg);
                            break block0;
                        }
                        case Binary: {
                            String opcode = "^2".equals(item.getOpcode()) || "*2".equals(item.getOpcode()) ? item.getOpcode().substring(0, 1) : item.getOpcode();
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            BinaryOp binary = HopRewriteUtils.createBinary(input1, input2, opcode);
                            operands.put(item.getId(), binary);
                            break block0;
                        }
                        case AggregateBinary: {
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            AggBinaryOp aggbinary = HopRewriteUtils.createMatrixMultiply(input1, input2);
                            operands.put(item.getId(), aggbinary);
                            break block0;
                        }
                        case Ternary: {
                            operands.put(item.getId(), HopRewriteUtils.createTernaryOp(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), item.getOpcode()));
                            break block0;
                        }
                        case BuiltinNary: {
                            String opcode = item.getOpcode().equals("n+") ? "plus" : item.getOpcode();
                            operands.put(item.getId(), HopRewriteUtils.createNary(Types.OpOpN.valueOf(opcode.toUpperCase()), LineageItemUtils.createNaryInputs(item, operands)));
                            break block0;
                        }
                        case MatrixIndexing: {
                            operands.put(item.getId(), LineageItemUtils.constructIndexingOp(item, operands));
                            break block0;
                        }
                        case MMTSJ: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            MultiThreadedHop aggunary = HopRewriteUtils.createMatrixMultiply(HopRewriteUtils.createTranspose(input), input);
                            operands.put(item.getId(), aggunary);
                            break block0;
                        }
                        case Variable: {
                            operands.put(item.getId(), operands.get(item.getInputs()[0].getId()));
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Unsupported instruction type: " + ctype.name() + " (" + item.getOpcode() + ").");
                }
                if (stype != null) {
                    switch (stype) {
                        case Reblock: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            input.setBlocksize(ConfigurationManager.getBlocksize());
                            input.setRequiresReblock(true);
                            operands.put(item.getId(), input);
                            break block0;
                        }
                        case Checkpoint: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            operands.put(item.getId(), input);
                            break block0;
                        }
                        case MatrixIndexing: {
                            operands.put(item.getId(), LineageItemUtils.constructIndexingOp(item, operands));
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Unsupported instruction type: " + stype.name() + " (" + item.getOpcode() + ").");
                }
                throw new DMLRuntimeException("Unsupported instruction: " + item.getOpcode());
            }
            case Literal: {
                CPOperand op = new CPOperand(item.getData());
                operands.put(item.getId(), ScalarObjectFactory.createLiteralOp(op.getValueType(), op.getName()));
                break;
            }
            case Dedup: {
                throw new NotImplementedException();
            }
        }
        item.setVisited();
    }

    public static void constructLineageFromHops(Hop[] roots, String claName, Hop[] inputs, HashMap<Long, Hop> spoofmap) {
        if (LineageCodegenItem.getCodegenLTrace(claName) == null) {
            HashMap<Long, LineageItem> operands = new HashMap<Long, LineageItem>();
            for (Hop root : roots) {
                root.resetVisitStatus();
            }
            for (Hop root : roots) {
                LineageItemUtils.rConstructLineageFromHops(root, inputs, operands, spoofmap);
            }
            LineageItem out = (LineageItem)operands.get(roots[0].getHopID());
            if (roots.length > 1) {
                LineageItem[] outputs = (LineageItem[])Arrays.stream(roots).map(h -> new LineageItem("", "castdtm", new LineageItem[]{(LineageItem)operands.get(h.getHopID())})).toArray(LineageItem[]::new);
                out = new LineageItem("", "cbind", outputs);
            }
            LineageCodegenItem.setCodegenLTrace(claName, out);
            for (Hop root : roots) {
                root.resetVisitStatus();
            }
        }
    }

    public static void rConstructLineageFromHops(Hop root, Hop[] inputs, Map<Long, LineageItem> operands, HashMap<Long, Hop> spoofmap) {
        boolean spoof;
        if (root.isVisited()) {
            return;
        }
        boolean bl = spoof = root instanceof SpoofFusedOp && ArrayUtils.contains((Object[])inputs, (Object)spoofmap.get(root.getHopID()));
        if (ArrayUtils.contains((Object[])inputs, (Object)root) || spoof) {
            Hop tmp = spoof ? spoofmap.get(root.getHopID()) : root;
            int pos = ArrayUtils.indexOf((Object[])inputs, (Object)tmp);
            LineageItem li = new LineageItem(String.valueOf(pos), "InputPlaceholder", "Create" + String.valueOf(root.getHopID()));
            operands.put(tmp.getHopID(), li);
            return;
        }
        for (int i = 0; i < root.getInput().size(); ++i) {
            LineageItemUtils.rConstructLineageFromHops(root.getInput().get(i), inputs, operands, spoofmap);
        }
        LineageItem li = null;
        LineageItem[] LIinputs = (LineageItem[])root.getInput().stream().map(h -> ArrayUtils.contains((Object[])inputs, spoofmap.get(h.getHopID())) ? (Hop)spoofmap.get(h.getHopID()) : h).map(h -> (LineageItem)operands.get(h.getHopID())).toArray(LineageItem[]::new);
        String name = Dag.getNextUniqueVarname(root.getDataType());
        if (root instanceof ReorgOp) {
            li = new LineageItem(name, "r'", LIinputs);
        } else if (root instanceof UnaryOp) {
            String opcode = UnaryCP.getOpCode(Hop.HopsOpOp1LopsUS.get((Object)((UnaryOp)root).getOp()));
            li = new LineageItem(name, opcode, LIinputs);
        } else if (root instanceof AggBinaryOp) {
            li = new LineageItem(name, "ba+*", LIinputs);
        } else if (root instanceof BinaryOp) {
            li = new LineageItem(name, Binary.getOpcode(Hop.HopsOpOp2LopsB.get((Object)((BinaryOp)root).getOp())), LIinputs);
        } else if (root instanceof TernaryOp) {
            String opcode = ((TernaryOp)root).getOp().toString();
            li = new LineageItem(name, opcode, LIinputs);
        } else if (root instanceof AggUnaryOp) {
            Types.AggOp op = ((AggUnaryOp)root).getOp();
            Types.Direction dir = ((AggUnaryOp)root).getDirection();
            String opcode = PartialAggregate.getOpcode(op, dir);
            li = new LineageItem(name, opcode, LIinputs);
        } else if (root instanceof IndexingOp) {
            li = new LineageItem(name, "rightIndex", LIinputs);
        } else if (root instanceof SpoofFusedOp) {
            li = LineageCodegenItem.getCodegenLTrace(((SpoofFusedOp)root).getClassName());
        } else if (root instanceof LiteralOp) {
            StringBuilder sb = new StringBuilder(root.getName());
            sb.append("\u00b7");
            sb.append(root.getDataType().toString());
            sb.append("\u00b7");
            sb.append(root.getValueType().toString());
            sb.append("\u00b7");
            sb.append(true);
            li = new LineageItem(root.getName(), sb.toString());
        } else {
            throw new DMLRuntimeException("Unsupported hop: " + root.getOpString());
        }
        operands.put(root.getHopID(), li);
        root.setVisited();
    }

    private static Hop constructIndexingOp(LineageItem item, Map<Long, Hop> operands) {
        if ("rightIndex".equals(item.getOpcode())) {
            return HopRewriteUtils.createIndexingOp(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), operands.get(item.getInputs()[3].getId()), operands.get(item.getInputs()[4].getId()));
        }
        if ("leftIndex".equals(item.getOpcode()) || "mapLeftIndex".equals(item.getOpcode())) {
            return HopRewriteUtils.createLeftIndexingOp(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), operands.get(item.getInputs()[3].getId()), operands.get(item.getInputs()[4].getId()), operands.get(item.getInputs()[5].getId()));
        }
        throw new DMLRuntimeException("Unsupported opcode: " + item.getOpcode());
    }

    public static LineageItem rDecompress(LineageItem item) {
        if (item.getType() == LineageItem.LineageItemType.Dedup) {
            LineageItem dedupInput = LineageItemUtils.rDecompress(item.getInputs()[0]);
            ArrayList<LineageItem> inputs = new ArrayList<LineageItem>();
            for (LineageItem li : item.getInputs()[1].getInputs()) {
                inputs.add(LineageItemUtils.rDecompress(li));
            }
            LineageItem li = new LineageItem(item.getInputs()[1].getName(), item.getInputs()[1].getData(), item.getInputs()[1].getOpcode(), inputs.toArray(new LineageItem[0]));
            li.resetVisitStatus();
            LineageItemUtils.rSetDedupInputOntoOutput(item.getName(), li, dedupInput);
            li.resetVisitStatus();
            return li;
        }
        ArrayList<LineageItem> inputs = new ArrayList<LineageItem>();
        if (item.getInputs() != null) {
            for (LineageItem li : item.getInputs()) {
                inputs.add(LineageItemUtils.rDecompress(li));
            }
        }
        return new LineageItem(item.getName(), item.getData(), item.getOpcode(), inputs.toArray(new LineageItem[0]));
    }

    public static void writeTraceToHDFS(String trace, String fname) {
        try {
            HDFSTool.writeStringToHDFS(trace, fname);
            FileSystem fs = IOUtilFunctions.getFileSystem(fname);
            if (fs instanceof LocalFileSystem) {
                Path path = new Path(fname);
                IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static void rSetDedupInputOntoOutput(String name, LineageItem item, LineageItem dedupInput) {
        if (item.isVisited()) {
            return;
        }
        if (item.getInputs() != null) {
            for (int i = 0; i < item.getInputs().length; ++i) {
                LineageItem li = item.getInputs()[i];
                if (li.getName().equals(name)) {
                    item.getInputs()[i] = dedupInput;
                }
                LineageItemUtils.rSetDedupInputOntoOutput(name, li, dedupInput);
            }
        }
        item.setVisited();
    }

    public static LineageItem replace(LineageItem root, LineageItem liOld, LineageItem liNew) {
        root.resetVisitStatus();
        LineageItemUtils.rReplace(root, liOld, liNew);
        root.resetVisitStatus();
        return root;
    }

    private static void rReplace(LineageItem current, LineageItem liOld, LineageItem liNew) {
        if (current.isVisited() || current.getInputs() == null) {
            return;
        }
        if (liNew == null) {
            throw new DMLRuntimeException("Invalid null lineage item for " + liOld.getName());
        }
        for (int i = 0; i < current.getInputs().length; ++i) {
            LineageItem tmp = current.getInputs()[i];
            if (liOld.equals(tmp)) {
                current.getInputs()[i] = liNew;
                continue;
            }
            LineageItemUtils.rReplace(tmp, liOld, liNew);
        }
        current.setVisited();
    }

    public static void replaceDagLeaves(ExecutionContext ec, LineageItem root, CPOperand[] newLeaves) {
        root.resetVisitStatus();
        LineageItemUtils.rReplaceDagLeaves(root, LineageItemUtils.getLineage(ec, newLeaves));
        root.resetVisitStatus();
    }

    public static void rReplaceDagLeaves(LineageItem root, LineageItem[] newleaves) {
        if (root.isVisited() || root.isLeaf()) {
            return;
        }
        for (int i = 0; i < root.getInputs().length; ++i) {
            LineageItem li = root.getInputs()[i];
            if (li.isLeaf() && li.getType() != LineageItem.LineageItemType.Literal) {
                root.getInputs()[i] = newleaves[Integer.parseInt(li.getName())];
                continue;
            }
            LineageItemUtils.rReplaceDagLeaves(li, newleaves);
        }
        root.setVisited();
    }

    public static void rGetDagLeaves(HashSet<LineageItem> leaves, LineageItem root) {
        if (root.isVisited()) {
            return;
        }
        if (root.isLeaf()) {
            leaves.add(root);
        } else {
            for (LineageItem li : root.getInputs()) {
                LineageItemUtils.rGetDagLeaves(leaves, li);
            }
        }
        root.setVisited();
    }

    private static Hop[] createNaryInputs(LineageItem item, Map<Long, Hop> operands) {
        int len = item.getInputs().length;
        Hop[] ret = new Hop[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = operands.get(item.getInputs()[i].getId());
        }
        return ret;
    }

    public static boolean containsRandDataGen(HashSet<LineageItem> entries, LineageItem root) {
        if (entries.contains(root) || root.isVisited()) {
            return false;
        }
        boolean isRand = false;
        if (LineageItemUtils.isNonDeterministic(root)) {
            isRand |= true;
        }
        if (!root.isLeaf()) {
            for (LineageItem input : root.getInputs()) {
                isRand = isRand ? true : LineageItemUtils.containsRandDataGen(entries, input);
            }
        }
        root.setVisited();
        return isRand;
    }

    private static boolean isNonDeterministic(LineageItem li) {
        if (li.getType() != LineageItem.LineageItemType.Creation) {
            return false;
        }
        boolean isND = false;
        DataGenCPInstruction cprand = null;
        RandSPInstruction sprand = null;
        Instruction ins = InstructionParser.parseSingleInstruction(li.getData());
        if (ins instanceof DataGenCPInstruction) {
            cprand = (DataGenCPInstruction)ins;
        } else if (ins instanceof RandSPInstruction) {
            sprand = (RandSPInstruction)ins;
        } else {
            return false;
        }
        switch (li.getOpcode().toUpperCase()) {
            case "RAND": {
                if (cprand != null && (cprand.getMinValue() != cprand.getMaxValue() || cprand.getSparsity() != 1.0)) {
                    isND = true;
                }
                if (sprand == null || sprand.getMinValue() == sprand.getMaxValue() && sprand.getSparsity() == 1.0) break;
                isND = true;
                break;
            }
            case "SAMPLE": {
                isND = true;
                break;
            }
            default: {
                isND = false;
            }
        }
        return isND;
    }

    public static LineageItem[] getLineageItemInputstoSB(ArrayList<String> inputs, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return null;
        }
        ArrayList<CPOperand> CPOpInputs = inputs.size() > 0 ? new ArrayList<CPOperand>() : null;
        for (int i = 0; i < inputs.size(); ++i) {
            Data value = ec.getVariable(inputs.get(i));
            if (value == null) continue;
            CPOpInputs.add(new CPOperand(value instanceof ScalarObject ? value.toString() : inputs.get(i), value.getValueType(), value.getDataType()));
        }
        return CPOpInputs != null ? LineageItemUtils.getLineage(ec, CPOpInputs.toArray(new CPOperand[CPOpInputs.size()])) : null;
    }
}

