/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class LineageItem {
    private static IDSequence _idSeq = new IDSequence();
    private final long _id;
    private final String _opcode;
    private String _name;
    private final String _data;
    private final LineageItem[] _inputs;
    private int _hash = 0;
    private boolean _visited = true;
    public static final String dedupItemOpcode = "dedup";

    public LineageItem(long id, String name, String data) {
        this(id, name, data, "", null);
    }

    public LineageItem(long id, String name, String opcode, LineageItem[] inputs) {
        this(id, name, "", opcode, inputs);
    }

    public LineageItem(String name) {
        this(_idSeq.getNextID(), name, name, "", null);
    }

    public LineageItem(String name, String data) {
        this(_idSeq.getNextID(), name, data, "", null);
    }

    public LineageItem(String name, String data, String opcode) {
        this(_idSeq.getNextID(), name, data, opcode, null);
    }

    public LineageItem(String name, String opcode, LineageItem[] inputs) {
        this(_idSeq.getNextID(), name, "", opcode, inputs);
    }

    public LineageItem(String name, String data, String opcode, LineageItem[] inputs) {
        this(_idSeq.getNextID(), name, data, opcode, inputs);
    }

    public LineageItem(long id, String name, String data, String opcode, LineageItem[] inputs) {
        this._id = id;
        this._opcode = opcode;
        this._name = name;
        this._data = data;
        this._inputs = inputs;
    }

    public LineageItem(long id, LineageItem li) {
        this._id = id;
        this._opcode = li._opcode;
        this._name = li._name;
        this._data = li._data;
        this._inputs = li._inputs;
    }

    public LineageItem(LineageItem other) {
        this._id = _idSeq.getNextID();
        this._opcode = other._opcode;
        this._name = other._name;
        this._data = other._data;
        this._visited = other._visited;
        this._hash = other._hash;
        this._inputs = other._inputs;
    }

    public LineageItem[] getInputs() {
        return this._inputs;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getData() {
        return this._data;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public long getId() {
        return this._id;
    }

    public String getOpcode() {
        return this._opcode;
    }

    public LineageItemType getType() {
        if (this._opcode.equals(dedupItemOpcode)) {
            return LineageItemType.Dedup;
        }
        if (this.isLeaf() && this.isInstruction()) {
            return LineageItemType.Creation;
        }
        if (this.isLeaf() && !this.isInstruction()) {
            return LineageItemType.Literal;
        }
        if (!this.isLeaf() && this.isInstruction()) {
            return LineageItemType.Instruction;
        }
        throw new DMLRuntimeException("An inner node could not be a literal!");
    }

    public String toString() {
        return LineageItemUtils.explainSingleLineageItem(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LineageItem)) {
            return false;
        }
        this.resetVisitStatus();
        boolean ret = this.equalsLI((LineageItem)o);
        this.resetVisitStatus();
        return ret;
    }

    private boolean equalsLI(LineageItem that) {
        if (this.isVisited() || this == that) {
            return true;
        }
        boolean ret = this._opcode.equals(that._opcode);
        if (this.getType() == LineageItemType.Creation) {
            String this_data = this._data.replace(this._name, "");
            String that_data = that._data.replace(that._name, "");
            ret &= this_data.equals(that_data);
        } else {
            ret &= this._data.equals(that._data);
        }
        if (this._inputs != null && ret && this._inputs.length == that._inputs.length) {
            for (int i = 0; i < this._inputs.length; ++i) {
                ret &= this._inputs[i].equalsLI(that._inputs[i]);
            }
        }
        this.setVisited();
        return ret;
    }

    public int hashCode() {
        if (this._hash == 0) {
            int h = this._opcode.hashCode();
            if (this._inputs != null) {
                for (LineageItem li : this._inputs) {
                    h = UtilFunctions.intHashCode(h, li.hashCode());
                }
            }
            this._hash = UtilFunctions.intHashCode(h, (this.getType() == LineageItemType.Creation ? this._data.replace(this._name, "") : this._data).hashCode());
        }
        return this._hash;
    }

    public LineageItem deepCopy() {
        if (this.isLeaf()) {
            return new LineageItem(this);
        }
        LineageItem[] copyInputs = new LineageItem[this.getInputs().length];
        for (int i = 0; i < this._inputs.length; ++i) {
            copyInputs[i] = this._inputs[i].deepCopy();
        }
        return new LineageItem(this._name, this._opcode, copyInputs);
    }

    public boolean isLeaf() {
        return this._inputs == null || this._inputs.length == 0;
    }

    public boolean isInstruction() {
        return !this._opcode.isEmpty();
    }

    public LineageItem resetVisitStatus() {
        if (!this.isVisited()) {
            return this;
        }
        if (this._inputs != null) {
            for (LineageItem li : this.getInputs()) {
                li.resetVisitStatus();
            }
        }
        this.setVisited(false);
        return this;
    }

    public static void resetVisitStatus(LineageItem[] lis) {
        if (lis != null) {
            for (LineageItem liRoot : lis) {
                liRoot.resetVisitStatus();
            }
        }
    }

    public static void resetIDSequence() {
        _idSeq.reset(-1L);
    }

    public static enum LineageItemType {
        Literal,
        Creation,
        Instruction,
        Dedup;

    }
}

