/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.IfProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.lineage.LineageDedupBlock;

public class LineageDedupUtils {
    public static LineageDedupBlock computeDedupBlock(ForProgramBlock fpb, ExecutionContext ec) {
        LineageDedupBlock ldb = new LineageDedupBlock();
        ec.getLineage().pushInitDedupBlock(ldb);
        ldb.addBlock();
        for (ProgramBlock pb : fpb.getChildBlocks()) {
            if (pb instanceof IfProgramBlock) {
                ldb.traceIfProgramBlock((IfProgramBlock)pb, ec);
                continue;
            }
            if (pb instanceof BasicProgramBlock) {
                ldb.traceBasicProgramBlock((BasicProgramBlock)pb, ec);
                continue;
            }
            if (pb instanceof ForProgramBlock) {
                ldb.splitBlocks();
                continue;
            }
            throw new DMLRuntimeException("Only BasicProgramBlocks or IfProgramBlocks are allowed inside a LineageDedupBlock.");
        }
        ldb.removeLastBlockIfEmpty();
        ec.getLineage().popInitDedupBlock();
        return ldb;
    }
}

