/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.cost.CostEstimatorStaticRuntime;
import org.tugraz.sysds.lops.MMTSJ;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.instructions.CPInstructionParser;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.BinaryMatrixMatrixCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.lineage.LineageCacheConfig;
import org.tugraz.sysds.runtime.lineage.LineageCacheStatistics;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.lineage.LineageRewriteReuse;
import org.tugraz.sysds.runtime.lineage.LineageTraceable;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.runtime.util.LocalFileUtils;

public class LineageCache {
    private static final Map<LineageItem, Entry> _cache = new HashMap<LineageItem, Entry>();
    private static final Map<LineageItem, SpilledItem> _spillList = new HashMap<LineageItem, SpilledItem>();
    private static final HashSet<LineageItem> _removelist = new HashSet();
    private static final double CACHE_FRAC = 0.05;
    private static final long CACHE_LIMIT;
    private static String outdir;
    private static long _cachesize;
    private static Entry _head;
    private static Entry _end;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuse(Instruction inst, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return false;
        }
        boolean reuse = false;
        if (inst instanceof ComputationCPInstruction && LineageCache.isReusable(inst, ec)) {
            LineageItem item = ((ComputationCPInstruction)inst).getLineageItems(ec)[0];
            Map<LineageItem, Entry> map = _cache;
            synchronized (map) {
                if (LineageCacheConfig.getCacheType().isFullReuse()) {
                    reuse = LineageCache.fullReuse(item, (ComputationCPInstruction)inst, ec);
                }
                if (LineageCacheConfig.getCacheType().isPartialReuse()) {
                    reuse |= LineageRewriteReuse.executeRewrites(inst, ec);
                }
                if (reuse && DMLScript.STATISTICS) {
                    LineageCacheStatistics.incrementInstHits();
                }
                if (!reuse && LineageCache.isMarkedForCaching(inst, ec)) {
                    LineageCache.putIntern(item, null, 0.0);
                }
            }
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatrixBlock reuse(LineageItem item) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return null;
        }
        MatrixBlock d = null;
        Map<LineageItem, Entry> map = _cache;
        synchronized (map) {
            if (LineageCache.probe(item)) {
                d = LineageCache.get(item);
            } else {
                LineageCache.putIntern(item, null, 0.0);
            }
        }
        return d;
    }

    public static boolean reuse(List<String> outputs, int numOutputs, LineageItem[] liInputs, String name, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return false;
        }
        boolean reuse = numOutputs != 0;
        for (int i = 0; i < numOutputs; ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li = new LineageItem(outputs.get(i), opcode, liInputs);
            MatrixBlock cachedValue = LineageCache.reuse(li);
            if (cachedValue != null) {
                String boundVarName = outputs.get(i);
                MetaDataFormat md = new MetaDataFormat(cachedValue.getDataCharacteristics(), OutputInfo.BinaryCellOutputInfo, InputInfo.BinaryCellInputInfo);
                MatrixObject boundValue = new MatrixObject(Types.ValueType.FP64, boundVarName, md);
                boundValue.acquireModify(cachedValue);
                boundValue.release();
                Data exdata = ec.removeVariable(boundVarName);
                if (exdata != boundValue) {
                    ec.cleanupDataObject(exdata);
                }
                ec.setVariable(boundVarName, boundValue);
                LineageItem orig = _cache.get(li)._origItem;
                ec.getLineage().set(boundVarName, orig);
                continue;
            }
            reuse = false;
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(Instruction inst, ExecutionContext ec) {
        if (inst instanceof ComputationCPInstruction && LineageCache.isReusable(inst, ec)) {
            LineageItem item = ((LineageTraceable)((Object)inst)).getLineageItems(ec)[0];
            MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).output);
            Map<LineageItem, Entry> map = _cache;
            synchronized (map) {
                LineageCache.putIntern(item, (MatrixBlock)mo.acquireReadAndRelease(), LineageCache.getRecomputeEstimate(inst, ec));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(Instruction inst, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        if (inst instanceof ComputationCPInstruction && LineageCache.isReusable(inst, ec)) {
            if (!LineageCache.isMarkedForCaching(inst, ec)) {
                return;
            }
            LineageItem item = ((LineageTraceable)((Object)inst)).getLineageItems(ec)[0];
            MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).output);
            MatrixBlock value = (MatrixBlock)mo.acquireReadAndRelease();
            _cache.get(item).setValue(value, LineageCache.getRecomputeEstimate(inst, ec));
            Map<LineageItem, Entry> map = _cache;
            synchronized (map) {
                if (!LineageCache.isBelowThreshold(value)) {
                    LineageCache.makeSpace(value);
                }
                LineageCache.updateSize(value, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(LineageItem item, LineageItem probeItem) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        if (LineageCache.probe(probeItem)) {
            MatrixBlock value = LineageCache.get(probeItem);
            Entry e = _cache.get(item);
            e.setValue(value, 0.0);
            e._origItem = probeItem;
            Map<LineageItem, Entry> map = _cache;
            synchronized (map) {
                if (!LineageCache.isBelowThreshold(value)) {
                    LineageCache.makeSpace(value);
                }
                LineageCache.updateSize(value, true);
            }
        } else {
            LineageCache.removeEntry(item);
        }
    }

    public static void putValue(List<String> outputs, int numOutputs, LineageItem[] liInputs, String name, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        HashMap<LineageItem, LineageItem> FuncLIMap = new HashMap<LineageItem, LineageItem>();
        boolean AllOutputsCacheable = true;
        for (int i = 0; i < numOutputs; ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li = new LineageItem(outputs.get(i), opcode, liInputs);
            String boundVarName = outputs.get(i);
            LineageItem boundLI2 = ec.getLineage().get(boundVarName);
            Data boundValue = ec.getVariable(boundVarName);
            if (boundLI2 != null) {
                boundLI2.resetVisitStatus();
            }
            if (boundLI2 == null || !LineageCache.probe(li) || LineageItemUtils.containsRandDataGen(new HashSet<LineageItem>(Arrays.asList(liInputs)), boundLI2) || boundValue instanceof ScalarObject) {
                AllOutputsCacheable = false;
            }
            FuncLIMap.put(li, boundLI2);
        }
        if (AllOutputsCacheable) {
            FuncLIMap.forEach((Li, boundLI) -> LineageCache.putValue(Li, boundLI));
        } else {
            FuncLIMap.forEach((Li, boundLI) -> LineageCache.removeEntry(Li));
        }
    }

    private static void putIntern(LineageItem key, MatrixBlock value, double compcost) {
        if (_cache.containsKey(key)) {
            return;
        }
        Entry newItem = new Entry(key, value, compcost);
        if (value != null) {
            if (value.getInMemorySize() > CACHE_LIMIT) {
                return;
            }
            if (!LineageCache.isBelowThreshold(value)) {
                LineageCache.makeSpace(value);
            }
            LineageCache.updateSize(value, true);
        }
        LineageCache.setHead(newItem);
        _cache.put(key, newItem);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    protected static boolean probe(LineageItem key) {
        boolean p;
        boolean bl = p = _cache.containsKey(key) || _spillList.containsKey(key);
        if (!p && DMLScript.STATISTICS && _removelist.contains(key)) {
            LineageCacheStatistics.incrementDelHits();
        }
        return p;
    }

    public static void resetCache() {
        _cache.clear();
        _spillList.clear();
        _head = null;
        _end = null;
        if (DMLScript.STATISTICS) {
            _removelist.clear();
        }
    }

    private static boolean fullReuse(LineageItem item, ComputationCPInstruction inst, ExecutionContext ec) {
        if (LineageCache.probe(item)) {
            MatrixBlock d = LineageCache.get(item);
            ec.setMatrixOutput(inst.output.getName(), d);
            return true;
        }
        return false;
    }

    protected static MatrixBlock get(LineageItem key) {
        if (_cache.containsKey(key)) {
            Entry e = _cache.get(key);
            LineageCache.delete(e);
            LineageCache.setHead(e);
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementMemHits();
            }
            return e.getValue();
        }
        return LineageCache.readFromLocalFS(key);
    }

    public static boolean isReusable(Instruction inst, ExecutionContext ec) {
        return inst.getOpcode().equalsIgnoreCase("tsmm") || inst.getOpcode().equalsIgnoreCase("ba+*") || (inst.getOpcode().equalsIgnoreCase("*") || inst.getOpcode().equalsIgnoreCase("/")) && inst instanceof BinaryMatrixMatrixCPInstruction || inst.getOpcode().equalsIgnoreCase("rightIndex") || inst.getOpcode().equalsIgnoreCase("groupedagg") || inst.getOpcode().equalsIgnoreCase("r'") || inst.getOpcode().equalsIgnoreCase("append") && LineageCache.isVectorAppend(inst, ec) || inst.getOpcode().equalsIgnoreCase("solve") || inst.getOpcode().contains("spoof");
    }

    private static boolean isVectorAppend(Instruction inst, ExecutionContext ec) {
        ComputationCPInstruction cpinst = (ComputationCPInstruction)inst;
        if (!cpinst.input1.isMatrix() || !cpinst.input2.isMatrix()) {
            return false;
        }
        long c1 = ec.getMatrixObject(cpinst.input1).getNumColumns();
        long c2 = ec.getMatrixObject(cpinst.input2).getNumColumns();
        return c1 == 1L || c2 == 1L;
    }

    public static boolean isMarkedForCaching(Instruction inst, ExecutionContext ec) {
        if (!LineageCacheConfig.getCompAssRW()) {
            return true;
        }
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).output);
        boolean marked = LineageCacheConfig.getCacheType() != LineageCacheConfig.ReuseCacheType.REUSE_FULL || mo.isMarked();
        return marked;
    }

    private static boolean isBelowThreshold(MatrixBlock value) {
        return value.getInMemorySize() + _cachesize <= CACHE_LIMIT;
    }

    private static void makeSpace(MatrixBlock value) {
        double valSize = value.getInMemorySize();
        while (valSize + (double)_cachesize > (double)CACHE_LIMIT) {
            if (_cache.get(_end._key).isNullVal()) {
                LineageCache.setEnd2Head(_end);
                continue;
            }
            double reduction = _cache.get(_end._key).getValue().getInMemorySize();
            if (LineageCache._cache.get((Object)((Entry)LineageCache._end)._key)._compEst > LineageCache.getDiskSpillEstimate() && LineageCacheConfig.isSetSpill()) {
                LineageCache.spillToLocalFS();
            }
            LineageCache.removeEntry(reduction);
        }
    }

    private static void updateSize(MatrixBlock value, boolean addspace) {
        _cachesize = addspace ? (_cachesize += value.getInMemorySize()) : (_cachesize -= value.getInMemorySize());
    }

    private static double getDiskSpillEstimate() {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock mb = _cache.get(_end._key).getValue();
        long r = mb.getNumRows();
        long c = mb.getNumColumns();
        long nnz = mb.getNonZeros();
        double s = OptimizerUtils.getSparsity(r, c, nnz);
        double loadtime = CostEstimatorStaticRuntime.getFSReadTime(r, c, s);
        double writetime = CostEstimatorStaticRuntime.getFSWriteTime(r, c, s);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementCostingTime(System.nanoTime() - t0);
        }
        return loadtime + writetime;
    }

    private static double getRecomputeEstimate(Instruction inst, ExecutionContext ec) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        double nflops = 0.0;
        String instop = inst.getOpcode().contains("spoof") ? "spoof" : inst.getOpcode();
        CPInstruction.CPType cptype = CPInstructionParser.String2CPInstructionType.get(instop);
        switch (cptype) {
            case MMTSJ: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                MMTSJ.MMTSJType type = ((MMTSJCPInstruction)inst).getMMTSJType();
                if (type.isLeft()) {
                    nflops = !sparse ? (double)(r * c) * s * (double)c / 2.0 : (double)(r * c) * s * (double)c * s / 2.0;
                    break;
                }
                nflops = !sparse ? (double)r * (double)c * (double)r / 2.0 : (double)(r * c) * s + (double)(r * c) * s * (double)c * s / 2.0;
                break;
            }
            case AggregateBinary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                if (!lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * (c2 > 1L ? s1 : 1.0) * (double)c2) / 2.0;
                    break;
                }
                if (!lsparse && rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                    break;
                }
                if (lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2) / 2.0;
                    break;
                }
                nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                break;
            }
            case Binary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                if (inst.getOpcode().equalsIgnoreCase("*") || inst.getOpcode().equalsIgnoreCase("/")) {
                    nflops = r1 * c1;
                    break;
                }
                if (!inst.getOpcode().equalsIgnoreCase("solve")) break;
                nflops = r1 * c1 * c1;
                break;
            }
            case MatrixIndexing: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                if (!inst.getOpcode().equalsIgnoreCase("rightIndex")) break;
                nflops = 1.0 * (lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1));
                break;
            }
            case ParameterizedBuiltin: {
                String opcode = ((ParameterizedBuiltinCPInstruction)inst).getOpcode();
                HashMap<String, String> params = ((ParameterizedBuiltinCPInstruction)inst).getParameterMap();
                long r1 = ec.getMatrixObject(params.get("target")).getNumRows();
                String fn = params.get("fn");
                double xga = 0.0;
                if (opcode.equalsIgnoreCase("groupedagg")) {
                    if (fn.equalsIgnoreCase("sum")) {
                        xga = 4.0;
                    } else if (fn.equalsIgnoreCase("count")) {
                        xga = 1.0;
                    }
                }
                nflops = (double)(2L * r1) + xga * (double)r1;
                break;
            }
            case Reorg: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                nflops = sparse ? (double)(r * c) * s : (double)(r * c);
                break;
            }
            case Append: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                nflops = 1.0 * ((lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1)) + (rsparse ? (double)(r2 * c2) * s2 : (double)(r2 * c2)));
                break;
            }
            case SpoofFused: {
                nflops = 0.0;
                break;
            }
            default: {
                throw new DMLRuntimeException("Lineage Cache: unsupported instruction: " + inst.getOpcode());
            }
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            LineageCacheStatistics.incrementCostingTime(t1 - t0);
        }
        return nflops / 2.147483648E9;
    }

    private static void spillToLocalFS() {
        long t0;
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (outdir == null) {
            outdir = LocalFileUtils.getUniqueWorkingDir("lineage");
            LocalFileUtils.createLocalFileIfNotExist(outdir);
        }
        String outfile = outdir + "/" + _cache.get(_end._key)._key.getId();
        try {
            LocalFileUtils.writeMatrixBlockToLocal(outfile, _cache.get(_end._key).getValue());
        }
        catch (IOException e) {
            throw new DMLRuntimeException("Write to " + outfile + " failed.", e);
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            LineageCacheStatistics.incrementFSWriteTime(t1 - t0);
            LineageCacheStatistics.incrementFSWrites();
        }
        _spillList.put(_end._key, new SpilledItem(outfile, LineageCache._end._compEst));
    }

    private static MatrixBlock readFromLocalFS(LineageItem key) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock mb = null;
        try {
            mb = LocalFileUtils.readMatrixBlockFromLocal(LineageCache._spillList.get((Object)key)._outfile);
        }
        catch (IOException e) {
            throw new DMLRuntimeException("Read from " + LineageCache._spillList.get((Object)key)._outfile + " failed.", e);
        }
        LocalFileUtils.deleteFileIfExists(LineageCache._spillList.get((Object)key)._outfile, true);
        LineageCache.putIntern(key, mb, LineageCache._spillList.get((Object)key)._compEst);
        _spillList.remove(key);
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            LineageCacheStatistics.incrementFSReadTime(t1 - t0);
            LineageCacheStatistics.incrementFSHits();
        }
        return mb;
    }

    private static void delete(Entry entry) {
        if (entry._prev != null) {
            entry._prev._next = entry._next;
        } else {
            _head = entry._next;
        }
        if (entry._next != null) {
            entry._next._prev = entry._prev;
        } else {
            _end = entry._prev;
        }
    }

    private static void setHead(Entry entry) {
        entry._next = LineageCache._head;
        entry._prev = null;
        if (_head != null) {
            _head._prev = entry;
        }
        _head = entry;
        if (_end == null) {
            _end = _head;
        }
    }

    private static void setEnd2Head(Entry entry) {
        LineageCache.delete(entry);
        LineageCache.setHead(entry);
    }

    private static void removeEntry(double space) {
        if (DMLScript.STATISTICS) {
            _removelist.add(_end._key);
        }
        _cache.remove(_end._key);
        _cachesize = (long)((double)_cachesize - space);
        LineageCache.delete(_end);
    }

    public static void removeEntry(LineageItem key) {
        if (!_cache.containsKey(key)) {
            return;
        }
        LineageCache.delete(_cache.get(key));
        _cache.remove(key);
    }

    static {
        outdir = null;
        _cachesize = 0L;
        _head = null;
        _end = null;
        long maxMem = InfrastructureAnalyzer.getLocalMaxMemory();
        CACHE_LIMIT = (long)(0.05 * (double)maxMem);
    }

    private static class SpilledItem {
        String _outfile;
        double _compEst;

        public SpilledItem(String outfile, double computecost) {
            this._outfile = outfile;
            this._compEst = computecost;
        }
    }

    private static class Entry {
        private final LineageItem _key;
        private MatrixBlock _val;
        double _compEst;
        private Entry _prev;
        private Entry _next;
        private LineageItem _origItem;

        public Entry(LineageItem key, MatrixBlock value, double computecost) {
            this._key = key;
            this._val = value;
            this._compEst = computecost;
            this._origItem = null;
        }

        public synchronized MatrixBlock getValue() {
            try {
                while (this._val == null) {
                    this.wait();
                }
                return this._val;
            }
            catch (InterruptedException ex) {
                throw new DMLRuntimeException(ex);
            }
        }

        public boolean isNullVal() {
            return this._val == null;
        }

        public synchronized void setValue(MatrixBlock val, double compEst) {
            this._val = val;
            this._compEst = compEst;
            this.notifyAll();
        }
    }
}

