/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.tugraz.sysds.runtime.controlprogram.ForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.lineage.LineageCache;
import org.tugraz.sysds.runtime.lineage.LineageCacheConfig;
import org.tugraz.sysds.runtime.lineage.LineageDedupBlock;
import org.tugraz.sysds.runtime.lineage.LineageDedupUtils;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageMap;
import org.tugraz.sysds.runtime.lineage.LineageParser;
import org.tugraz.sysds.utils.Explain;

public class Lineage {
    private final LineageMap _map;
    private final Stack<LineageDedupBlock> _initDedupBlock = new Stack();
    private final Stack<LineageDedupBlock> _activeDedupBlock = new Stack();
    private final Map<ForProgramBlock, LineageDedupBlock> _dedupBlocks = new HashMap<ForProgramBlock, LineageDedupBlock>();

    public Lineage() {
        this._map = new LineageMap();
    }

    public Lineage(Lineage that) {
        this._map = new LineageMap(that._map);
    }

    public void trace(Instruction inst, ExecutionContext ec) {
        if (this._activeDedupBlock.empty()) {
            this._map.trace(inst, ec);
        }
    }

    public void tracePath(int block, Long path) {
        LineageMap lm = this._activeDedupBlock.peek().getMap(block, path);
        if (lm != null) {
            this._map.processDedupItem(lm, path);
        }
    }

    public LineageItem getOrCreate(CPOperand variable) {
        return this._initDedupBlock.empty() ? this._map.getOrCreate(variable) : this._initDedupBlock.peek().getActiveMap().getOrCreate(variable);
    }

    public boolean contains(CPOperand variable) {
        return this._initDedupBlock.empty() ? this._map.containsKey(variable.getName()) : this._initDedupBlock.peek().getActiveMap().containsKey(variable.getName());
    }

    public LineageItem get(String varName) {
        return this._map.get(varName);
    }

    public void set(String varName, LineageItem li) {
        this._map.set(varName, li);
    }

    public void setLiteral(String varName, LineageItem li) {
        this._map.setLiteral(varName, li);
    }

    public LineageItem get(CPOperand variable) {
        return this._initDedupBlock.empty() ? this._map.get(variable) : this._initDedupBlock.peek().getActiveMap().get(variable);
    }

    public void pushInitDedupBlock(LineageDedupBlock ldb) {
        this._initDedupBlock.push(ldb);
    }

    public LineageDedupBlock popInitDedupBlock() {
        return this._initDedupBlock.pop();
    }

    public void computeDedupBlock(ForProgramBlock fpb, ExecutionContext ec) {
        if (!this._dedupBlocks.containsKey(fpb)) {
            this._dedupBlocks.put(fpb, LineageDedupUtils.computeDedupBlock(fpb, ec));
        }
        this._activeDedupBlock.push(this._dedupBlocks.get(fpb));
    }

    public void clearDedupBlock() {
        this._activeDedupBlock.pop();
    }

    public Map<String, String> serialize() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, LineageItem> e : this._map.getTraces().entrySet()) {
            ret.put(e.getKey(), Explain.explain(e.getValue()));
        }
        return ret;
    }

    public static Lineage deserialize(Map<String, String> serialLineage) {
        Lineage ret = new Lineage();
        for (Map.Entry<String, String> e : serialLineage.entrySet()) {
            ret.set(e.getKey(), LineageParser.parseLineageTrace(e.getValue()));
        }
        return ret;
    }

    public static void resetInternalState() {
        LineageItem.resetIDSequence();
        LineageCache.resetCache();
    }

    public static void setLinReusePartial() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.REUSE_PARTIAL);
    }

    public static void setLinReuseFull() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.REUSE_FULL);
    }

    public static void setLinReuseFullAndPartial() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.REUSE_HYBRID);
    }

    public static void setLinReuseNone() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.NONE);
    }
}

