/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.lineage;

import java.util.HashMap;
import java.util.Map;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.IfProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.lineage.LineageMap;

public class DistinctPaths {
    private Map<Long, LineageMap> _distinctPaths = new HashMap<Long, LineageMap>();
    private Long _activePath = null;
    private int _branches = 0;

    public LineageMap getActiveMap() {
        if (this._activePath == null || !this._distinctPaths.containsKey(this._activePath)) {
            throw new DMLRuntimeException("Active path in LineageDedupBlock could not be found.");
        }
        return this._distinctPaths.get(this._activePath);
    }

    public LineageMap getMap(Long path) {
        if (!this._distinctPaths.containsKey(path)) {
            throw new DMLRuntimeException("Given path in LineageDedupBlock could not be found.");
        }
        return this._distinctPaths.get(path);
    }

    public boolean empty() {
        return this._distinctPaths.size() == 0;
    }

    public boolean pathExists(Long path) {
        return this._distinctPaths.containsKey(path);
    }

    public void traceIfProgramBlock(IfProgramBlock ipb, ExecutionContext ec) {
        this.addPathsForBranch();
        this.traceElseBodyInstructions(ipb, ec);
        this.traceIfBodyInstructions(ipb, ec);
        this._activePath = null;
    }

    public void traceBasicProgramBlock(BasicProgramBlock bpb, ExecutionContext ec) {
        if (this._distinctPaths.size() == 0) {
            this._distinctPaths.put(0L, new LineageMap());
        }
        for (Map.Entry<Long, LineageMap> entry : this._distinctPaths.entrySet()) {
            this.traceInstructions(bpb, ec, entry);
        }
        this._activePath = null;
    }

    private void traceIfBodyInstructions(IfProgramBlock ipb, ExecutionContext ec) {
        for (Map.Entry<Long, LineageMap> entry : this._distinctPaths.entrySet()) {
            if (entry.getKey() < (long)this._branches) continue;
            for (ProgramBlock pb : ipb.getChildBlocksIfBody()) {
                this.traceInstructions(pb, ec, entry);
            }
        }
    }

    private void traceElseBodyInstructions(IfProgramBlock ipb, ExecutionContext ec) {
        for (Map.Entry<Long, LineageMap> entry : this._distinctPaths.entrySet()) {
            if (entry.getKey() >= (long)this._branches) break;
            for (ProgramBlock pb : ipb.getChildBlocksElseBody()) {
                this.traceInstructions(pb, ec, entry);
            }
        }
    }

    private void traceInstructions(ProgramBlock pb, ExecutionContext ec, Map.Entry<Long, LineageMap> entry) {
        if (!(pb instanceof BasicProgramBlock)) {
            throw new DMLRuntimeException("Only BasicProgramBlocks are allowed inside a LineageDedupBlock.");
        }
        BasicProgramBlock bpb = (BasicProgramBlock)pb;
        for (Instruction inst : bpb.getInstructions()) {
            this._activePath = entry.getKey();
            entry.getValue().trace(inst, ec);
        }
    }

    private void addPathsForBranch() {
        if (this._distinctPaths.size() == 0) {
            this._distinctPaths.put(0L, new LineageMap());
            this._distinctPaths.put(1L, new LineageMap());
        } else {
            HashMap<Long, LineageMap> elseBranches = new HashMap<Long, LineageMap>();
            for (Map.Entry<Long, LineageMap> entry : this._distinctPaths.entrySet()) {
                Long pathIndex = entry.getKey() | (long)(1 << this._branches);
                elseBranches.put(pathIndex, new LineageMap(entry.getValue()));
            }
            this._distinctPaths.putAll(elseBranches);
        }
        ++this._branches;
    }
}

