/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.MatrixWriter;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class WriterTextLIBSVM
extends MatrixWriter {
    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Matrix dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        if (rlen == 0L || clen == 0L) {
            throw new IOException("Write of matrices with zero rows or columns not supported (" + rlen + "x" + clen + ").");
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        this.writeLIBSVMMatrixToHDFS(path, job, fs, src);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
    }

    protected void writeLIBSVMMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src) throws IOException {
        WriterTextLIBSVM.writeLIBSVMMatrixToFile(path, job, fs, src, 0, src.getNumRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeLIBSVMMatrixToFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int rlen) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int clen = src.getNumColumns();
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        try {
            StringBuilder sb = new StringBuilder();
            if (sparse) {
                SparseBlock sblock = src.getSparseBlock();
                for (int i = rl; i < rlen; ++i) {
                    double label = sblock != null ? sblock.get(i, clen - 1) : 0.0;
                    sb.append(label);
                    sb.append(" ");
                    if (sblock != null && i < sblock.numRows() && !sblock.isEmpty(i)) {
                        int pos = sblock.pos(i);
                        int alen = sblock.size(i);
                        int[] aix = sblock.indexes(i);
                        double[] avals = sblock.values(i);
                        for (int k = pos; k < pos + alen; ++k) {
                            if (aix[k] != clen - 1) {
                                WriterTextLIBSVM.appendIndexValLibsvm(sb, aix[k] + 1, avals[k]);
                            }
                            sb.append(" ");
                        }
                    }
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            } else {
                for (int i = rl; i < rlen; ++i) {
                    double label = src.getValueDenseUnsafe(i, clen - 1);
                    sb.append(label);
                    sb.append(" ");
                    for (int j = 0; j < clen - 1; ++j) {
                        double val = src.getValueDenseUnsafe(i, j);
                        if (val == 0.0) continue;
                        WriterTextLIBSVM.appendIndexValLibsvm(sb, j, val);
                        sb.append(" ");
                    }
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }

    protected static void appendIndexValLibsvm(StringBuilder sb, int index, double value) {
        sb.append(index + 1);
        sb.append(":");
        sb.append(value);
    }
}

