/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.MatrixWriter;
import org.tugraz.sysds.runtime.matrix.data.IJV;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixCell;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class WriterBinaryCell
extends MatrixWriter {
    @Override
    public void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        this.writeBinaryCellMatrixToHDFS(path, job, src, rlen, clen, blen);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        SequenceFile.Writer writer = null;
        try {
            writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixCell.class);
            MatrixIndexes index = new MatrixIndexes(1L, 1L);
            MatrixCell cell = new MatrixCell(0.0);
            writer.append((Writable)index, (Writable)cell);
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)writer);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBinaryCellMatrixToHDFS(Path path, JobConf job, MatrixBlock src, long rlen, long clen, int blen) throws IOException {
        boolean sparse = src.isInSparseFormat();
        boolean entriesWritten = false;
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixCell.class);
        MatrixIndexes indexes = new MatrixIndexes();
        MatrixCell cell = new MatrixCell();
        int rows = src.getNumRows();
        int cols = src.getNumColumns();
        try {
            if ((long)rows > rlen || (long)cols > clen) {
                throw new IOException("Matrix block [1:" + rows + ",1:" + cols + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            if (sparse) {
                Iterator<IJV> iter = src.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV lcell = iter.next();
                    indexes.setIndexes(lcell.getI() + 1, lcell.getJ() + 1);
                    cell.setValue(lcell.getV());
                    writer.append((Writable)indexes, (Writable)cell);
                    entriesWritten = true;
                }
            } else {
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        double lvalue = src.getValueDenseUnsafe(i, j);
                        if (lvalue == 0.0) continue;
                        indexes.setIndexes(i + 1, j + 1);
                        cell.setValue(lvalue);
                        writer.append((Writable)indexes, (Writable)cell);
                        entriesWritten = true;
                    }
                }
            }
            if (!entriesWritten) {
                writer.append((Writable)new MatrixIndexes(1L, 1L), (Writable)new MatrixCell(0.0));
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

